/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestTimestamps {
    @Test
    public void testDeprecatedTimestampTransform() {
        Types.TimestampType type = Types.TimestampType.withoutZone();
        Literal ts = Literal.of((CharSequence)"2017-12-01T10:12:55.038194").to((Type)type);
        Literal pts = Literal.of((CharSequence)"1970-01-01T00:00:01.000001").to((Type)type);
        Literal nts = Literal.of((CharSequence)"1969-12-31T23:59:58.999999").to((Type)type);
        Transform years = Transforms.year((Type)type);
        Assert.assertEquals((String)"Should produce 2017 - 1970 = 47", (long)47L, (long)((Integer)years.apply((Object)((Long)ts.value()))).intValue());
        Assert.assertEquals((String)"Should produce 1970 - 1970 = 0", (long)0L, (long)((Integer)years.apply((Object)((Long)pts.value()))).intValue());
        Assert.assertEquals((String)"Should produce 1969 - 1970 = -1", (long)-1L, (long)((Integer)years.apply((Object)((Long)nts.value()))).intValue());
        Transform months = Transforms.month((Type)type);
        Assert.assertEquals((String)"Should produce 47 * 12 + 11 = 575", (long)575L, (long)((Integer)months.apply((Object)((Long)ts.value()))).intValue());
        Assert.assertEquals((String)"Should produce 0 * 12 + 0 = 0", (long)0L, (long)((Integer)months.apply((Object)((Long)pts.value()))).intValue());
        Assert.assertEquals((String)"Should produce -1", (long)-1L, (long)((Integer)months.apply((Object)((Long)nts.value()))).intValue());
        Transform days = Transforms.day((Type)type);
        Assert.assertEquals((String)"Should produce 17501", (long)17501L, (long)((Integer)days.apply((Object)((Long)ts.value()))).intValue());
        Assert.assertEquals((String)"Should produce 0 * 365 + 0 = 0", (long)0L, (long)((Integer)days.apply((Object)((Long)pts.value()))).intValue());
        Assert.assertEquals((String)"Should produce -1", (long)-1L, (long)((Integer)days.apply((Object)((Long)nts.value()))).intValue());
        Transform hours = Transforms.hour((Type)type);
        Assert.assertEquals((String)"Should produce 17501 * 24 + 10", (long)420034L, (long)((Integer)hours.apply((Object)((Long)ts.value()))).intValue());
        Assert.assertEquals((String)"Should produce 0 * 24 + 0 = 0", (long)0L, (long)((Integer)hours.apply((Object)((Long)pts.value()))).intValue());
        Assert.assertEquals((String)"Should produce -1", (long)-1L, (long)((Integer)hours.apply((Object)((Long)nts.value()))).intValue());
    }

    @Test
    public void testTimestampTransform() {
        Types.TimestampType type = Types.TimestampType.withoutZone();
        Literal ts = Literal.of((CharSequence)"2017-12-01T10:12:55.038194").to((Type)type);
        Literal pts = Literal.of((CharSequence)"1970-01-01T00:00:01.000001").to((Type)type);
        Literal nts = Literal.of((CharSequence)"1969-12-31T23:59:58.999999").to((Type)type);
        Transform years = Transforms.year();
        Assert.assertEquals((String)"Should produce 2017 - 1970 = 47", (long)47L, (long)((Integer)years.bind((Type)type).apply((Object)((Long)ts.value()))).intValue());
        Assert.assertEquals((String)"Should produce 1970 - 1970 = 0", (long)0L, (long)((Integer)years.bind((Type)type).apply((Object)((Long)pts.value()))).intValue());
        Assert.assertEquals((String)"Should produce 1969 - 1970 = -1", (long)-1L, (long)((Integer)years.bind((Type)type).apply((Object)((Long)nts.value()))).intValue());
        Transform months = Transforms.month();
        Assert.assertEquals((String)"Should produce 47 * 12 + 11 = 575", (long)575L, (long)((Integer)months.bind((Type)type).apply((Object)((Long)ts.value()))).intValue());
        Assert.assertEquals((String)"Should produce 0 * 12 + 0 = 0", (long)0L, (long)((Integer)months.bind((Type)type).apply((Object)((Long)pts.value()))).intValue());
        Assert.assertEquals((String)"Should produce -1", (long)-1L, (long)((Integer)months.bind((Type)type).apply((Object)((Long)nts.value()))).intValue());
        Transform days = Transforms.day();
        Assert.assertEquals((String)"Should produce 17501", (long)17501L, (long)((Integer)days.bind((Type)type).apply((Object)((Long)ts.value()))).intValue());
        Assert.assertEquals((String)"Should produce 0 * 365 + 0 = 0", (long)0L, (long)((Integer)days.bind((Type)type).apply((Object)((Long)pts.value()))).intValue());
        Assert.assertEquals((String)"Should produce -1", (long)-1L, (long)((Integer)days.bind((Type)type).apply((Object)((Long)nts.value()))).intValue());
        Transform hours = Transforms.hour();
        Assert.assertEquals((String)"Should produce 17501 * 24 + 10", (long)420034L, (long)((Integer)hours.bind((Type)type).apply((Object)((Long)ts.value()))).intValue());
        Assert.assertEquals((String)"Should produce 0 * 24 + 0 = 0", (long)0L, (long)((Integer)hours.bind((Type)type).apply((Object)((Long)pts.value()))).intValue());
        Assert.assertEquals((String)"Should produce -1", (long)-1L, (long)((Integer)hours.bind((Type)type).apply((Object)((Long)nts.value()))).intValue());
    }

    @Test
    public void testTimestampWithoutZoneToHumanString() {
        Types.TimestampType type = Types.TimestampType.withoutZone();
        Literal date = Literal.of((CharSequence)"2017-12-01T10:12:55.038194").to((Type)type);
        Transform year = Transforms.year();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"2017", (Object)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Long)date.value())))));
        Transform month = Transforms.month();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"2017-12", (Object)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Long)date.value())))));
        Transform day = Transforms.day();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"2017-12-01", (Object)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Long)date.value())))));
        Transform hour = Transforms.hour();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"2017-12-01-10", (Object)hour.toHumanString((Type)type, (Object)((Integer)hour.bind((Type)type).apply((Object)((Long)date.value())))));
    }

    @Test
    public void testNegativeTimestampWithoutZoneToHumanString() {
        Types.TimestampType type = Types.TimestampType.withoutZone();
        Literal date = Literal.of((CharSequence)"1969-12-30T10:12:55.038194").to((Type)type);
        Transform year = Transforms.year();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969", (Object)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Long)date.value())))));
        Transform month = Transforms.month();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969-12", (Object)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Long)date.value())))));
        Transform day = Transforms.day();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969-12-30", (Object)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Long)date.value())))));
        Transform hour = Transforms.hour();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969-12-30-10", (Object)hour.toHumanString((Type)type, (Object)((Integer)hour.bind((Type)type).apply((Object)((Long)date.value())))));
    }

    @Test
    public void testNegativeTimestampWithoutZoneToHumanStringLowerBound() {
        Types.TimestampType type = Types.TimestampType.withoutZone();
        Literal date = Literal.of((CharSequence)"1969-12-30T00:00:00.000000").to((Type)type);
        Transform year = Transforms.year();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969", (Object)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Long)date.value())))));
        Transform month = Transforms.month();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969-12", (Object)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Long)date.value())))));
        Transform day = Transforms.day();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969-12-30", (Object)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Long)date.value())))));
        Transform hour = Transforms.hour();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969-12-30-00", (Object)hour.toHumanString((Type)type, (Object)((Integer)hour.bind((Type)type).apply((Object)((Long)date.value())))));
    }

    @Test
    public void testNegativeTimestampWithoutZoneToHumanStringUpperBound() {
        Types.TimestampType type = Types.TimestampType.withoutZone();
        Literal date = Literal.of((CharSequence)"1969-12-31T23:59:59.999999").to((Type)type);
        Transform year = Transforms.year();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969", (Object)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Long)date.value())))));
        Transform month = Transforms.month();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969-12", (Object)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Long)date.value())))));
        Transform day = Transforms.day();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969-12-31", (Object)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Long)date.value())))));
        Transform hour = Transforms.hour();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969-12-31-23", (Object)hour.toHumanString((Type)type, (Object)((Integer)hour.bind((Type)type).apply((Object)((Long)date.value())))));
    }

    @Test
    public void testTimestampWithZoneToHumanString() {
        Types.TimestampType type = Types.TimestampType.withZone();
        Literal date = Literal.of((CharSequence)"2017-12-01T10:12:55.038194-08:00").to((Type)type);
        Transform year = Transforms.year();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"2017", (Object)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Long)date.value())))));
        Transform month = Transforms.month();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"2017-12", (Object)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Long)date.value())))));
        Transform day = Transforms.day();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"2017-12-01", (Object)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Long)date.value())))));
        Transform hour = Transforms.hour();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"2017-12-01-18", (Object)hour.toHumanString((Type)type, (Object)((Integer)hour.bind((Type)type).apply((Object)((Long)date.value())))));
    }

    @Test
    public void testNullHumanString() {
        Types.TimestampType type = Types.TimestampType.withZone();
        Assert.assertEquals((String)"Should produce \"null\" for null", (Object)"null", (Object)Transforms.year().toHumanString((Type)type, null));
        Assert.assertEquals((String)"Should produce \"null\" for null", (Object)"null", (Object)Transforms.month().toHumanString((Type)type, null));
        Assert.assertEquals((String)"Should produce \"null\" for null", (Object)"null", (Object)Transforms.day().toHumanString((Type)type, null));
        Assert.assertEquals((String)"Should produce \"null\" for null", (Object)"null", (Object)Transforms.hour().toHumanString((Type)type, null));
    }

    @Test
    public void testTimestampsReturnType() {
        Types.TimestampType type = Types.TimestampType.withZone();
        Transform year = Transforms.year();
        Type yearResultType = year.getResultType((Type)type);
        Assert.assertEquals((Object)Types.IntegerType.get(), (Object)yearResultType);
        Transform month = Transforms.month();
        Type monthResultType = month.getResultType((Type)type);
        Assert.assertEquals((Object)Types.IntegerType.get(), (Object)monthResultType);
        Transform day = Transforms.day();
        Type dayResultType = day.getResultType((Type)type);
        Assert.assertEquals((Object)Types.DateType.get(), (Object)dayResultType);
        Transform hour = Transforms.hour();
        Type hourResultType = hour.getResultType((Type)type);
        Assert.assertEquals((Object)Types.IntegerType.get(), (Object)hourResultType);
    }
}

