/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.util.stream.Collectors;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestTimestampsProjection {
    private static final Types.TimestampType TYPE = Types.TimestampType.withoutZone();
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"timestamp", (Type)TYPE)});

    public void assertProjectionStrict(PartitionSpec spec, UnboundPredicate<?> filter, Expression.Operation expectedOp, String expectedLiteral) {
        Expression projection = Projections.strict((PartitionSpec)spec).project(filter);
        UnboundPredicate predicate = TestHelpers.assertAndUnwrapUnbound(projection);
        Assert.assertEquals((Object)expectedOp, (Object)predicate.op());
        Assert.assertNotEquals((String)"Strict projection never runs for IN", (Object)Expression.Operation.IN, (Object)predicate.op());
        Transform transform = ((PartitionField)spec.getFieldsBySourceId(1).get(0)).transform();
        Type type = spec.partitionType().field(((PartitionField)spec.getFieldsBySourceId(1).get(0)).fieldId()).type();
        if (predicate.op() == Expression.Operation.NOT_IN) {
            Iterable values = Iterables.transform((Iterable)predicate.literals(), Literal::value);
            String actual = Lists.newArrayList((Iterable)values).stream().sorted().map(v -> transform.toHumanString(type, v)).collect(Collectors.toList()).toString();
            Assert.assertEquals((Object)expectedLiteral, (Object)actual);
        } else {
            Literal literal = predicate.literal();
            String output = transform.toHumanString(type, (Object)((Integer)literal.value()));
            Assert.assertEquals((Object)expectedLiteral, (Object)output);
        }
    }

    public void assertProjectionStrictValue(PartitionSpec spec, UnboundPredicate<?> filter, Expression.Operation expectedOp) {
        Expression projection = Projections.strict((PartitionSpec)spec).project(filter);
        Assert.assertEquals((Object)expectedOp, (Object)projection.op());
    }

    public void assertProjectionInclusiveValue(PartitionSpec spec, UnboundPredicate<?> filter, Expression.Operation expectedOp) {
        Expression projection = Projections.inclusive((PartitionSpec)spec).project(filter);
        Assert.assertEquals((Object)expectedOp, (Object)projection.op());
    }

    public void assertProjectionInclusive(PartitionSpec spec, UnboundPredicate<?> filter, Expression.Operation expectedOp, String expectedLiteral) {
        Expression projection = Projections.inclusive((PartitionSpec)spec).project(filter);
        UnboundPredicate predicate = TestHelpers.assertAndUnwrapUnbound(projection);
        Assert.assertEquals((Object)expectedOp, (Object)predicate.op());
        Assert.assertNotEquals((String)"Inclusive projection never runs for NOT_IN", (Object)Expression.Operation.NOT_IN, (Object)predicate.op());
        Transform transform = ((PartitionField)spec.getFieldsBySourceId(1).get(0)).transform();
        Type type = spec.partitionType().field(((PartitionField)spec.getFieldsBySourceId(1).get(0)).fieldId()).type();
        if (predicate.op() == Expression.Operation.IN) {
            Iterable values = Iterables.transform((Iterable)predicate.literals(), Literal::value);
            String actual = Lists.newArrayList((Iterable)values).stream().sorted().map(v -> transform.toHumanString(type, v)).collect(Collectors.toList()).toString();
            Assert.assertEquals((Object)expectedLiteral, (Object)actual);
        } else {
            Literal literal = predicate.literal();
            String output = transform.toHumanString(type, (Object)((Integer)literal.value()));
            Assert.assertEquals((Object)expectedLiteral, (Object)output);
        }
    }

    @Test
    public void testDayStrictEpoch() {
        Long date = (long)((Long)Literal.of((CharSequence)"1970-01-01T00:00:00.00000").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("timestamp").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT, "1970-01-01");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT, "1970-01-01");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT, "1970-01-02");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT, "1970-01-01");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.NOT_EQ, "1970-01-01");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.FALSE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"1970-01-02T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionStrict(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.NOT_IN, "[1970-01-01, 1970-01-02]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testDayInclusiveEpoch() {
        Long date = (long)((Long)Literal.of((CharSequence)"1970-01-01T00:00:00.00000").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("timestamp").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "1970-01-01");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "1970-01-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "1970-01-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "1970-01-01");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.EQ, "1970-01-01");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.TRUE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"1970-01-02T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionInclusive(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.IN, "[1970-01-01, 1970-01-02]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testMonthStrictLowerBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"2017-12-01T00:00:00.00000").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("timestamp").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT, "2017-12");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT, "2017-12");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT, "2017-12");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT, "2017-11");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.NOT_EQ, "2017-12");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.FALSE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"2017-12-02T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionStrict(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{anotherDate, date}), Expression.Operation.NOT_IN, "[2017-12, 2017-12]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{anotherDate, date}), Expression.Operation.FALSE);
    }

    @Test
    public void testNegativeMonthStrictLowerBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"1969-01-01T00:00:00.00000").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("timestamp").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT, "1969-01");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT, "1969-01");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT, "1969-02");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT, "1969-01");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.NOT_IN, "[1969-01, 1969-02]");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.FALSE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"1969-03-01T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionStrict(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{anotherDate, date}), Expression.Operation.NOT_IN, "[1969-01, 1969-02, 1969-03, 1969-04]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{anotherDate, date}), Expression.Operation.FALSE);
    }

    @Test
    public void testMonthStrictUpperBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"2017-12-31T23:59:59.999999").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("timestamp").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT, "2017-12");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT, "2018-01");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT, "2017-12");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT, "2017-12");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.NOT_EQ, "2017-12");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.FALSE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"2017-11-02T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionStrict(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{anotherDate, date}), Expression.Operation.NOT_IN, "[2017-11, 2017-12]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{anotherDate, date}), Expression.Operation.FALSE);
    }

    @Test
    public void testNegativeMonthStrictUpperBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"1969-12-31T23:59:59.999999").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("timestamp").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT, "1969-12");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT, "1970-01");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT, "1970-01");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT, "1970-01");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.NOT_IN, "[1969-12, 1970-01]");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.FALSE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"1970-02-01T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionStrict(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{anotherDate, date}), Expression.Operation.NOT_IN, "[1969-12, 1970-01, 1970-02]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{anotherDate, date}), Expression.Operation.FALSE);
    }

    @Test
    public void testMonthInclusiveLowerBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"2017-12-01T00:00:00.00000").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("timestamp").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "2017-11");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "2017-12");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "2017-12");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "2017-12");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.EQ, "2017-12");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.TRUE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"2017-12-02T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionInclusive(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.IN, "[2017-12, 2017-12]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testNegativeMonthInclusiveLowerBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"1969-01-01T00:00:00.00000").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("timestamp").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "1969-01");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "1969-02");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "1969-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "1969-01");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.IN, "[1969-01, 1969-02]");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.TRUE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"1969-03-01T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionInclusive(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.IN, "[1969-01, 1969-02, 1969-03, 1969-04]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testMonthInclusiveUpperBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"2017-12-01T23:59:59.999999").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("timestamp").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "2017-12");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "2017-12");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "2017-12");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "2017-12");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.EQ, "2017-12");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.TRUE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"2017-11-02T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionInclusive(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.IN, "[2017-11, 2017-12]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testNegativeMonthInclusiveUpperBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"1969-12-31T23:59:59.999999").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("timestamp").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "1970-01");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "1970-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "1970-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "1969-12");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.IN, "[1969-12, 1970-01]");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.TRUE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"1970-01-01T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionInclusive(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.IN, "[1969-12, 1970-01]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testDayStrictLowerBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"2017-12-01T00:00:00.00000").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("timestamp").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT, "2017-12-01");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT, "2017-12-01");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT, "2017-12-01");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT, "2017-11-30");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.NOT_EQ, "2017-12-01");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.FALSE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"2017-12-02T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionStrict(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.NOT_IN, "[2017-12-01, 2017-12-02]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testNegativeDayStrictLowerBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"1969-01-01T00:00:00.00000").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("timestamp").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT, "1969-01-01");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT, "1969-01-01");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT, "1969-01-02");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT, "1969-01-01");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.NOT_IN, "[1969-01-01, 1969-01-02]");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.FALSE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"1969-01-02T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionStrict(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.NOT_IN, "[1969-01-01, 1969-01-02, 1969-01-03]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testDayStrictUpperBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"2017-12-01T23:59:59.999999").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("timestamp").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT, "2017-12-01");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT, "2017-12-02");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT, "2017-12-01");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT, "2017-12-01");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.NOT_EQ, "2017-12-01");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.FALSE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"2017-11-02T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionStrict(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.NOT_IN, "[2017-11-02, 2017-12-01]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testNegativeDayStrictUpperBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"1969-12-31T23:59:59.999999").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("timestamp").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT, "1969-12-31");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT, "1970-01-01");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT, "1970-01-01");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT, "1970-01-01");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.NOT_IN, "[1969-12-31, 1970-01-01]");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.FALSE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"1970-01-01T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionStrict(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.NOT_IN, "[1969-12-31, 1970-01-01]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testDayInclusiveLowerBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"2017-12-01T00:00:00.00000").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("timestamp").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "2017-11-30");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "2017-12-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "2017-12-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "2017-12-01");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.EQ, "2017-12-01");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.TRUE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"2017-12-02T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionInclusive(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.IN, "[2017-12-01, 2017-12-02]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testNegativeDayInclusiveLowerBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"1969-01-01T00:00:00.00000").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("timestamp").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "1969-01-01");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "1969-01-02");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "1969-01-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "1969-01-01");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.IN, "[1969-01-01, 1969-01-02]");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.TRUE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"1969-01-02T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionInclusive(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.IN, "[1969-01-01, 1969-01-02, 1969-01-03]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testDayInclusiveUpperBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"2017-12-01T23:59:59.999999").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("timestamp").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "2017-12-01");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "2017-12-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "2017-12-02");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "2017-12-01");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.EQ, "2017-12-01");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.TRUE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"2017-12-02T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionInclusive(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.IN, "[2017-12-01, 2017-12-02]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testNegativeDayInclusiveUpperBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"1969-12-31T23:59:59.999999").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("timestamp").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "1970-01-01");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "1970-01-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "1970-01-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "1969-12-31");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.IN, "[1969-12-31, 1970-01-01]");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.TRUE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"1970-01-01T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionInclusive(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.IN, "[1969-12-31, 1970-01-01]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testYearStrictLowerBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"2017-01-01T00:00:00.00000").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).year("timestamp").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT, "2017");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT, "2017");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT, "2017");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT, "2016");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.NOT_EQ, "2017");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.FALSE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"2016-12-02T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionStrict(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.NOT_IN, "[2016, 2017]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testYearStrictUpperBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"2017-12-31T23:59:59.999999").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).year("timestamp").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT, "2017");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT, "2018");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT, "2017");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT, "2017");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.NOT_EQ, "2017");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.FALSE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"2016-12-31T23:59:59.999999").to((Type)TYPE).value());
        this.assertProjectionStrict(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.NOT_IN, "[2016, 2017]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testYearInclusiveLowerBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"2017-01-01T00:00:00.00000").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).year("timestamp").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "2016");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "2017");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "2017");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "2017");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.EQ, "2017");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.TRUE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"2016-12-02T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionInclusive(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.IN, "[2016, 2017]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testYearInclusiveUpperBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"2017-12-31T23:59:59.999999").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).year("timestamp").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "2017");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "2017");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "2018");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "2017");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.EQ, "2017");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.TRUE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"2016-12-31T23:59:59.999999").to((Type)TYPE).value());
        this.assertProjectionInclusive(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.IN, "[2016, 2017]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testHourStrictLowerBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"2017-12-01T10:00:00.00000").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).hour("timestamp").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT, "2017-12-01-10");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT, "2017-12-01-10");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT, "2017-12-01-10");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT, "2017-12-01-09");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.NOT_EQ, "2017-12-01-10");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.FALSE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"2016-12-02T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionStrict(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.NOT_IN, "[2016-12-02-00, 2017-12-01-10]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testHourStrictUpperBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"2017-12-01T10:59:59.999999").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).hour("timestamp").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT, "2017-12-01-10");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT, "2017-12-01-11");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT, "2017-12-01-10");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT, "2017-12-01-10");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.NOT_EQ, "2017-12-01-10");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.FALSE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"2016-12-31T23:59:59.999999").to((Type)TYPE).value());
        this.assertProjectionStrict(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.NOT_IN, "[2016-12-31-23, 2017-12-01-10]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testHourInclusiveLowerBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"2017-12-01T10:00:00.00000").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).hour("timestamp").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "2017-12-01-09");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "2017-12-01-10");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "2017-12-01-10");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "2017-12-01-10");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.EQ, "2017-12-01-10");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.TRUE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"2016-12-02T00:00:00.00000").to((Type)TYPE).value());
        this.assertProjectionInclusive(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.IN, "[2016-12-02-00, 2017-12-01-10]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testHourInclusiveUpperBound() {
        Long date = (long)((Long)Literal.of((CharSequence)"2017-12-01T10:59:59.999999").to((Type)TYPE).value());
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).hour("timestamp").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "2017-12-01-10");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.LT_EQ, "2017-12-01-10");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "2017-12-01-11");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"timestamp", (Object)date), Expression.Operation.GT_EQ, "2017-12-01-10");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"timestamp", (Object)date), Expression.Operation.EQ, "2017-12-01-10");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"timestamp", (Object)date), Expression.Operation.TRUE);
        Long anotherDate = (long)((Long)Literal.of((CharSequence)"2016-12-31T23:59:59.999999").to((Type)TYPE).value());
        this.assertProjectionInclusive(spec, Expressions.in((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.IN, "[2016-12-31-23, 2017-12-01-10]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"timestamp", (Object[])new Long[]{date, anotherDate}), Expression.Operation.TRUE);
    }
}

