/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SerializableFunction;
import org.junit.Assert;
import org.junit.Test;

public class TestTransformSerialization {
    @Test
    public void testFunctionSerialization() throws Exception {
        Type[] types = new Type[]{Types.BooleanType.get(), Types.IntegerType.get(), Types.LongType.get(), Types.FloatType.get(), Types.DoubleType.get(), Types.StringType.get(), Types.DateType.get(), Types.TimeType.get(), Types.TimestampType.withoutZone(), Types.TimestampType.withoutZone(), Types.BinaryType.get(), Types.FixedType.ofLength((int)4), Types.DecimalType.of((int)9, (int)4), Types.UUIDType.get()};
        Transform[] transforms = new Transform[]{Transforms.identity(), Transforms.bucket((int)1024), Transforms.year(), Transforms.month(), Transforms.day(), Transforms.hour(), Transforms.truncate((int)16)};
        for (Type type : types) {
            for (Transform transform : transforms) {
                Assert.assertEquals((Object)transform, (Object)TestHelpers.roundTripSerialize(transform));
                if (!transform.canTransform(type)) continue;
                SerializableFunction func = transform.bind(type);
                Assert.assertTrue((boolean)func.getClass().isInstance(TestHelpers.roundTripSerialize(func)));
            }
        }
    }
}

