/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.iceberg.transforms.Truncate;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SerializableFunction;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestTruncate {
    @Test
    public void testDeprecatedTruncateInteger() {
        Truncate trunc = Truncate.get((Type)Types.IntegerType.get(), (int)10);
        Assert.assertEquals((long)0L, (long)((Integer)trunc.apply((Object)0)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)trunc.apply((Object)1)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)trunc.apply((Object)5)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)trunc.apply((Object)9)).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)trunc.apply((Object)10)).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)trunc.apply((Object)11)).intValue());
        Assert.assertEquals((long)-10L, (long)((Integer)trunc.apply((Object)-1)).intValue());
        Assert.assertEquals((long)-10L, (long)((Integer)trunc.apply((Object)-5)).intValue());
        Assert.assertEquals((long)-10L, (long)((Integer)trunc.apply((Object)-10)).intValue());
        Assert.assertEquals((long)-20L, (long)((Integer)trunc.apply((Object)-11)).intValue());
    }

    @Test
    public void testTruncateInteger() {
        SerializableFunction trunc = Truncate.get((int)10).bind((Type)Types.IntegerType.get());
        Assert.assertEquals((long)0L, (long)((Integer)trunc.apply(0)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)trunc.apply(1)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)trunc.apply(5)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)trunc.apply(9)).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)trunc.apply(10)).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)trunc.apply(11)).intValue());
        Assert.assertEquals((long)-10L, (long)((Integer)trunc.apply(-1)).intValue());
        Assert.assertEquals((long)-10L, (long)((Integer)trunc.apply(-5)).intValue());
        Assert.assertEquals((long)-10L, (long)((Integer)trunc.apply(-10)).intValue());
        Assert.assertEquals((long)-20L, (long)((Integer)trunc.apply(-11)).intValue());
    }

    @Test
    public void testTruncateLong() {
        SerializableFunction trunc = Truncate.get((int)10).bind((Type)Types.LongType.get());
        Assert.assertEquals((long)0L, (long)((Long)trunc.apply(0L)));
        Assert.assertEquals((long)0L, (long)((Long)trunc.apply(1L)));
        Assert.assertEquals((long)0L, (long)((Long)trunc.apply(5L)));
        Assert.assertEquals((long)0L, (long)((Long)trunc.apply(9L)));
        Assert.assertEquals((long)10L, (long)((Long)trunc.apply(10L)));
        Assert.assertEquals((long)10L, (long)((Long)trunc.apply(11L)));
        Assert.assertEquals((long)-10L, (long)((Long)trunc.apply(-1L)));
        Assert.assertEquals((long)-10L, (long)((Long)trunc.apply(-5L)));
        Assert.assertEquals((long)-10L, (long)((Long)trunc.apply(-10L)));
        Assert.assertEquals((long)-20L, (long)((Long)trunc.apply(-11L)));
    }

    @Test
    public void testTruncateDecimal() {
        SerializableFunction trunc = Truncate.get((int)10).bind((Type)Types.DecimalType.of((int)9, (int)2));
        Assert.assertEquals((Object)new BigDecimal("12.30"), trunc.apply(new BigDecimal("12.34")));
        Assert.assertEquals((Object)new BigDecimal("12.30"), trunc.apply(new BigDecimal("12.30")));
        Assert.assertEquals((Object)new BigDecimal("12.20"), trunc.apply(new BigDecimal("12.29")));
        Assert.assertEquals((Object)new BigDecimal("0.00"), trunc.apply(new BigDecimal("0.05")));
        Assert.assertEquals((Object)new BigDecimal("-0.10"), trunc.apply(new BigDecimal("-0.05")));
    }

    @Test
    public void testTruncateString() {
        SerializableFunction trunc = Truncate.get((int)5).bind((Type)Types.StringType.get());
        Assert.assertEquals((String)"Should truncate strings longer than length", (Object)"abcde", trunc.apply("abcdefg"));
        Assert.assertEquals((String)"Should not pad strings shorter than length", (Object)"abc", trunc.apply("abc"));
        Assert.assertEquals((String)"Should not alter strings equal to length", (Object)"abcde", trunc.apply("abcde"));
    }

    @Test
    public void testTruncateByteBuffer() {
        SerializableFunction trunc = Truncate.get((int)4).bind((Type)Types.BinaryType.get());
        Assert.assertEquals((String)"Should truncate binary longer than length", (Object)ByteBuffer.wrap("abcd".getBytes(StandardCharsets.UTF_8)), trunc.apply(ByteBuffer.wrap("abcdefg".getBytes(StandardCharsets.UTF_8))));
        Assert.assertEquals((String)"Should not pad binary shorter than length", (Object)ByteBuffer.wrap("abc".getBytes(StandardCharsets.UTF_8)), trunc.apply(ByteBuffer.wrap("abc".getBytes(StandardCharsets.UTF_8))));
    }

    @Test
    public void testVerifiedIllegalWidth() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Truncate.get((int)0)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid truncate width: 0 (must be > 0)");
    }
}

