/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestBinaryComparator {
    @Test
    public void testBinaryUnsignedComparator() {
        ByteBuffer b1 = ByteBuffer.wrap(new byte[]{1, 1, 2});
        ByteBuffer b2 = ByteBuffer.wrap(new byte[]{1, -1, 2});
        Comparator cmp = Literal.of((ByteBuffer)b1).comparator();
        Assert.assertTrue((String)"Negative bytes should sort after positive bytes", (cmp.compare(b1, b2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFixedUnsignedComparator() {
        ByteBuffer b1 = ByteBuffer.wrap(new byte[]{1, 1, 2});
        ByteBuffer b2 = ByteBuffer.wrap(new byte[]{1, -1, 2});
        Literal fixedLit = Literal.of((ByteBuffer)b1).to((Type)Types.FixedType.ofLength((int)3));
        Comparator cmp = fixedLit.comparator();
        Assert.assertTrue((String)"Negative bytes should sort after positive bytes", (cmp.compare(b1, b2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNullHandling() {
        ByteBuffer buf = ByteBuffer.allocate(0);
        Comparator cmp = Literal.of((ByteBuffer)buf).comparator();
        Assert.assertTrue((String)"null comes before non-null", (cmp.compare(null, buf) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"null comes before non-null", (cmp.compare(buf, null) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"null equals null", (long)0L, (long)cmp.compare(null, null));
    }
}

