/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.Comparator;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.expressions.Literal;
import org.junit.Assert;
import org.junit.Test;

public class TestCharSeqComparator {
    @Test
    public void testStringAndUtf8() {
        String s1 = "abc";
        Utf8 s2 = new Utf8("abc");
        Comparator stringComp = Literal.of((CharSequence)s1).comparator();
        Assert.assertEquals((String)"Should consider String and Utf8 equal", (long)0L, (long)stringComp.compare(s1, s2));
        Comparator utf8Comp = Literal.of((CharSequence)s2).comparator();
        Assert.assertEquals((String)"Should consider String and Utf8 equal", (long)0L, (long)utf8Comp.compare(s1, s2));
    }

    @Test
    public void testSeqLength() {
        String s1 = "abc";
        String s2 = "abcd";
        Comparator cmp = Literal.of((CharSequence)s1).comparator();
        Assert.assertTrue((String)"When one string is a substring of the other, the longer is greater", (s1.compareTo(s2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"When one string is a substring of the other, the longer is greater", (s2.compareTo(s1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"When one string is a substring of the other, the longer is greater", (cmp.compare(s1, s2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"When one string is a substring of the other, the longer is greater", (cmp.compare(s2, s1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCharOrderBeforeLength() {
        String s1 = "adc";
        String s2 = "abcd";
        Comparator cmp = Literal.of((CharSequence)s1).comparator();
        Assert.assertTrue((String)"First difference takes precedence over length", (s1.compareTo(s2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"First difference takes precedence over length", (s2.compareTo(s1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"First difference takes precedence over length", (cmp.compare(s1, s2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"First difference takes precedence over length", (cmp.compare(s2, s1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNullHandling() {
        String s1 = "abc";
        Comparator cmp = Literal.of((CharSequence)s1).comparator();
        Assert.assertTrue((String)"null comes before non-null", (cmp.compare(null, s1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"null comes before non-null", (cmp.compare(s1, null) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"null equals null", (long)0L, (long)cmp.compare(null, null));
    }
}

