/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.Comparator;
import org.apache.iceberg.expressions.Literal;
import org.junit.Assert;
import org.junit.Test;

public class TestComparableComparator {
    @Test
    public void testNaturalOrder() {
        Comparator cmp = Literal.of((long)34L).comparator();
        Assert.assertTrue((String)"Should use the natural order for non-null values", (cmp.compare(33L, 34L) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should use signed ordering", (cmp.compare(33L, -34L) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNullHandling() {
        Comparator cmp = Literal.of((long)34L).comparator();
        Assert.assertTrue((String)"null comes before non-null", (cmp.compare(null, 34L) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"null comes before non-null", (cmp.compare(34L, null) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"null equals null", (long)0L, (long)cmp.compare(null, null));
    }
}

