/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.CheckCompatibility;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestReadabilityChecks {
    private static final Type.PrimitiveType[] PRIMITIVES = new Type.PrimitiveType[]{Types.BooleanType.get(), Types.IntegerType.get(), Types.LongType.get(), Types.FloatType.get(), Types.DoubleType.get(), Types.DateType.get(), Types.TimeType.get(), Types.TimestampType.withoutZone(), Types.TimestampType.withZone(), Types.StringType.get(), Types.UUIDType.get(), Types.FixedType.ofLength((int)3), Types.FixedType.ofLength((int)4), Types.BinaryType.get(), Types.DecimalType.of((int)9, (int)2), Types.DecimalType.of((int)11, (int)2), Types.DecimalType.of((int)9, (int)3)};

    @Test
    public void testPrimitiveTypes() {
        for (Type.PrimitiveType from : PRIMITIVES) {
            Schema fromSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"from_field", (Type)from)});
            for (Type.PrimitiveType to : PRIMITIVES) {
                List errors = CheckCompatibility.writeCompatibilityErrors((Schema)new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)to)}), (Schema)fromSchema);
                if (TypeUtil.isPromotionAllowed((Type)from, (Type.PrimitiveType)to)) {
                    Assert.assertEquals((String)"Should produce 0 error messages", (long)0L, (long)errors.size());
                    continue;
                }
                Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
                Assert.assertTrue((String)"Should complain that promotion is not allowed", (boolean)((String)errors.get(0)).contains("cannot be promoted to"));
            }
            this.testDisallowPrimitiveToStruct(from, fromSchema);
            this.testDisallowPrimitiveToList(from, fromSchema);
            this.testDisallowPrimitiveToMap(from, fromSchema);
        }
    }

    private void testDisallowPrimitiveToMap(Type.PrimitiveType from, Schema fromSchema) {
        Schema mapSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"map_field", (Type)Types.MapType.ofRequired((int)2, (int)3, (Type)Types.StringType.get(), (Type)from))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)mapSchema, (Schema)fromSchema);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain that primitive to map is not allowed", (boolean)((String)errors.get(0)).contains("cannot be read as a map"));
    }

    private void testDisallowPrimitiveToList(Type.PrimitiveType from, Schema fromSchema) {
        Schema listSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"list_field", (Type)Types.ListType.ofRequired((int)2, (Type)from))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)listSchema, (Schema)fromSchema);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain that primitive to list is not allowed", (boolean)((String)errors.get(0)).contains("cannot be read as a list"));
    }

    private void testDisallowPrimitiveToStruct(Type.PrimitiveType from, Schema fromSchema) {
        Schema structSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"struct_field", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"from", (Type)from)}))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)structSchema, (Schema)fromSchema);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain that primitive to struct is not allowed", (boolean)((String)errors.get(0)).contains("cannot be read as a struct"));
    }

    @Test
    public void testRequiredSchemaField() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"from_field", (Type)Types.IntegerType.get())});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)Types.IntegerType.get())});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain that a required column is optional", (boolean)((String)errors.get(0)).contains("should be required, but is optional"));
    }

    @Test
    public void testMissingSchemaField() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"other_field", (Type)Types.IntegerType.get())});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)Types.IntegerType.get())});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain that a required column is missing", (boolean)((String)errors.get(0)).contains("is required, but is missing"));
    }

    @Test
    public void testRequiredStructField() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"from_field", (Type)Types.IntegerType.get())}))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)Types.IntegerType.get())}))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain that a required field is optional", (boolean)((String)errors.get(0)).contains("should be required, but is optional"));
    }

    @Test
    public void testMissingRequiredStructField() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"from_field", (Type)Types.IntegerType.get())}))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)Types.IntegerType.get())}))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain that a required field is missing", (boolean)((String)errors.get(0)).contains("is required, but is missing"));
    }

    @Test
    public void testMissingOptionalStructField() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"from_field", (Type)Types.IntegerType.get())}))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"to_field", (Type)Types.IntegerType.get())}))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce no error messages", (long)0L, (long)errors.size());
    }

    @Test
    public void testIncompatibleStructField() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"from_field", (Type)Types.IntegerType.get())}))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)Types.FloatType.get())}))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain about incompatible types", (boolean)((String)errors.get(0)).contains("cannot be promoted to float"));
    }

    @Test
    public void testIncompatibleStructAndPrimitive() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"from_field", (Type)Types.StringType.get())}))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StringType.get())});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain about incompatible types", (boolean)((String)errors.get(0)).contains("struct cannot be read as a string"));
    }

    @Test
    public void testMultipleErrors() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"from_field", (Type)Types.IntegerType.get())}))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)Types.FloatType.get())}))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce 1 error message", (long)2L, (long)errors.size());
        Assert.assertTrue((String)"Should complain that a required field is optional", (boolean)((String)errors.get(0)).contains("should be required, but is optional"));
        Assert.assertTrue((String)"Should complain about incompatible types", (boolean)((String)errors.get(1)).contains("cannot be promoted to float"));
    }

    @Test
    public void testRequiredMapValue() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_field", (Type)Types.MapType.ofOptional((int)1, (int)2, (Type)Types.StringType.get(), (Type)Types.IntegerType.get()))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_field", (Type)Types.MapType.ofRequired((int)1, (int)2, (Type)Types.StringType.get(), (Type)Types.IntegerType.get()))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain that values are optional", (boolean)((String)errors.get(0)).contains("values should be required, but are optional"));
    }

    @Test
    public void testIncompatibleMapKey() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_field", (Type)Types.MapType.ofOptional((int)1, (int)2, (Type)Types.IntegerType.get(), (Type)Types.StringType.get()))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_field", (Type)Types.MapType.ofOptional((int)1, (int)2, (Type)Types.DoubleType.get(), (Type)Types.StringType.get()))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain about incompatible types", (boolean)((String)errors.get(0)).contains("cannot be promoted to double"));
    }

    @Test
    public void testIncompatibleMapValue() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_field", (Type)Types.MapType.ofOptional((int)1, (int)2, (Type)Types.StringType.get(), (Type)Types.IntegerType.get()))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_field", (Type)Types.MapType.ofOptional((int)1, (int)2, (Type)Types.StringType.get(), (Type)Types.DoubleType.get()))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain about incompatible types", (boolean)((String)errors.get(0)).contains("cannot be promoted to double"));
    }

    @Test
    public void testIncompatibleMapAndPrimitive() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_field", (Type)Types.MapType.ofOptional((int)1, (int)2, (Type)Types.StringType.get(), (Type)Types.IntegerType.get()))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_field", (Type)Types.StringType.get())});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain about incompatible types", (boolean)((String)errors.get(0)).contains("map cannot be read as a string"));
    }

    @Test
    public void testRequiredListElement() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"list_field", (Type)Types.ListType.ofOptional((int)1, (Type)Types.IntegerType.get()))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"list_field", (Type)Types.ListType.ofRequired((int)1, (Type)Types.IntegerType.get()))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain that elements are optional", (boolean)((String)errors.get(0)).contains("elements should be required, but are optional"));
    }

    @Test
    public void testIncompatibleListElement() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"list_field", (Type)Types.ListType.ofOptional((int)1, (Type)Types.IntegerType.get()))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"list_field", (Type)Types.ListType.ofOptional((int)1, (Type)Types.StringType.get()))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain about incompatible types", (boolean)((String)errors.get(0)).contains("cannot be promoted to string"));
    }

    @Test
    public void testIncompatibleListAndPrimitive() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"list_field", (Type)Types.ListType.ofOptional((int)1, (Type)Types.IntegerType.get()))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"list_field", (Type)Types.StringType.get())});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain about incompatible types", (boolean)((String)errors.get(0)).contains("list cannot be read as a string"));
    }

    @Test
    public void testDifferentFieldOrdering() {
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"field_a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"field_b", (Type)Types.IntegerType.get())}))});
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"field_b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"field_a", (Type)Types.IntegerType.get())}))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write, (boolean)false);
        Assert.assertEquals((String)"Should produce 0 error message", (long)0L, (long)errors.size());
    }

    @Test
    public void testStructWriteReordering() {
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"field_a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"field_b", (Type)Types.IntegerType.get())}))});
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"field_b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"field_a", (Type)Types.IntegerType.get())}))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce 1 error message", (long)1L, (long)errors.size());
        Assert.assertTrue((String)"Should complain about field_b before field_a", (boolean)((String)errors.get(0)).contains("field_b is out of order, before field_a"));
    }

    @Test
    public void testStructReadReordering() {
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"field_a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"field_b", (Type)Types.IntegerType.get())}))});
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"field_b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"field_a", (Type)Types.IntegerType.get())}))});
        List errors = CheckCompatibility.readCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce no error messages", (long)0L, (long)errors.size());
    }

    @Test
    public void testCaseInsensitiveSchemaProjection() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"locations", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())})))});
        Assert.assertNotNull((Object)schema.caseInsensitiveSelect(new String[]{"ID"}).findField(0));
        Assert.assertNotNull((Object)schema.caseInsensitiveSelect(new String[]{"loCATIONs"}).findField(5));
        Assert.assertNotNull((Object)schema.caseInsensitiveSelect(new String[]{"LoCaTiOnS.LaT"}).findField(1));
        Assert.assertNotNull((Object)schema.caseInsensitiveSelect(new String[]{"locations.LONG"}).findField(2));
    }

    @Test
    public void testCheckNullabilityRequiredSchemaField() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"from_field", (Type)Types.IntegerType.get())});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)Types.IntegerType.get())});
        List errors = CheckCompatibility.typeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce no error messages", (long)0L, (long)errors.size());
    }

    @Test
    public void testCheckNullabilityRequiredStructField() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"from_field", (Type)Types.IntegerType.get())}))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)Types.IntegerType.get())}))});
        List errors = CheckCompatibility.typeCompatibilityErrors((Schema)read, (Schema)write);
        Assert.assertEquals((String)"Should produce no error messages", (long)0L, (long)errors.size());
    }
}

