/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestTypeUtil {
    @Test
    public void testReassignIdsDuplicateColumns() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"A", (Type)Types.IntegerType.get())});
        Schema sourceSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"A", (Type)Types.IntegerType.get())});
        Schema actualSchema = TypeUtil.reassignIds((Schema)schema, (Schema)sourceSchema);
        Assert.assertEquals((Object)sourceSchema.asStruct(), (Object)actualSchema.asStruct());
    }

    @Test
    public void testReassignIdsWithIdentifier() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)0, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"A", (Type)Types.IntegerType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{0}));
        Schema sourceSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"A", (Type)Types.IntegerType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{1}));
        Schema actualSchema = TypeUtil.reassignIds((Schema)schema, (Schema)sourceSchema);
        Assert.assertEquals((Object)sourceSchema.asStruct(), (Object)actualSchema.asStruct());
        Assert.assertEquals((String)"identifier field ID should change based on source schema", (Object)sourceSchema.identifierFieldIds(), (Object)actualSchema.identifierFieldIds());
    }

    @Test
    public void testAssignIncreasingFreshIdWithIdentifier() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{10}));
        Schema expectedSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"A", (Type)Types.IntegerType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{1}));
        Schema actualSchema = TypeUtil.assignIncreasingFreshIds((Schema)schema);
        Assert.assertEquals((Object)expectedSchema.asStruct(), (Object)actualSchema.asStruct());
        Assert.assertEquals((String)"identifier field ID should change based on source schema", (Object)expectedSchema.identifierFieldIds(), (Object)actualSchema.identifierFieldIds());
    }

    @Test
    public void testAssignIncreasingFreshIdNewIdentifier() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{10}));
        Schema sourceSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"A", (Type)Types.IntegerType.get())}));
        Schema actualSchema = TypeUtil.reassignIds((Schema)schema, (Schema)sourceSchema);
        Assert.assertEquals((Object)sourceSchema.asStruct(), (Object)actualSchema.asStruct());
        Assert.assertEquals((String)"source schema missing identifier should not impact refreshing new identifier", (Object)Sets.newHashSet((Object[])new Integer[]{sourceSchema.findField("a").fieldId()}), (Object)actualSchema.identifierFieldIds());
    }

    @Test
    public void testProject() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)14, (String)"B", (Type)Types.IntegerType.get()), Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)16, (String)"c", (Type)Types.IntegerType.get()), Types.NestedField.required((int)17, (String)"C", (Type)Types.IntegerType.get())}))}))}));
        Schema expectedTop = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get())}));
        Schema actualTop = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{11}));
        Assert.assertEquals((Object)expectedTop.asStruct(), (Object)actualTop.asStruct());
        Schema expectedDepthOne = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"b", (Type)Types.IntegerType.get())}))}));
        Schema actualDepthOne = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{10, 12, 13}));
        Assert.assertEquals((Object)expectedDepthOne.asStruct(), (Object)actualDepthOne.asStruct());
        Schema expectedDepthTwo = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)"C", (Type)Types.IntegerType.get())}))}))}));
        Schema actualDepthTwo = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{11, 12, 15, 17}));
        Schema actualDepthTwoChildren = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{11, 17}));
        Assert.assertEquals((Object)expectedDepthTwo.asStruct(), (Object)actualDepthTwo.asStruct());
        Assert.assertEquals((Object)expectedDepthTwo.asStruct(), (Object)actualDepthTwoChildren.asStruct());
    }

    @Test
    public void testProjectNaturallyEmpty() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"empty", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))}))}))}));
        Schema expectedDepthOne = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))}));
        Schema actualDepthOne = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{12}));
        Assert.assertEquals((Object)expectedDepthOne.asStruct(), (Object)actualDepthOne.asStruct());
        Schema expectedDepthTwo = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))}))}));
        Schema actualDepthTwo = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{12, 15}));
        Assert.assertEquals((Object)expectedDepthTwo.asStruct(), (Object)actualDepthTwo.asStruct());
        Schema expectedDepthThree = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"empty", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))}))}))}));
        Schema actualDepthThree = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{12, 15, 20}));
        Schema actualDepthThreeChildren = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{20}));
        Assert.assertEquals((Object)expectedDepthThree.asStruct(), (Object)actualDepthThree.asStruct());
        Assert.assertEquals((Object)expectedDepthThree.asStruct(), (Object)actualDepthThreeChildren.asStruct());
    }

    @Test
    public void testProjectEmpty() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)14, (String)"B", (Type)Types.IntegerType.get()), Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)16, (String)"c", (Type)Types.IntegerType.get()), Types.NestedField.required((int)17, (String)"C", (Type)Types.IntegerType.get())}))}))}));
        Schema expectedDepthOne = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))}));
        Schema actualDepthOne = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{12}));
        Assert.assertEquals((Object)expectedDepthOne.asStruct(), (Object)actualDepthOne.asStruct());
        Schema expectedDepthTwo = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))}))}));
        Schema actualDepthTwo = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{12, 15}));
        Assert.assertEquals((Object)expectedDepthTwo.asStruct(), (Object)actualDepthTwo.asStruct());
    }

    @Test
    public void testSelect() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)14, (String)"B", (Type)Types.IntegerType.get()), Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)16, (String)"c", (Type)Types.IntegerType.get()), Types.NestedField.required((int)17, (String)"C", (Type)Types.IntegerType.get())}))}))}));
        Schema expectedTop = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get())}));
        Schema actualTop = TypeUtil.select((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{11}));
        Assert.assertEquals((Object)expectedTop.asStruct(), (Object)actualTop.asStruct());
        Schema expectedDepthOne = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)14, (String)"B", (Type)Types.IntegerType.get()), Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)16, (String)"c", (Type)Types.IntegerType.get()), Types.NestedField.required((int)17, (String)"C", (Type)Types.IntegerType.get())}))}))}));
        Schema actualDepthOne = TypeUtil.select((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{10, 12}));
        Assert.assertEquals((Object)expectedDepthOne.asStruct(), (Object)actualDepthOne.asStruct());
        Schema expectedDepthTwo = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)"C", (Type)Types.IntegerType.get())}))}))}));
        Schema actualDepthTwo = TypeUtil.select((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{11, 17}));
        Assert.assertEquals((Object)expectedDepthTwo.asStruct(), (Object)actualDepthTwo.asStruct());
    }

    @Test
    public void testProjectMap() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"map", (Type)Types.MapType.ofRequired((int)13, (int)14, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)100, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)101, (String)"y", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)200, (String)"z", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)201, (String)"innerMap", (Type)Types.MapType.ofOptional((int)202, (int)203, (Type)Types.IntegerType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)300, (String)"foo", (Type)Types.IntegerType.get()), Types.NestedField.required((int)301, (String)"bar", (Type)Types.IntegerType.get())})))})))}));
        Assert.assertThrows((String)"Cannot project maps explicitly", IllegalArgumentException.class, () -> TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{12})));
        Assert.assertThrows((String)"Cannot project maps explicitly", IllegalArgumentException.class, () -> TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{201})));
        Schema expectedTopLevel = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get())}));
        Schema actualTopLevel = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{10}));
        Assert.assertEquals((Object)expectedTopLevel.asStruct(), (Object)actualTopLevel.asStruct());
        Schema expectedDepthOne = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"map", (Type)Types.MapType.ofRequired((int)13, (int)14, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)100, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)101, (String)"y", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0])))}));
        Schema actualDepthOne = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{10, 13, 14, 100, 101}));
        Schema actualDepthOneNoKeys = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{10, 13, 14}));
        Assert.assertEquals((Object)expectedDepthOne.asStruct(), (Object)actualDepthOne.asStruct());
        Assert.assertEquals((Object)expectedDepthOne.asStruct(), (Object)actualDepthOneNoKeys.asStruct());
        Schema expectedDepthTwo = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"map", (Type)Types.MapType.ofRequired((int)13, (int)14, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)100, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)101, (String)"y", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)200, (String)"z", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)201, (String)"innerMap", (Type)Types.MapType.ofOptional((int)202, (int)203, (Type)Types.IntegerType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0])))})))}));
        Schema actualDepthTwo = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{10, 13, 14, 100, 101, 200, 202, 203}));
        Assert.assertEquals((Object)expectedDepthTwo.asStruct(), (Object)actualDepthTwo.asStruct());
    }

    @Test
    public void testGetProjectedIds() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"A", (Type)Types.IntegerType.get()), Types.NestedField.required((int)35, (String)"emptyStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0])), Types.NestedField.required((int)12, (String)"someStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)14, (String)"B", (Type)Types.IntegerType.get()), Types.NestedField.required((int)15, (String)"anotherStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)16, (String)"c", (Type)Types.IntegerType.get()), Types.NestedField.required((int)17, (String)"C", (Type)Types.IntegerType.get())}))}))}));
        HashSet expectedIds = Sets.newHashSet((Object[])new Integer[]{10, 11, 35, 12, 13, 14, 15, 16, 17});
        Set actualIds = TypeUtil.getProjectedIds((Schema)schema);
        Assert.assertEquals((Object)expectedIds, (Object)actualIds);
    }

    @Test
    public void testProjectListNested() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"list", (Type)Types.ListType.ofRequired((int)13, (Type)Types.ListType.ofRequired((int)14, (Type)Types.MapType.ofRequired((int)15, (int)16, (Type)Types.IntegerType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.required((int)18, (String)"y", (Type)Types.IntegerType.get())})))))}));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{12}))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot explicitly project List or Map types");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{13}))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot explicitly project List or Map types");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{14}))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot explicitly project List or Map types");
        Schema expected = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"list", (Type)Types.ListType.ofRequired((int)13, (Type)Types.ListType.ofRequired((int)14, (Type)Types.MapType.ofRequired((int)15, (int)16, (Type)Types.IntegerType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0])))))}));
        Schema actual = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{16}));
        Assert.assertEquals((Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testProjectMapNested() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"map", (Type)Types.MapType.ofRequired((int)13, (int)14, (Type)Types.IntegerType.get(), (Type)Types.MapType.ofRequired((int)15, (int)16, (Type)Types.IntegerType.get(), (Type)Types.ListType.ofRequired((int)17, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)18, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.required((int)19, (String)"y", (Type)Types.IntegerType.get())})))))}));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{12}))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot explicitly project List or Map types");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{14}))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot explicitly project List or Map types");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{16}))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot explicitly project List or Map types");
        Schema expected = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"map", (Type)Types.MapType.ofRequired((int)13, (int)14, (Type)Types.IntegerType.get(), (Type)Types.MapType.ofRequired((int)15, (int)16, (Type)Types.IntegerType.get(), (Type)Types.ListType.ofRequired((int)17, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0])))))}));
        Schema actual = TypeUtil.project((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{17}));
        Assert.assertEquals((Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testReassignIdsIllegalArgumentException() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"b", (Type)Types.IntegerType.get())});
        Schema sourceSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get())});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.reassignIds((Schema)schema, (Schema)sourceSchema)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Field b not found in source schema");
    }

    @Test
    public void testValidateSchemaViaIndexByName() {
        Types.NestedField nestedType = Types.NestedField.required((int)1, (String)"a", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"b", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"c", (Type)Types.BooleanType.get())})), Types.NestedField.required((int)4, (String)"b.c", (Type)Types.BooleanType.get())}));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtil.indexByName((Types.StructType)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{nestedType}))).isInstanceOf(RuntimeException.class)).hasMessageContaining("Invalid schema: multiple fields for name a.b.c");
    }

    @Test
    public void testSelectNot() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"lat", (Type)Types.DoubleType.get()), Types.NestedField.required((int)4, (String)"long", (Type)Types.DoubleType.get())}))}));
        Schema expectedNoPrimitive = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"lat", (Type)Types.DoubleType.get()), Types.NestedField.required((int)4, (String)"long", (Type)Types.DoubleType.get())}))}));
        Schema actualNoPrimitve = TypeUtil.selectNot((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{1}));
        Assert.assertEquals((Object)expectedNoPrimitive.asStruct(), (Object)actualNoPrimitve.asStruct());
        Schema expectedNoStructElements = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())});
        Schema actualNoStructElements = TypeUtil.selectNot((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{3, 4}));
        Assert.assertEquals((Object)expectedNoStructElements.asStruct(), (Object)actualNoStructElements.asStruct());
        Schema actualNoStruct = TypeUtil.selectNot((Schema)schema, (Set)Sets.newHashSet((Object[])new Integer[]{2}));
        Assert.assertEquals((Object)schema.asStruct(), (Object)actualNoStruct.asStruct());
    }

    @Test
    public void testReassignOrRefreshIds() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"c", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"B", (Type)Types.IntegerType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{10}));
        Schema sourceSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)15, (String)"B", (Type)Types.IntegerType.get())}));
        Schema actualSchema = TypeUtil.reassignOrRefreshIds((Schema)schema, (Schema)sourceSchema);
        Schema expectedSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)16, (String)"c", (Type)Types.IntegerType.get()), Types.NestedField.required((int)15, (String)"B", (Type)Types.IntegerType.get())}));
        Assert.assertEquals((Object)expectedSchema.asStruct(), (Object)actualSchema.asStruct());
    }

    @Test
    public void testReassignOrRefreshIdsCaseInsensitive() {
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"FIELD1", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"FIELD2", (Type)Types.IntegerType.get())}));
        Schema sourceSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"field1", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"field2", (Type)Types.IntegerType.get())}));
        Schema actualSchema = TypeUtil.reassignOrRefreshIds((Schema)schema, (Schema)sourceSchema, (boolean)false);
        Schema expectedSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"FIELD1", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"FIELD2", (Type)Types.IntegerType.get())}));
        Assert.assertEquals((Object)expectedSchema.asStruct(), (Object)actualSchema.asStruct());
    }
}

