/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.Deque;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.ExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseableGroup
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CloseableGroup.class);
    private final Deque<AutoCloseable> closeables = Lists.newLinkedList();
    private boolean suppressCloseFailure = false;

    public void addCloseable(Closeable closeable) {
        this.closeables.add(closeable);
    }

    public void addCloseable(AutoCloseable autoCloseable) {
        this.closeables.add(autoCloseable);
    }

    public void setSuppressCloseFailure(boolean shouldSuppress) {
        this.suppressCloseFailure = shouldSuppress;
    }

    @Override
    public void close() throws IOException {
        while (!this.closeables.isEmpty()) {
            AutoCloseable toClose = this.closeables.pollFirst();
            if (toClose == null) continue;
            try {
                toClose.close();
            }
            catch (Exception e) {
                if (this.suppressCloseFailure) {
                    LOG.error("Exception suppressed when attempting to close resources", (Throwable)e);
                    continue;
                }
                ExceptionUtil.castAndThrow(e, IOException.class);
            }
        }
    }
}

