/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.util.List;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundAggregate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundAggregate;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAggregateBinding {
    private static final List<UnboundAggregate<Integer>> list = ImmutableList.of((Object)Expressions.count((String)"x"), (Object)Expressions.max((String)"x"), (Object)Expressions.min((String)"x"));
    private static final Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.IntegerType.get())});

    @Test
    public void testAggregateBinding() {
        for (UnboundAggregate<Integer> unbound : list) {
            Expression expr = unbound.bind(struct, true);
            BoundAggregate bound = TestAggregateBinding.assertAndUnwrapAggregate(expr);
            ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should reference correct field ID", new Object[0])).isEqualTo(10);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should not change the comparison operation", new Object[0])).isEqualTo((Object)unbound.op());
        }
    }

    @Test
    public void testCountStarBinding() {
        UnboundAggregate unbound = Expressions.countStar();
        Expression expr = unbound.bind(null, false);
        BoundAggregate bound = TestAggregateBinding.assertAndUnwrapAggregate(expr);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should not change the comparison operation", new Object[0])).isEqualTo((Object)Expression.Operation.COUNT_STAR);
    }

    @Test
    public void testBoundAggregateFails() {
        UnboundAggregate unbound = Expressions.count((String)"x");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestAggregateBinding.lambda$testBoundAggregateFails$0((Expression)unbound)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Found already bound aggregate");
    }

    @Test
    public void testCaseInsensitiveReference() {
        UnboundAggregate expr = Expressions.max((String)"X");
        Expression boundExpr = Binder.bind((Types.StructType)struct, (Expression)expr, (boolean)false);
        BoundAggregate bound = TestAggregateBinding.assertAndUnwrapAggregate(boundExpr);
        ((AbstractIntegerAssert)Assertions.assertThat((int)bound.ref().fieldId()).as("Should reference correct field ID", new Object[0])).isEqualTo(10);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)bound.op()).as("Should not change the comparison operation", new Object[0])).isEqualTo((Object)Expression.Operation.MAX);
    }

    @Test
    public void testCaseSensitiveReference() {
        UnboundAggregate expr = Expressions.max((String)"X");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestAggregateBinding.lambda$testCaseSensitiveReference$1((Expression)expr)).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'X' in struct");
    }

    @Test
    public void testMissingField() {
        UnboundAggregate unbound = Expressions.count((String)"missing");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> unbound.bind(struct, false)).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'missing' in struct:");
    }

    private static <T, C> BoundAggregate<T, C> assertAndUnwrapAggregate(Expression expr) {
        Assertions.assertThat((Object)expr).isInstanceOf(BoundAggregate.class);
        return (BoundAggregate)expr;
    }

    private static /* synthetic */ void lambda$testCaseSensitiveReference$1(Expression expr) throws Throwable {
        Binder.bind((Types.StructType)struct, (Expression)expr, (boolean)true);
    }

    private static /* synthetic */ void lambda$testBoundAggregateFails$0(Expression unbound) throws Throwable {
        Binder.bind((Types.StructType)struct, (Expression)Binder.bind((Types.StructType)struct, (Expression)unbound));
    }
}

