/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.util.concurrent.Callable;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.expressions.UnboundTransform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestExpressionHelpers {
    private final UnboundPredicate<?> pred = Expressions.lessThan((String)"x", (Object)7);

    @Test
    public void testSimplifyOr() {
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.or((Expression)Expressions.alwaysTrue(), this.pred)).as("alwaysTrue or pred => alwaysTrue", new Object[0])).isEqualTo((Object)Expressions.alwaysTrue());
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.or(this.pred, (Expression)Expressions.alwaysTrue())).as("pred or alwaysTrue => alwaysTrue", new Object[0])).isEqualTo((Object)Expressions.alwaysTrue());
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.or((Expression)Expressions.alwaysFalse(), this.pred)).as("alwaysFalse or pred => pred", new Object[0])).isEqualTo(this.pred);
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.or(this.pred, (Expression)Expressions.alwaysFalse())).as("pred or alwaysTrue => pred", new Object[0])).isEqualTo(this.pred);
    }

    @Test
    public void testSimplifyAnd() {
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.and((Expression)Expressions.alwaysTrue(), this.pred)).as("alwaysTrue and pred => pred", new Object[0])).isEqualTo(this.pred);
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.and(this.pred, (Expression)Expressions.alwaysTrue())).as("pred and alwaysTrue => pred", new Object[0])).isEqualTo(this.pred);
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.and((Expression)Expressions.alwaysFalse(), this.pred)).as("alwaysFalse and pred => alwaysFalse", new Object[0])).isEqualTo((Object)Expressions.alwaysFalse());
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.and(this.pred, (Expression)Expressions.alwaysFalse())).as("pred and alwaysFalse => alwaysFalse", new Object[0])).isEqualTo((Object)Expressions.alwaysFalse());
    }

    @Test
    public void testSimplifyNot() {
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.not((Expression)Expressions.alwaysTrue())).as("not(alwaysTrue) => alwaysFalse", new Object[0])).isEqualTo((Object)Expressions.alwaysFalse());
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.not((Expression)Expressions.alwaysFalse())).as("not(alwaysFalse) => alwaysTrue", new Object[0])).isEqualTo((Object)Expressions.alwaysTrue());
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.not((Expression)Expressions.not(this.pred))).as("not(not(pred)) => pred", new Object[0])).isEqualTo(this.pred);
    }

    @Test
    public void testRewriteNot() {
        Expression[][] expressions;
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"s", (Type)Types.StringType.get())});
        for (Expression[] pair : expressions = new Expression[][]{{Expressions.isNull((String)"a"), Expressions.isNull((String)"a")}, {Expressions.notNull((String)"a"), Expressions.not((Expression)Expressions.isNull((String)"a"))}, {Expressions.notNull((String)"a"), Expressions.notNull((String)"a")}, {Expressions.isNull((String)"a"), Expressions.not((Expression)Expressions.notNull((String)"a"))}, {Expressions.equal((String)"a", (Object)5), Expressions.equal((String)"a", (Object)5)}, {Expressions.notEqual((String)"a", (Object)5), Expressions.not((Expression)Expressions.equal((String)"a", (Object)5))}, {Expressions.notEqual((String)"a", (Object)5), Expressions.notEqual((String)"a", (Object)5)}, {Expressions.equal((String)"a", (Object)5), Expressions.not((Expression)Expressions.notEqual((String)"a", (Object)5))}, {Expressions.in((String)"a", (Object[])new Integer[]{5, 6}), Expressions.in((String)"a", (Object[])new Integer[]{5, 6})}, {Expressions.notIn((String)"a", (Object[])new Integer[]{5, 6}), Expressions.not((Expression)Expressions.in((String)"a", (Object[])new Integer[]{5, 6}))}, {Expressions.notIn((String)"a", (Object[])new Integer[]{5, 6}), Expressions.notIn((String)"a", (Object[])new Integer[]{5, 6})}, {Expressions.in((String)"a", (Object[])new Integer[]{5, 6}), Expressions.not((Expression)Expressions.notIn((String)"a", (Object[])new Integer[]{5, 6}))}, {Expressions.lessThan((String)"a", (Object)5), Expressions.lessThan((String)"a", (Object)5)}, {Expressions.greaterThanOrEqual((String)"a", (Object)5), Expressions.not((Expression)Expressions.lessThan((String)"a", (Object)5))}, {Expressions.greaterThanOrEqual((String)"a", (Object)5), Expressions.greaterThanOrEqual((String)"a", (Object)5)}, {Expressions.lessThan((String)"a", (Object)5), Expressions.not((Expression)Expressions.greaterThanOrEqual((String)"a", (Object)5))}, {Expressions.lessThanOrEqual((String)"a", (Object)5), Expressions.lessThanOrEqual((String)"a", (Object)5)}, {Expressions.greaterThan((String)"a", (Object)5), Expressions.not((Expression)Expressions.lessThanOrEqual((String)"a", (Object)5))}, {Expressions.greaterThan((String)"a", (Object)5), Expressions.greaterThan((String)"a", (Object)5)}, {Expressions.lessThanOrEqual((String)"a", (Object)5), Expressions.not((Expression)Expressions.greaterThan((String)"a", (Object)5))}, {Expressions.or((Expression)Expressions.equal((String)"a", (Object)5), (Expression)Expressions.isNull((String)"a")), Expressions.or((Expression)Expressions.equal((String)"a", (Object)5), (Expression)Expressions.isNull((String)"a"))}, {Expressions.and((Expression)Expressions.notEqual((String)"a", (Object)5), (Expression)Expressions.notNull((String)"a")), Expressions.not((Expression)Expressions.or((Expression)Expressions.equal((String)"a", (Object)5), (Expression)Expressions.isNull((String)"a")))}, {Expressions.and((Expression)Expressions.notEqual((String)"a", (Object)5), (Expression)Expressions.notNull((String)"a")), Expressions.and((Expression)Expressions.notEqual((String)"a", (Object)5), (Expression)Expressions.notNull((String)"a"))}, {Expressions.or((Expression)Expressions.equal((String)"a", (Object)5), (Expression)Expressions.isNull((String)"a")), Expressions.not((Expression)Expressions.and((Expression)Expressions.notEqual((String)"a", (Object)5), (Expression)Expressions.notNull((String)"a")))}, {Expressions.or((Expression)Expressions.equal((String)"a", (Object)5), (Expression)Expressions.notNull((String)"a")), Expressions.or((Expression)Expressions.equal((String)"a", (Object)5), (Expression)Expressions.not((Expression)Expressions.isNull((String)"a")))}, {Expressions.startsWith((String)"s", (String)"hello"), Expressions.not((Expression)Expressions.notStartsWith((String)"s", (String)"hello"))}, {Expressions.notStartsWith((String)"s", (String)"world"), Expressions.not((Expression)Expressions.startsWith((String)"s", (String)"world"))}}) {
            ((ObjectAssert)Assertions.assertThat((Object)Expressions.rewriteNot((Expression)pair[1])).as(String.format("rewriteNot(%s) should be %s", pair[1], pair[0]), new Object[0])).hasToString(pair[0].toString());
            Expression expectedBound = Binder.bind((Types.StructType)struct, (Expression)pair[0]);
            Expression toRewriteBound = Binder.bind((Types.StructType)struct, (Expression)pair[1]);
            ((ObjectAssert)Assertions.assertThat((Object)Expressions.rewriteNot((Expression)toRewriteBound)).as(String.format("rewriteNot(%s) should be %s", toRewriteBound, expectedBound), new Object[0])).hasToString(expectedBound.toString());
        }
    }

    @Test
    public void testTransformExpressions() {
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.equal((UnboundTerm)Expressions.year((String)"ts"), (Object)"2019")).as("Should produce the correct expression string", new Object[0])).hasToString("year(ref(name=\"ts\")) == \"2019\"");
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.equal((UnboundTerm)Expressions.month((String)"ts"), (Object)1234)).as("Should produce the correct expression string", new Object[0])).hasToString("month(ref(name=\"ts\")) == 1234");
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.equal((UnboundTerm)Expressions.day((String)"ts"), (Object)"2019-12-04")).as("Should produce the correct expression string", new Object[0])).hasToString("day(ref(name=\"ts\")) == \"2019-12-04\"");
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.equal((UnboundTerm)Expressions.hour((String)"ts"), (Object)"2019-12-04-10")).as("Should produce the correct expression string", new Object[0])).hasToString("hour(ref(name=\"ts\")) == \"2019-12-04-10\"");
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.equal((UnboundTerm)Expressions.truncate((String)"str", (int)6), (Object)"abcdef")).as("Should produce the correct expression string", new Object[0])).hasToString("truncate[6](ref(name=\"str\")) == \"abcdef\"");
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.equal((UnboundTerm)Expressions.truncate((String)"i", (int)5), (Object)10)).as("Should produce the correct expression string", new Object[0])).hasToString("truncate[5](ref(name=\"i\")) == 10");
        ((ObjectAssert)Assertions.assertThat((Object)Expressions.equal((UnboundTerm)Expressions.bucket((String)"id", (int)16), (Object)12)).as("Should produce the correct expression string", new Object[0])).hasToString("bucket[16](ref(name=\"id\")) == 12");
    }

    @Test
    public void testNullName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.equal((String)null, (Object)5)).isInstanceOf(NullPointerException.class)).hasMessage("Name cannot be null");
    }

    @Test
    public void testNullValueExpr() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.equal((UnboundTerm)null, (Object)5)).isInstanceOf(NullPointerException.class)).hasMessage("Term cannot be null");
    }

    @Test
    public void testMultiAnd() {
        Expression expected = Expressions.and((Expression)Expressions.and((Expression)Expressions.equal((String)"a", (Object)1), (Expression)Expressions.equal((String)"b", (Object)2)), (Expression)Expressions.equal((String)"c", (Object)3));
        Expression actual = Expressions.and((Expression)Expressions.equal((String)"a", (Object)1), (Expression)Expressions.equal((String)"b", (Object)2), (Expression[])new Expression[]{Expressions.equal((String)"c", (Object)3)});
        Assertions.assertThat((Object)actual).hasToString(expected.toString());
    }

    @Test
    public void testInvalidateNaNInput() {
        this.assertInvalidateNaNThrows(() -> Expressions.lessThan((String)"a", (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.lessThan(this.self("a"), (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.lessThanOrEqual((String)"a", (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.lessThanOrEqual(this.self("a"), (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.greaterThan((String)"a", (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.greaterThan(this.self("a"), (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.greaterThanOrEqual((String)"a", (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.greaterThanOrEqual(this.self("a"), (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.equal((String)"a", (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.equal(this.self("a"), (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.notEqual((String)"a", (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.notEqual(this.self("a"), (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.in((String)"a", (Object[])new Double[]{1.0, 2.0, Double.NaN}));
        this.assertInvalidateNaNThrows(() -> Expressions.in(this.self("a"), (Object[])new Double[]{1.0, 2.0, Double.NaN}));
        this.assertInvalidateNaNThrows(() -> Expressions.notIn((String)"a", (Object[])new Double[]{1.0, 2.0, Double.NaN}));
        this.assertInvalidateNaNThrows(() -> Expressions.notIn(this.self("a"), (Object[])new Double[]{1.0, 2.0, Double.NaN}));
        this.assertInvalidateNaNThrows(() -> Expressions.predicate((Expression.Operation)Expression.Operation.EQ, (String)"a", (Object)Double.NaN));
    }

    private void assertInvalidateNaNThrows(Callable<UnboundPredicate<Double>> callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(callable::call).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create expression literal from NaN");
    }

    private <T> UnboundTerm<T> self(String name) {
        return new UnboundTransform(Expressions.ref((String)name), Transforms.identity());
    }
}

