/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.InclusiveMetricsEvaluator;
import org.apache.iceberg.expressions.StrictMetricsEvaluator;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMetricsEvaluatorsNaNHandling {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"all_nan", (Type)Types.DoubleType.get()), Types.NestedField.required((int)2, (String)"max_nan", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)3, (String)"min_max_nan", (Type)Types.FloatType.get()), Types.NestedField.required((int)4, (String)"all_nan_null_bounds", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)5, (String)"some_nan_correct_bounds", (Type)Types.FloatType.get())});
    private static final DataFile FILE = new TestHelpers.TestDataFile("file.avro", TestHelpers.Row.of(new Object[0]), 50L, (Map<Integer, Long>)ImmutableMap.builder().put((Object)1, (Object)10L).put((Object)2, (Object)10L).put((Object)3, (Object)10L).put((Object)4, (Object)10L).put((Object)5, (Object)10L).buildOrThrow(), (Map<Integer, Long>)ImmutableMap.builder().put((Object)1, (Object)0L).put((Object)2, (Object)0L).put((Object)3, (Object)0L).put((Object)4, (Object)0L).put((Object)5, (Object)0L).buildOrThrow(), (Map<Integer, Long>)ImmutableMap.builder().put((Object)1, (Object)10L).put((Object)4, (Object)10L).put((Object)5, (Object)5L).buildOrThrow(), (Map<Integer, ByteBuffer>)ImmutableMap.builder().put((Object)1, (Object)Conversions.toByteBuffer((Type)Types.DoubleType.get(), (Object)Double.NaN)).put((Object)2, (Object)Conversions.toByteBuffer((Type)Types.DoubleType.get(), (Object)7.0)).put((Object)3, (Object)Conversions.toByteBuffer((Type)Types.FloatType.get(), (Object)Float.valueOf(Float.NaN))).put((Object)5, (Object)Conversions.toByteBuffer((Type)Types.FloatType.get(), (Object)Float.valueOf(7.0f))).buildOrThrow(), (Map<Integer, ByteBuffer>)ImmutableMap.builder().put((Object)1, (Object)Conversions.toByteBuffer((Type)Types.DoubleType.get(), (Object)Double.NaN)).put((Object)2, (Object)Conversions.toByteBuffer((Type)Types.DoubleType.get(), (Object)Double.NaN)).put((Object)3, (Object)Conversions.toByteBuffer((Type)Types.FloatType.get(), (Object)Float.valueOf(Float.NaN))).put((Object)5, (Object)Conversions.toByteBuffer((Type)Types.FloatType.get(), (Object)Float.valueOf(22.0f))).buildOrThrow());
    private static final Set<BiFunction<String, Number, Expression>> LESS_THAN_EXPRESSIONS = ImmutableSet.of(Expressions::lessThan, Expressions::lessThanOrEqual);
    private static final Set<BiFunction<String, Number, Expression>> GREATER_THAN_EXPRESSIONS = ImmutableSet.of(Expressions::greaterThan, Expressions::greaterThanOrEqual);

    @Test
    public void testInclusiveMetricsEvaluatorLessThanAndLessThanOrEqual() {
        for (BiFunction<String, Number, Expression> func : LESS_THAN_EXPRESSIONS) {
            boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, func.apply("all_nan", 1.0)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all nan column doesn't contain number", new Object[0])).isFalse();
            shouldRead = new InclusiveMetricsEvaluator(SCHEMA, func.apply("max_nan", 1.0)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 1 is smaller than lower bound", new Object[0])).isFalse();
            shouldRead = new InclusiveMetricsEvaluator(SCHEMA, func.apply("max_nan", 10.0)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: 10 is larger than lower bound", new Object[0])).isTrue();
            shouldRead = new InclusiveMetricsEvaluator(SCHEMA, func.apply("min_max_nan", Float.valueOf(1.0f))).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: no visibility", new Object[0])).isTrue();
            shouldRead = new InclusiveMetricsEvaluator(SCHEMA, func.apply("all_nan_null_bounds", 1.0)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all nan column doesn't contain number", new Object[0])).isFalse();
            shouldRead = new InclusiveMetricsEvaluator(SCHEMA, func.apply("some_nan_correct_bounds", Float.valueOf(1.0f))).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 1 is smaller than lower bound", new Object[0])).isFalse();
            shouldRead = new InclusiveMetricsEvaluator(SCHEMA, func.apply("some_nan_correct_bounds", Float.valueOf(10.0f))).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: 10 larger than lower bound", new Object[0])).isTrue();
        }
    }

    @Test
    public void testInclusiveMetricsEvaluatorGreaterThanAndGreaterThanOrEqual() {
        for (BiFunction<String, Number, Expression> func : GREATER_THAN_EXPRESSIONS) {
            boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, func.apply("all_nan", 1.0)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all nan column doesn't contain number", new Object[0])).isFalse();
            shouldRead = new InclusiveMetricsEvaluator(SCHEMA, func.apply("max_nan", 1.0)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: upper bound is larger than 1", new Object[0])).isTrue();
            shouldRead = new InclusiveMetricsEvaluator(SCHEMA, func.apply("max_nan", 10.0)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: upper bound is larger than 10", new Object[0])).isTrue();
            shouldRead = new InclusiveMetricsEvaluator(SCHEMA, func.apply("min_max_nan", Float.valueOf(1.0f))).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: no visibility", new Object[0])).isTrue();
            shouldRead = new InclusiveMetricsEvaluator(SCHEMA, func.apply("all_nan_null_bounds", 1.0)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all nan column doesn't contain number", new Object[0])).isFalse();
            shouldRead = new InclusiveMetricsEvaluator(SCHEMA, func.apply("some_nan_correct_bounds", Float.valueOf(1.0f))).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: 1 is smaller than upper bound", new Object[0])).isTrue();
            shouldRead = new InclusiveMetricsEvaluator(SCHEMA, func.apply("some_nan_correct_bounds", Float.valueOf(10.0f))).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: 10 is smaller than upper bound", new Object[0])).isTrue();
            shouldRead = new InclusiveMetricsEvaluator(SCHEMA, func.apply("some_nan_correct_bounds", 30)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 30 is greater than upper bound", new Object[0])).isFalse();
        }
    }

    @Test
    public void testInclusiveMetricsEvaluatorEquals() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"all_nan", (Object)1.0)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all nan column doesn't contain number", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"max_nan", (Object)1.0)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 1 is smaller than lower bound", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"max_nan", (Object)10.0)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: 10 is within bounds", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"min_max_nan", (Object)Float.valueOf(1.0f))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: no visibility", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"all_nan_null_bounds", (Object)1.0)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all nan column doesn't contain number", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"some_nan_correct_bounds", (Object)Float.valueOf(1.0f))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 1 is smaller than lower bound", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"some_nan_correct_bounds", (Object)Float.valueOf(10.0f))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: 10 is within bounds", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"some_nan_correct_bounds", (Object)30)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 30 is greater than upper bound", new Object[0])).isFalse();
    }

    @Test
    public void testInclusiveMetricsEvaluatorNotEquals() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"all_nan", (Object)1.0)).eval((ContentFile)FILE);
        shouldRead &= new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"max_nan", (Object)1.0)).eval((ContentFile)FILE);
        shouldRead &= new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"max_nan", (Object)10.0)).eval((ContentFile)FILE);
        shouldRead &= new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"min_max_nan", (Object)Float.valueOf(1.0f))).eval((ContentFile)FILE);
        shouldRead &= new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"all_nan_null_bounds", (Object)1.0)).eval((ContentFile)FILE);
        shouldRead &= new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"some_nan_correct_bounds", (Object)Float.valueOf(1.0f))).eval((ContentFile)FILE);
        shouldRead &= new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"some_nan_correct_bounds", (Object)Float.valueOf(10.0f))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(shouldRead &= new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"some_nan_correct_bounds", (Object)30)).eval((ContentFile)FILE))).as("Should match: no visibility", new Object[0])).isTrue();
    }

    @Test
    public void testInclusiveMetricsEvaluatorIn() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"all_nan", (Object[])new Double[]{1.0, 10.0, 30.0})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all nan column doesn't contain number", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"max_nan", (Object[])new Double[]{1.0, 10.0, 30.0})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: 10 and 30 are greater than lower bound", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"min_max_nan", (Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(10.0f), Float.valueOf(30.0f)})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: no visibility", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"all_nan_null_bounds", (Object[])new Double[]{1.0, 10.0, 30.0})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all nan column doesn't contain number", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"some_nan_correct_bounds", (Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(10.0f), Float.valueOf(30.0f)})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: 10 within bounds", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"some_nan_correct_bounds", (Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(30.0f)})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 1 not within bounds", new Object[0])).isFalse();
    }

    @Test
    public void testInclusiveMetricsEvaluatorNotIn() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"all_nan", (Object[])new Double[]{1.0})).eval((ContentFile)FILE);
        shouldRead &= new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"max_nan", (Object[])new Double[]{1.0})).eval((ContentFile)FILE);
        shouldRead &= new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"max_nan", (Object[])new Double[]{10.0})).eval((ContentFile)FILE);
        shouldRead &= new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"min_max_nan", (Object[])new Float[]{Float.valueOf(1.0f)})).eval((ContentFile)FILE);
        shouldRead &= new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"all_nan_null_bounds", (Object[])new Double[]{1.0})).eval((ContentFile)FILE);
        shouldRead &= new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"some_nan_correct_bounds", (Object[])new Float[]{Float.valueOf(1.0f)})).eval((ContentFile)FILE);
        shouldRead &= new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"some_nan_correct_bounds", (Object[])new Float[]{Float.valueOf(10.0f)})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(shouldRead &= new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"some_nan_correct_bounds", (Object[])new Integer[]{30})).eval((ContentFile)FILE))).as("Should match: no visibility", new Object[0])).isTrue();
    }

    @Test
    public void testStrictMetricsEvaluatorLessThanAndLessThanOrEqual() {
        for (BiFunction<String, Number, Expression> func : LESS_THAN_EXPRESSIONS) {
            boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, func.apply("all_nan", 1.0)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all nan column doesn't contain number", new Object[0])).isFalse();
            shouldRead = new StrictMetricsEvaluator(SCHEMA, func.apply("max_nan", 10.0)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 10 is less than upper bound", new Object[0])).isFalse();
            shouldRead = new StrictMetricsEvaluator(SCHEMA, func.apply("min_max_nan", Float.valueOf(1.0f))).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: no visibility", new Object[0])).isFalse();
            shouldRead = new StrictMetricsEvaluator(SCHEMA, func.apply("all_nan_null_bounds", 1.0)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all nan column doesn't contain number", new Object[0])).isFalse();
            shouldRead = new StrictMetricsEvaluator(SCHEMA, func.apply("some_nan_correct_bounds", Float.valueOf(30.0f))).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: nan value exists", new Object[0])).isFalse();
        }
    }

    @Test
    public void testStrictMetricsEvaluatorGreaterThanAndGreaterThanOrEqual() {
        for (BiFunction<String, Number, Expression> func : GREATER_THAN_EXPRESSIONS) {
            boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, func.apply("all_nan", 1.0)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all nan column doesn't contain number", new Object[0])).isFalse();
            shouldRead = new StrictMetricsEvaluator(SCHEMA, func.apply("max_nan", 1.0)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: 1 is smaller than lower bound", new Object[0])).isTrue();
            shouldRead = new StrictMetricsEvaluator(SCHEMA, func.apply("max_nan", 10.0)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 10 is larger than lower bound", new Object[0])).isFalse();
            shouldRead = new StrictMetricsEvaluator(SCHEMA, func.apply("min_max_nan", Float.valueOf(1.0f))).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: no visibility", new Object[0])).isFalse();
            shouldRead = new StrictMetricsEvaluator(SCHEMA, func.apply("all_nan_null_bounds", 1.0)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all nan column doesn't contain number", new Object[0])).isFalse();
            shouldRead = new StrictMetricsEvaluator(SCHEMA, func.apply("some_nan_correct_bounds", 30)).eval((ContentFile)FILE);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: nan value exists", new Object[0])).isFalse();
        }
    }

    @Test
    public void testStrictMetricsEvaluatorNotEquals() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"all_nan", (Object)1.0)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: all nan column doesn't contain number", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"max_nan", (Object)1.0)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: 1 is smaller than lower bound", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"max_nan", (Object)10.0)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 10 is within bounds", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"min_max_nan", (Object)Float.valueOf(1.0f))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: no visibility", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"all_nan_null_bounds", (Object)1.0)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: all nan column doesn't contain number", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"some_nan_correct_bounds", (Object)Float.valueOf(1.0f))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: 1 is smaller than lower bound", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"some_nan_correct_bounds", (Object)Float.valueOf(10.0f))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 10 is within bounds", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"some_nan_correct_bounds", (Object)30)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: 30 is greater than upper bound", new Object[0])).isTrue();
    }

    @Test
    public void testStrictMetricsEvaluatorEquals() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"all_nan", (Object)1.0)).eval((ContentFile)FILE);
        shouldRead |= new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"max_nan", (Object)1.0)).eval((ContentFile)FILE);
        shouldRead |= new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"max_nan", (Object)10.0)).eval((ContentFile)FILE);
        shouldRead |= new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"min_max_nan", (Object)Float.valueOf(1.0f))).eval((ContentFile)FILE);
        shouldRead |= new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"all_nan_null_bounds", (Object)1.0)).eval((ContentFile)FILE);
        shouldRead |= new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"some_nan_correct_bounds", (Object)Float.valueOf(1.0f))).eval((ContentFile)FILE);
        shouldRead |= new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"some_nan_correct_bounds", (Object)Float.valueOf(10.0f))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(shouldRead |= new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"some_nan_correct_bounds", (Object)30)).eval((ContentFile)FILE))).as("Should not match: bounds not equal to given value", new Object[0])).isFalse();
    }

    @Test
    public void testStrictMetricsEvaluatorNotIn() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"all_nan", (Object[])new Double[]{1.0, 10.0, 30.0})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: all nan column doesn't contain number", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"max_nan", (Object[])new Double[]{1.0, 10.0, 30.0})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 10 and 30 are greater than lower bound", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"max_nan", (Object[])new Double[]{1.0})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: 1 is less than lower bound", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"min_max_nan", (Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(10.0f), Float.valueOf(30.0f)})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: no visibility", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"all_nan_null_bounds", (Object[])new Double[]{1.0, 10.0, 30.0})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: all nan column doesn't contain number", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"some_nan_correct_bounds", (Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(10.0f), Float.valueOf(30.0f)})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 10 within bounds", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"some_nan_correct_bounds", (Object[])new Double[]{1.0})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: 1 not within bounds", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"some_nan_correct_bounds", (Object[])new Double[]{30.0})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: 30 not within bounds", new Object[0])).isTrue();
    }

    @Test
    public void testStrictMetricsEvaluatorIn() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"all_nan", (Object[])new Double[]{1.0})).eval((ContentFile)FILE);
        shouldRead |= new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"max_nan", (Object[])new Double[]{1.0})).eval((ContentFile)FILE);
        shouldRead |= new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"max_nan", (Object[])new Double[]{10.0})).eval((ContentFile)FILE);
        shouldRead |= new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"min_max_nan", (Object[])new Float[]{Float.valueOf(1.0f)})).eval((ContentFile)FILE);
        shouldRead |= new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"all_nan_null_bounds", (Object[])new Double[]{1.0})).eval((ContentFile)FILE);
        shouldRead |= new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"some_nan_correct_bounds", (Object[])new Float[]{Float.valueOf(1.0f)})).eval((ContentFile)FILE);
        shouldRead |= new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"some_nan_correct_bounds", (Object[])new Float[]{Float.valueOf(10.0f)})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(shouldRead |= new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"some_nan_correct_bounds", (Object)30)).eval((ContentFile)FILE))).as("Should not match: bounds not equal to given value", new Object[0])).isFalse();
    }
}

