/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.InclusiveMetricsEvaluator;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.StrictMetricsEvaluator;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.transforms.Truncate;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestNotStartsWith {
    private static final String COLUMN = "someStringCol";
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"someStringCol", (Type)Types.StringType.get())});
    private static final DataFile FILE_1 = new TestHelpers.TestDataFile("file_1.avro", TestHelpers.Row.of(new Object[0]), 50L, (Map<Integer, Long>)ImmutableMap.of((Object)1, (Object)50L), (Map<Integer, Long>)ImmutableMap.of((Object)1, (Object)0L), null, (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"bbb")), (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"bbb")));

    @Test
    public void testTruncateProjections() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).truncate(COLUMN, 4).build();
        this.assertProjectionInclusive(spec, Expressions.notStartsWith((String)COLUMN, (String)"ab"), "ab", Expression.Operation.NOT_STARTS_WITH);
        this.assertProjectionInclusive(spec, Expressions.notStartsWith((String)COLUMN, (String)"abab"), "abab", Expression.Operation.NOT_EQ);
        Expression projection = Projections.inclusive((PartitionSpec)spec).project((Expression)Expressions.notStartsWith((String)COLUMN, (String)"ababab"));
        Assertions.assertThat((Object)projection).isInstanceOf(True.class);
        this.assertProjectionStrict(spec, Expressions.notStartsWith((String)COLUMN, (String)"ab"), "ab", Expression.Operation.NOT_STARTS_WITH);
        this.assertProjectionStrict(spec, Expressions.notStartsWith((String)COLUMN, (String)"abab"), "abab", Expression.Operation.NOT_EQ);
        this.assertProjectionStrict(spec, Expressions.notStartsWith((String)COLUMN, (String)"ababab"), "abab", Expression.Operation.NOT_STARTS_WITH);
        this.assertProjectionStrict(spec, Expressions.notStartsWith((String)COLUMN, (String)"abcde"), "abcd", Expression.Operation.NOT_STARTS_WITH);
    }

    @Test
    public void testTruncateStringWhenProjectedPredicateTermIsLongerThanWidth() {
        Truncate trunc = Truncate.get((int)2);
        UnboundPredicate expr = Expressions.notStartsWith((String)COLUMN, (String)"abcde");
        BoundPredicate boundExpr = (BoundPredicate)Binder.bind((Types.StructType)SCHEMA.asStruct(), (Expression)expr, (boolean)false);
        UnboundPredicate projected = trunc.projectStrict(COLUMN, boundExpr);
        Evaluator evaluator = new Evaluator(SCHEMA.asStruct(), (Expression)projected);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)projected.literal().value())).as("The projected literal should be truncated to the truncation width", new Object[0])).isEqualTo("ab");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("abcde"))).as("notStartsWith(abcde, truncate(abcde,2)) => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("ab"))).as("notStartsWith(abcde, truncate(ab, 2)) => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("abcdz"))).as("notStartsWith(abcde, truncate(abcdz, 2)) => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("a"))).as("notStartsWith(abcde, truncate(a, 2)) => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("aczcde"))).as("notStartsWith(abcde, truncate(aczcde, 2)) => true", new Object[0])).isTrue();
    }

    @Test
    public void testTruncateStringWhenProjectedPredicateTermIsShorterThanWidth() {
        Truncate trunc = Truncate.get((int)16);
        UnboundPredicate expr = Expressions.notStartsWith((String)COLUMN, (String)"ab");
        BoundPredicate boundExpr = (BoundPredicate)Binder.bind((Types.StructType)SCHEMA.asStruct(), (Expression)expr, (boolean)false);
        UnboundPredicate projected = trunc.projectStrict(COLUMN, boundExpr);
        Evaluator evaluator = new Evaluator(SCHEMA.asStruct(), (Expression)projected);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)projected.literal().value())).as("The projected literal should not be truncated as its size is shorter than truncation width", new Object[0])).isEqualTo("ab");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("abcde"))).as("notStartsWith(ab, truncate(abcde, 16)) => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("ab"))).as("notStartsWith(ab, truncate(ab, 16)) => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("a"))).as("notStartsWith(ab, truncate(a, 16)) => true", new Object[0])).isTrue();
    }

    @Test
    public void testTruncateStringWhenProjectedPredicateTermIsEqualToWidth() {
        Truncate trunc = Truncate.get((int)7);
        UnboundPredicate expr = Expressions.notStartsWith((String)COLUMN, (String)"abcdefg");
        BoundPredicate boundExpr = (BoundPredicate)Binder.bind((Types.StructType)SCHEMA.asStruct(), (Expression)expr, (boolean)false);
        UnboundPredicate projected = trunc.projectStrict(COLUMN, boundExpr);
        Evaluator evaluator = new Evaluator(SCHEMA.asStruct(), (Expression)projected);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)projected.literal().value())).as("The projected literal should not be truncated as its size is equal to truncation width", new Object[0])).isEqualTo("abcdefg");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("abcdefg"))).as("notStartsWith(abcdefg, truncate(abcdefg, 7)) => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("ab"))).as("notStartsWith(abcdefg, truncate(ab, 2)) => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("a"))).as("notStartsWith(abcdefg, truncate(a, 16)) => true", new Object[0])).isTrue();
    }

    @Test
    public void testStrictMetricsEvaluatorForNotStartsWith() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)COLUMN, (String)"bbb")).eval((ContentFile)FILE_1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: strict metrics eval is always false for notStartsWith", new Object[0])).isFalse();
    }

    @Test
    public void testInclusiveMetricsEvaluatorForNotStartsWith() {
        boolean shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)COLUMN, (String)"aaa")).eval((ContentFile)FILE_1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: some columns meet the filter criteria", new Object[0])).isTrue();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)COLUMN, (String)"b")).eval((ContentFile)FILE_1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: no columns match the filter criteria", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)COLUMN, (String)"bb")).eval((ContentFile)FILE_1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: no columns match the filter criteria", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)COLUMN, (String)"bbb")).eval((ContentFile)FILE_1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: no columns match the filter criteria", new Object[0])).isFalse();
        shouldRead = new InclusiveMetricsEvaluator(SCHEMA, (Expression)Expressions.notStartsWith((String)COLUMN, (String)"bbbb")).eval((ContentFile)FILE_1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: some columns match the filter criteria", new Object[0])).isTrue();
    }

    private void assertProjectionInclusive(PartitionSpec spec, UnboundPredicate<?> filter, String expectedLiteral, Expression.Operation expectedOp) {
        Expression projection = Projections.inclusive((PartitionSpec)spec).project(filter);
        this.assertProjection(spec, expectedLiteral, projection, expectedOp);
    }

    private void assertProjectionStrict(PartitionSpec spec, UnboundPredicate<?> filter, String expectedLiteral, Expression.Operation expectedOp) {
        Expression projection = Projections.strict((PartitionSpec)spec).project(filter);
        this.assertProjection(spec, expectedLiteral, projection, expectedOp);
    }

    private void assertProjection(PartitionSpec spec, String expectedLiteral, Expression projection, Expression.Operation expectedOp) {
        UnboundPredicate predicate = TestHelpers.assertAndUnwrapUnbound(projection);
        Literal literal = predicate.literal();
        Truncate transform = (Truncate)((PartitionField)spec.getFieldsBySourceId(1).get(0)).transform();
        String output = transform.toHumanString((Type)Types.StringType.get(), (Object)((String)literal.value()));
        Assertions.assertThat((Comparable)predicate.op()).isEqualTo((Object)expectedOp);
        Assertions.assertThat((String)output).isEqualTo(expectedLiteral);
    }
}

