/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.Comparator;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.expressions.Literal;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCharSeqComparator {
    @Test
    public void testStringAndUtf8() {
        String s1 = "abc";
        Utf8 s2 = new Utf8("abc");
        Comparator stringComp = Literal.of((CharSequence)s1).comparator();
        ((AbstractIntegerAssert)Assertions.assertThat((int)stringComp.compare(s1, s2)).as("Should consider String and Utf8 equal", new Object[0])).isZero();
        Comparator utf8Comp = Literal.of((CharSequence)s2).comparator();
        ((AbstractIntegerAssert)Assertions.assertThat((int)utf8Comp.compare(s1, s2)).as("Should consider String and Utf8 equal", new Object[0])).isZero();
    }

    @Test
    public void testSeqLength() {
        String s1 = "abc";
        String s2 = "abcd";
        Comparator cmp = Literal.of((CharSequence)s1).comparator();
        ((AbstractStringAssert)Assertions.assertThat((String)s1).as("When one string is a substring of the other, the longer is greater", new Object[0])).isLessThan(s2);
        ((AbstractStringAssert)Assertions.assertThat((String)s2).as("When one string is a substring of the other, the longer is greater", new Object[0])).isGreaterThan(s1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(s1, s2)).as("When one string is a substring of the other, the longer is greater", new Object[0])).isLessThan(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(s2, s1)).as("When one string is a substring of the other, the longer is greater", new Object[0])).isGreaterThan(0);
    }

    @Test
    public void testCharOrderBeforeLength() {
        String s1 = "adc";
        String s2 = "abcd";
        Comparator cmp = Literal.of((CharSequence)s1).comparator();
        ((AbstractStringAssert)Assertions.assertThat((String)s1).as("First difference takes precedence over length", new Object[0])).isGreaterThan(s2);
        ((AbstractStringAssert)Assertions.assertThat((String)s2).as("First difference takes precedence over length", new Object[0])).isLessThan(s1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(s1, s2)).as("First difference takes precedence over length", new Object[0])).isGreaterThan(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(s2, s1)).as("First difference takes precedence over length", new Object[0])).isLessThan(0);
    }

    @Test
    public void testNullHandling() {
        String s1 = "abc";
        Comparator cmp = Literal.of((CharSequence)s1).comparator();
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(null, s1)).as("null comes before non-null", new Object[0])).isLessThan(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(s1, null)).as("null comes before non-null", new Object[0])).isGreaterThan(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(null, null)).as("null equals null", new Object[0])).isZero();
    }
}

