/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConversions {
    @Test
    public void testByteBufferConversions() {
        this.assertConversion(false, (Type)Types.BooleanType.get(), new byte[]{0});
        this.assertConversion(true, (Type)Types.BooleanType.get(), new byte[]{1});
        Assertions.assertThat((byte[])Literal.of((boolean)false).toByteBuffer().array()).isEqualTo((Object)new byte[]{0});
        Assertions.assertThat((byte[])Literal.of((boolean)true).toByteBuffer().array()).isEqualTo((Object)new byte[]{1});
        this.assertConversion(84202, (Type)Types.IntegerType.get(), new byte[]{-22, 72, 1, 0});
        Assertions.assertThat((byte[])Literal.of((int)84202).toByteBuffer().array()).isEqualTo((Object)new byte[]{-22, 72, 1, 0});
        this.assertConversion(200L, (Type)Types.LongType.get(), new byte[]{-56, 0, 0, 0, 0, 0, 0, 0});
        Assertions.assertThat((byte[])Literal.of((long)200L).toByteBuffer().array()).isEqualTo((Object)new byte[]{-56, 0, 0, 0, 0, 0, 0, 0});
        this.assertConversion(Float.valueOf(-4.5f), (Type)Types.FloatType.get(), new byte[]{0, 0, -112, -64});
        Assertions.assertThat((byte[])Literal.of((float)-4.5f).toByteBuffer().array()).isEqualTo((Object)new byte[]{0, 0, -112, -64});
        this.assertConversion(6.0, (Type)Types.DoubleType.get(), new byte[]{0, 0, 0, 0, 0, 0, 24, 64});
        Assertions.assertThat((byte[])Literal.of((double)6.0).toByteBuffer().array()).isEqualTo((Object)new byte[]{0, 0, 0, 0, 0, 0, 24, 64});
        this.assertConversion(1000, (Type)Types.DateType.get(), new byte[]{-24, 3, 0, 0});
        Assertions.assertThat((byte[])Literal.of((int)1000).to((Type)Types.DateType.get()).toByteBuffer().array()).isEqualTo((Object)new byte[]{-24, 3, 0, 0});
        this.assertConversion(10000L, (Type)Types.TimeType.get(), new byte[]{16, 39, 0, 0, 0, 0, 0, 0});
        Assertions.assertThat((byte[])Literal.of((long)10000L).to((Type)Types.TimeType.get()).toByteBuffer().array()).isEqualTo((Object)new byte[]{16, 39, 0, 0, 0, 0, 0, 0});
        this.assertConversion(400000L, (Type)Types.TimestampType.withoutZone(), new byte[]{-128, 26, 6, 0, 0, 0, 0, 0});
        this.assertConversion(400000L, (Type)Types.TimestampType.withZone(), new byte[]{-128, 26, 6, 0, 0, 0, 0, 0});
        Assertions.assertThat((byte[])Literal.of((long)400000L).to((Type)Types.TimestampType.withoutZone()).toByteBuffer().array()).isEqualTo((Object)new byte[]{-128, 26, 6, 0, 0, 0, 0, 0});
        Assertions.assertThat((byte[])Literal.of((long)400000L).to((Type)Types.TimestampType.withZone()).toByteBuffer().array()).isEqualTo((Object)new byte[]{-128, 26, 6, 0, 0, 0, 0, 0});
        this.assertConversion(CharBuffer.wrap("ABC"), (Type)Types.StringType.get(), new byte[]{65, 66, 67});
        Assertions.assertThat((byte[])Literal.of((CharSequence)"ABC").toByteBuffer().array()).isEqualTo((Object)new byte[]{65, 66, 67});
        this.assertConversion(UUID.fromString("f79c3e09-677c-4bbd-a479-3f349cb785e7"), (Type)Types.UUIDType.get(), new byte[]{-9, -100, 62, 9, 103, 124, 75, -67, -92, 121, 63, 52, -100, -73, -123, -25});
        Assertions.assertThat((byte[])Literal.of((UUID)UUID.fromString("f79c3e09-677c-4bbd-a479-3f349cb785e7")).toByteBuffer().array()).isEqualTo((Object)new byte[]{-9, -100, 62, 9, 103, 124, 75, -67, -92, 121, 63, 52, -100, -73, -123, -25});
        this.assertConversion(ByteBuffer.wrap("ab".getBytes(StandardCharsets.UTF_8)), (Type)Types.FixedType.ofLength((int)2), new byte[]{97, 98});
        Assertions.assertThat((byte[])Literal.of((byte[])"ab".getBytes(StandardCharsets.UTF_8)).toByteBuffer().array()).isEqualTo((Object)new byte[]{97, 98});
        this.assertConversion(ByteBuffer.wrap("Z".getBytes(StandardCharsets.UTF_8)), (Type)Types.BinaryType.get(), new byte[]{90});
        Assertions.assertThat((byte[])Literal.of((ByteBuffer)ByteBuffer.wrap("Z".getBytes(StandardCharsets.UTF_8))).toByteBuffer().array()).isEqualTo((Object)new byte[]{90});
        this.assertConversion(new BigDecimal("3.45"), (Type)Types.DecimalType.of((int)3, (int)2), new byte[]{1, 89});
        Assertions.assertThat((byte[])Literal.of((BigDecimal)new BigDecimal("3.45")).toByteBuffer().array()).isEqualTo((Object)new byte[]{1, 89});
        this.assertConversion(new BigDecimal("123.4567"), (Type)Types.DecimalType.of((int)7, (int)4), new byte[]{18, -42, -121});
        Assertions.assertThat((byte[])Literal.of((BigDecimal)new BigDecimal("123.4567")).toByteBuffer().array()).isEqualTo((Object)new byte[]{18, -42, -121});
        this.assertConversion(new BigDecimal("-123.4567"), (Type)Types.DecimalType.of((int)7, (int)4), new byte[]{-19, 41, 121});
        Assertions.assertThat((byte[])Literal.of((BigDecimal)new BigDecimal("-123.4567")).toByteBuffer().array()).isEqualTo((Object)new byte[]{-19, 41, 121});
        this.assertConversion(new BigDecimal("0.011"), (Type)Types.DecimalType.of((int)10, (int)3), new byte[]{11});
        Assertions.assertThat((byte[])Literal.of((BigDecimal)new BigDecimal("0.011")).toByteBuffer().array()).isEqualTo((Object)new byte[]{11});
    }

    private <T> void assertConversion(T value, Type type, byte[] expectedBinary) {
        ByteBuffer byteBuffer = Conversions.toByteBuffer((Type)type, value);
        Assertions.assertThat((byte[])byteBuffer.array()).isEqualTo((Object)expectedBinary);
        Assertions.assertThat(value).isEqualTo(Conversions.fromByteBuffer((Type)type, (ByteBuffer)byteBuffer));
    }
}

