/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Arrays;
import java.util.Collection;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.util.CharSequenceSet;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCharSequenceSet {
    @Test
    public void testSearchingInCharSequenceCollection() {
        CharSequenceSet set = CharSequenceSet.of(Arrays.asList("abc", new StringBuffer("def")));
        Assertions.assertThat((Collection)set).contains((Object[])new CharSequence[]{"abc"});
        Assertions.assertThat((boolean)set.stream().anyMatch("def"::contains)).isTrue();
        Assertions.assertThat((boolean)set.contains("def")).isTrue();
    }

    @Test
    public void testRetainAll() {
        CharSequenceSet set = CharSequenceSet.of((Iterable)ImmutableList.of((Object)"123", (Object)"456"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)set.retainAll((Collection)ImmutableList.of((Object)"456", (Object)"789", (Object)123))).overridingErrorMessage("Set should be changed", new Object[0])).isTrue();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)set).hasSize(1)).contains((Object[])new CharSequence[]{"456"});
        set = CharSequenceSet.of((Iterable)ImmutableList.of((Object)"123", (Object)"456"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)set.retainAll((Collection)ImmutableList.of((Object)"123", (Object)"456"))).overridingErrorMessage("Set should not be changed", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)set.retainAll((Collection)ImmutableList.of((Object)123, (Object)456))).overridingErrorMessage("Set should be changed", new Object[0])).isTrue();
        Assertions.assertThat((Collection)set).isEmpty();
    }

    @Test
    public void testRemoveAll() {
        CharSequenceSet set = CharSequenceSet.of((Iterable)ImmutableList.of((Object)"123", (Object)"456"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)set.removeAll((Collection)ImmutableList.of((Object)"456", (Object)"789", (Object)123))).overridingErrorMessage("Set should be changed", new Object[0])).isTrue();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)set).hasSize(1)).contains((Object[])new CharSequence[]{"123"});
        set = CharSequenceSet.of((Iterable)ImmutableList.of((Object)"123", (Object)"456"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)set.removeAll((Collection)ImmutableList.of((Object)123, (Object)456))).overridingErrorMessage("Set should not be changed", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)set.removeAll((Collection)ImmutableList.of((Object)"123", (Object)"456"))).overridingErrorMessage("Set should be changed", new Object[0])).isTrue();
        Assertions.assertThat((Collection)set).isEmpty();
    }
}

