/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTableIdentifier {
    @Test
    public void testTableIdentifierParsing() {
        TableIdentifier oneLevelIdentifier = TableIdentifier.parse((String)"tbl");
        Assertions.assertThat((boolean)oneLevelIdentifier.hasNamespace()).isFalse();
        Assertions.assertThat((String)oneLevelIdentifier.name()).isEqualTo("tbl");
        TableIdentifier twoLevelIdentifier = TableIdentifier.parse((String)"userdb.tbl");
        Assertions.assertThat((Object[])twoLevelIdentifier.namespace().levels()).hasSize(1);
        Assertions.assertThat((String)twoLevelIdentifier.namespace().levels()[0]).isEqualTo("userdb");
        Assertions.assertThat((String)twoLevelIdentifier.name()).isEqualTo("tbl");
        TableIdentifier threeLevelIdentifier = TableIdentifier.parse((String)"catalog.userdb.tbl");
        Assertions.assertThat((Object[])threeLevelIdentifier.namespace().levels()).hasSize(2);
        Assertions.assertThat((String)threeLevelIdentifier.namespace().levels()[0]).isEqualTo("catalog");
        Assertions.assertThat((String)threeLevelIdentifier.namespace().levels()[1]).isEqualTo("userdb");
        Assertions.assertThat((String)threeLevelIdentifier.name()).isEqualTo("tbl");
    }

    @Test
    public void testToLowerCase() {
        Assertions.assertThat((Object)TableIdentifier.of((String[])new String[]{"tbl"})).isEqualTo((Object)TableIdentifier.of((String[])new String[]{"Tbl"}).toLowerCase());
        Assertions.assertThat((Object)TableIdentifier.of((String[])new String[]{"db", "tbl"})).isEqualTo((Object)TableIdentifier.of((String[])new String[]{"dB", "TBL"}).toLowerCase());
        Assertions.assertThat((Object)TableIdentifier.of((String[])new String[]{"catalog", "db", "tbl"})).isEqualTo((Object)TableIdentifier.of((String[])new String[]{"Catalog", "dB", "TBL"}).toLowerCase());
    }

    @Test
    public void testInvalidTableName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifier.of((Namespace)Namespace.empty(), (String)"")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid table name: null or empty");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifier.of((Namespace)Namespace.empty(), null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid table name: null or empty");
    }

    @Test
    public void testNulls() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifier.of((String[])null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create table identifier from null array");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifier.parse(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse table identifier: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifier.of(null, (String)"name")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid Namespace: null");
    }
}

