/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.events;

import org.apache.iceberg.events.Listeners;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestListeners {
    @Test
    public void testEvent1() {
        Event1 e1 = new Event1();
        Listeners.notifyAll((Object)e1);
        Assertions.assertThat((Object)TestListener.get().e1).isEqualTo((Object)e1);
    }

    @Test
    public void testEvent2() {
        Event2 e2 = new Event2();
        Listeners.notifyAll((Object)e2);
        Assertions.assertThat((Object)TestListener.get().e2).isEqualTo((Object)e2);
    }

    @Test
    public void testMultipleListeners() {
        TestListener other = new TestListener();
        Listeners.register(other::event1, Event1.class);
        Event1 e1 = new Event1();
        Listeners.notifyAll((Object)e1);
        Assertions.assertThat((Object)TestListener.get().e1).isEqualTo((Object)e1);
        Assertions.assertThat((Object)other.e1).isEqualTo((Object)e1);
    }

    static {
        Listeners.register(TestListener.get()::event1, Event1.class);
        Listeners.register(TestListener.get()::event2, Event2.class);
    }

    public static class TestListener {
        private static final TestListener INSTANCE = new TestListener();
        private Event1 e1 = null;
        private Event2 e2 = null;

        public static TestListener get() {
            return INSTANCE;
        }

        public void event1(Event1 event) {
            this.e1 = event;
        }

        public void event2(Event2 event) {
            this.e2 = event;
        }
    }

    public static class Event2 {
    }

    public static class Event1 {
    }
}

