/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.expressions.AggregateEvaluator;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.Test;

public class TestAggregateEvaluator {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"no_stats", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)3, (String)"all_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"some_nulls", (Type)Types.StringType.get())});
    private static final DataFile FILE = new TestHelpers.TestDataFile("file.avro", TestHelpers.Row.of(new Object[0]), 50L, (Map<Integer, Long>)ImmutableMap.of((Object)1, (Object)50L, (Object)3, (Object)50L, (Object)4, (Object)50L), (Map<Integer, Long>)ImmutableMap.of((Object)1, (Object)10L, (Object)3, (Object)50L, (Object)4, (Object)10L), null, (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)33)), (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)2345)));
    private static final DataFile MISSING_SOME_NULLS_STATS_1 = new TestHelpers.TestDataFile("file_2.avro", TestHelpers.Row.of(new Object[0]), 20L, (Map<Integer, Long>)ImmutableMap.of((Object)1, (Object)20L, (Object)3, (Object)20L), (Map<Integer, Long>)ImmutableMap.of((Object)1, (Object)0L, (Object)3, (Object)20L), null, (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)33)), (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)100)));
    private static final DataFile MISSING_SOME_NULLS_STATS_2 = new TestHelpers.TestDataFile("file_3.avro", TestHelpers.Row.of(new Object[0]), 20L, (Map<Integer, Long>)ImmutableMap.of((Object)1, (Object)20L, (Object)3, (Object)20L), (Map<Integer, Long>)ImmutableMap.of((Object)1, (Object)20L, (Object)3, (Object)20L), null, (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)-33)), (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)3333)));
    private static final DataFile[] dataFiles = new DataFile[]{FILE, MISSING_SOME_NULLS_STATS_1, MISSING_SOME_NULLS_STATS_2};

    @Test
    public void testIntAggregate() {
        ImmutableList list = ImmutableList.of((Object)Expressions.countStar(), (Object)Expressions.count((String)"id"), (Object)Expressions.max((String)"id"), (Object)Expressions.min((String)"id"));
        AggregateEvaluator aggregateEvaluator = AggregateEvaluator.create((Schema)SCHEMA, (List)list);
        for (DataFile dataFile : dataFiles) {
            aggregateEvaluator.update(dataFile);
        }
        Assertions.assertThat((boolean)aggregateEvaluator.allAggregatorsValid()).isTrue();
        StructLike result = aggregateEvaluator.result();
        Object[] expected = new Object[]{90L, 60L, 3333, -33};
        this.assertEvaluatorResult(result, expected);
    }

    @Test
    public void testAllNulls() {
        ImmutableList list = ImmutableList.of((Object)Expressions.countStar(), (Object)Expressions.count((String)"all_nulls"), (Object)Expressions.max((String)"all_nulls"), (Object)Expressions.min((String)"all_nulls"));
        AggregateEvaluator aggregateEvaluator = AggregateEvaluator.create((Schema)SCHEMA, (List)list);
        for (DataFile dataFile : dataFiles) {
            aggregateEvaluator.update(dataFile);
        }
        Assertions.assertThat((boolean)aggregateEvaluator.allAggregatorsValid()).isTrue();
        StructLike result = aggregateEvaluator.result();
        Object[] expected = new Object[]{90L, 0L, null, null};
        this.assertEvaluatorResult(result, expected);
    }

    @Test
    public void testSomeNulls() {
        ImmutableList list = ImmutableList.of((Object)Expressions.countStar(), (Object)Expressions.count((String)"some_nulls"), (Object)Expressions.max((String)"some_nulls"), (Object)Expressions.min((String)"some_nulls"));
        AggregateEvaluator aggregateEvaluator = AggregateEvaluator.create((Schema)SCHEMA, (List)list);
        for (DataFile dataFile : dataFiles) {
            aggregateEvaluator.update(dataFile);
        }
        Assertions.assertThat((boolean)aggregateEvaluator.allAggregatorsValid()).isFalse();
        StructLike result = aggregateEvaluator.result();
        Object[] expected = new Object[]{90L, null, null, null};
        this.assertEvaluatorResult(result, expected);
    }

    @Test
    public void testNoStats() {
        ImmutableList list = ImmutableList.of((Object)Expressions.countStar(), (Object)Expressions.count((String)"no_stats"), (Object)Expressions.max((String)"no_stats"), (Object)Expressions.min((String)"no_stats"));
        AggregateEvaluator aggregateEvaluator = AggregateEvaluator.create((Schema)SCHEMA, (List)list);
        for (DataFile dataFile : dataFiles) {
            aggregateEvaluator.update(dataFile);
        }
        Assertions.assertThat((boolean)aggregateEvaluator.allAggregatorsValid()).isFalse();
        StructLike result = aggregateEvaluator.result();
        Object[] expected = new Object[]{90L, null, null, null};
        this.assertEvaluatorResult(result, expected);
    }

    private void assertEvaluatorResult(StructLike result, Object[] expected) {
        Object[] actual = new Object[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            actual[i] = result.get(i, Object.class);
        }
        ((ObjectArrayAssert)Assertions.assertThat((Object[])actual).as("equals", new Object[0])).isEqualTo((Object)expected);
    }
}

