/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iceberg.metrics.DefaultTimer;
import org.apache.iceberg.metrics.Timer;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDefaultTimer {
    @Test
    public void nullCheck() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultTimer(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid time unit: null");
    }

    @Test
    public void nameAndUnit() {
        DefaultTimer timer = new DefaultTimer(TimeUnit.MINUTES);
        Assertions.assertThat((Comparable)((Object)timer.unit())).isEqualTo((Object)TimeUnit.MINUTES);
        Assertions.assertThat((boolean)timer.isNoop()).isFalse();
    }

    @Test
    public void noop() {
        Assertions.assertThat((boolean)Timer.NOOP.isNoop()).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Timer)Timer.NOOP).count()).isInstanceOf(UnsupportedOperationException.class)).hasMessage("NOOP timer has no count");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Timer)Timer.NOOP).totalDuration()).isInstanceOf(UnsupportedOperationException.class)).hasMessage("NOOP timer has no duration");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Timer)Timer.NOOP).unit()).isInstanceOf(UnsupportedOperationException.class)).hasMessage("NOOP timer has no unit");
    }

    @Test
    public void recordNegativeAmount() {
        DefaultTimer timer = new DefaultTimer(TimeUnit.NANOSECONDS);
        Assertions.assertThat((long)timer.count()).isEqualTo(0L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDefaultTimer.lambda$recordNegativeAmount$1((Timer)timer)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot record -1 NANOSECONDS: must be >= 0");
        Assertions.assertThat((long)timer.count()).isEqualTo(0L);
        Assertions.assertThat((Duration)timer.totalDuration()).isEqualTo((Object)Duration.ZERO);
    }

    @Test
    public void multipleStops() {
        DefaultTimer timer = new DefaultTimer(TimeUnit.NANOSECONDS);
        Timer.Timed timed = timer.start();
        timed.stop();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Timer.Timed)timed).stop()).isInstanceOf(IllegalStateException.class)).hasMessage("stop() called multiple times");
    }

    @Test
    public void closeableTimer() throws InterruptedException {
        DefaultTimer timer = new DefaultTimer(TimeUnit.NANOSECONDS);
        Assertions.assertThat((long)timer.count()).isEqualTo(0L);
        Assertions.assertThat((Duration)timer.totalDuration()).isEqualTo((Object)Duration.ZERO);
        try (Timer.Timed sample = timer.start();){
            Thread.sleep(500L);
        }
        Assertions.assertThat((long)timer.count()).isEqualTo(1L);
        Assertions.assertThat((Duration)timer.totalDuration()).isGreaterThan((Comparable)Duration.ZERO);
    }

    @Test
    public void measureRunnable() {
        DefaultTimer timer = new DefaultTimer(TimeUnit.NANOSECONDS);
        Runnable runnable = () -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        };
        Assertions.assertThat((long)timer.count()).isEqualTo(0L);
        Assertions.assertThat((Duration)timer.totalDuration()).isEqualTo((Object)Duration.ZERO);
        timer.time(runnable);
        Assertions.assertThat((long)timer.count()).isEqualTo(1L);
        Duration duration = timer.totalDuration();
        Assertions.assertThat((Duration)duration).isGreaterThan((Comparable)Duration.ZERO);
        timer.time(runnable);
        Assertions.assertThat((long)timer.count()).isEqualTo(2L);
        Duration secondDuration = timer.totalDuration();
        Assertions.assertThat((Duration)secondDuration).isGreaterThan((Comparable)duration);
    }

    @Test
    public void measureCallable() throws Exception {
        DefaultTimer timer = new DefaultTimer(TimeUnit.NANOSECONDS);
        Callable<Boolean> callable = () -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return true;
        };
        Assertions.assertThat((long)timer.count()).isEqualTo(0L);
        Assertions.assertThat((Duration)timer.totalDuration()).isEqualTo((Object)Duration.ZERO);
        Assertions.assertThat((boolean)((Boolean)timer.timeCallable(callable))).isTrue();
        Assertions.assertThat((long)timer.count()).isEqualTo(1L);
        Duration duration = timer.totalDuration();
        Assertions.assertThat((Duration)duration).isGreaterThan((Comparable)Duration.ZERO);
        Assertions.assertThat((boolean)((Boolean)timer.timeCallable(callable))).isTrue();
        Assertions.assertThat((long)timer.count()).isEqualTo(2L);
        Duration secondDuration = timer.totalDuration();
        Assertions.assertThat((Duration)secondDuration).isGreaterThan((Comparable)duration);
    }

    @Test
    public void measureSupplier() {
        DefaultTimer timer = new DefaultTimer(TimeUnit.NANOSECONDS);
        Supplier<Boolean> supplier = () -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return true;
        };
        Assertions.assertThat((long)timer.count()).isEqualTo(0L);
        Assertions.assertThat((Duration)timer.totalDuration()).isEqualTo((Object)Duration.ZERO);
        Assertions.assertThat((boolean)((Boolean)timer.time(supplier))).isTrue();
        Assertions.assertThat((long)timer.count()).isEqualTo(1L);
        Duration duration = timer.totalDuration();
        Assertions.assertThat((Duration)duration).isGreaterThan((Comparable)Duration.ZERO);
        Assertions.assertThat((boolean)((Boolean)timer.time(supplier))).isTrue();
        Assertions.assertThat((long)timer.count()).isEqualTo(2L);
        Duration secondDuration = timer.totalDuration();
        Assertions.assertThat((Duration)secondDuration).isGreaterThan((Comparable)duration);
    }

    @Test
    public void measureNestedRunnables() {
        DefaultTimer timer = new DefaultTimer(TimeUnit.NANOSECONDS);
        DefaultTimer innerTimer = new DefaultTimer(TimeUnit.NANOSECONDS);
        Runnable inner = () -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        };
        Runnable outer = () -> TestDefaultTimer.lambda$measureNestedRunnables$6((Timer)innerTimer, inner);
        Assertions.assertThat((long)timer.count()).isEqualTo(0L);
        Assertions.assertThat((Duration)timer.totalDuration()).isEqualTo((Object)Duration.ZERO);
        Assertions.assertThat((long)innerTimer.count()).isEqualTo(0L);
        Assertions.assertThat((Duration)innerTimer.totalDuration()).isEqualTo((Object)Duration.ZERO);
        timer.time(outer);
        Assertions.assertThat((long)timer.count()).isEqualTo(1L);
        Duration outerDuration = timer.totalDuration();
        Assertions.assertThat((Duration)outerDuration).isGreaterThan((Comparable)Duration.ZERO);
        Assertions.assertThat((long)innerTimer.count()).isEqualTo(1L);
        Duration innerDuration = innerTimer.totalDuration();
        Assertions.assertThat((Duration)innerDuration).isGreaterThan((Comparable)Duration.ZERO);
        Assertions.assertThat((Duration)outerDuration).isGreaterThan((Comparable)innerDuration);
    }

    @Test
    public void multiThreadedStarts() throws InterruptedException {
        DefaultTimer timer = new DefaultTimer(TimeUnit.NANOSECONDS);
        int threads = 10;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        List futures = IntStream.range(0, threads).mapToObj(arg_0 -> TestDefaultTimer.lambda$multiThreadedStarts$8(executor, barrier, (Timer)timer, arg_0)).collect(Collectors.toList());
        futures.stream().map(f -> {
            try {
                return (Duration)f.get(30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).forEach(d -> System.out.println("d = " + d));
        executor.shutdownNow();
        executor.awaitTermination(5L, TimeUnit.SECONDS);
        Assertions.assertThat((Duration)timer.totalDuration()).isEqualTo((Object)Duration.ofNanos(5 * threads));
        Assertions.assertThat((long)timer.count()).isEqualTo((long)threads);
    }

    private static /* synthetic */ Future lambda$multiThreadedStarts$8(ExecutorService executor, CyclicBarrier barrier, Timer timer, int threadNumber) {
        return executor.submit(() -> {
            try {
                barrier.await(30L, TimeUnit.SECONDS);
                timer.record(5L, TimeUnit.NANOSECONDS);
                return timer.totalDuration();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static /* synthetic */ void lambda$measureNestedRunnables$6(Timer innerTimer, Runnable inner) {
        try {
            Thread.sleep(100L);
            innerTimer.time(inner);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void lambda$recordNegativeAmount$1(Timer timer) throws Throwable {
        timer.record(-1L, TimeUnit.NANOSECONDS);
    }
}

