/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.UUID;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.relocated.com.google.common.hash.HashFunction;
import org.apache.iceberg.relocated.com.google.common.hash.Hashing;
import org.apache.iceberg.transforms.Bucket;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.BucketUtil;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestBucketing {
    private static final HashFunction MURMUR3 = Hashing.murmur3_32_fixed();
    private static Constructor<UUID> uuidBytesConstructor;
    private Random testRandom = null;

    @BeforeAll
    public static void getUUIDConstructor() {
        try {
            uuidBytesConstructor = UUID.class.getDeclaredConstructor(byte[].class);
            uuidBytesConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @BeforeEach
    public void initRandom() {
        this.testRandom = new Random(314358L);
    }

    @Test
    public void testSpecValues() {
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((int)1)).as("Spec example: hash(true) = 1392991556", new Object[0])).isEqualTo(1392991556);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((int)34)).as("Spec example: hash(34) = 2017239379", new Object[0])).isEqualTo(2017239379);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((long)34L)).as("Spec example: hash(34L) = 2017239379", new Object[0])).isEqualTo(2017239379);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((float)1.0f)).as("Spec example: hash(17.11F) = -142385009", new Object[0])).isEqualTo(-142385009);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((double)1.0)).as("Spec example: hash(17.11D) = -142385009", new Object[0])).isEqualTo(-142385009);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((float)0.0f)).as("Spec example: hash(0.0F) = 1669671676", new Object[0])).isEqualTo(1669671676);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((float)-0.0f)).as("Spec example: hash(-0.0F) = 1669671676", new Object[0])).isEqualTo(1669671676);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((double)0.0)).as("Spec example: hash(0.0) = 1669671676", new Object[0])).isEqualTo(1669671676);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((double)-0.0)).as("Spec example: hash(-0.0) = 1669671676", new Object[0])).isEqualTo(1669671676);
        ((AbstractIntegerAssert)((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((BigDecimal)new BigDecimal("14.20"))).as("Spec example: hash(decimal2(14.20)) = -500754589", new Object[0])).isEqualTo(-500754589).as("Spec example: hash(decimal2(14.20)) = -500754589", new Object[0])).isEqualTo(-500754589);
        Literal date = Literal.of((CharSequence)"2017-11-16").to((Type)Types.DateType.get());
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((int)((Integer)date.value()))).as("Spec example: hash(2017-11-16) = -653330422", new Object[0])).isEqualTo(-653330422);
        Literal timeValue = Literal.of((CharSequence)"22:31:08").to((Type)Types.TimeType.get());
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((long)((Long)timeValue.value()))).as("Spec example: hash(22:31:08) = -662762989", new Object[0])).isEqualTo(-662762989);
        Literal timestampVal = Literal.of((CharSequence)"2017-11-16T22:31:08").to((Type)Types.TimestampType.withoutZone());
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((long)((Long)timestampVal.value()))).as("Spec example: hash(2017-11-16T22:31:08) = -2047944441", new Object[0])).isEqualTo(-2047944441);
        Literal timestamptzVal = Literal.of((CharSequence)"2017-11-16T14:31:08-08:00").to((Type)Types.TimestampType.withZone());
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((long)((Long)timestamptzVal.value()))).as("Spec example: hash(2017-11-16T14:31:08-08:00) = -2047944441", new Object[0])).isEqualTo(-2047944441);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((CharSequence)"iceberg")).as("Spec example: hash(\"iceberg\") = 1210000089", new Object[0])).isEqualTo(1210000089);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((CharSequence)new Utf8("iceberg"))).as("Spec example: hash(\"iceberg\") = 1210000089", new Object[0])).isEqualTo(1210000089);
        Literal uuid = Literal.of((CharSequence)"f79c3e09-677c-4bbd-a479-3f349cb785e7").to((Type)Types.UUIDType.get());
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((UUID)((UUID)uuid.value()))).as("Spec example: hash(f79c3e09-677c-4bbd-a479-3f349cb785e7) = 1488055340", new Object[0])).isEqualTo(1488055340);
        ByteBuffer bytes = ByteBuffer.wrap(new byte[]{0, 1, 2, 3});
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((ByteBuffer)bytes)).as("Spec example: hash([00 01 02 03]) = -188683207", new Object[0])).isEqualTo(-188683207);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((ByteBuffer)bytes)).as("Spec example: hash([00 01 02 03]) = -188683207", new Object[0])).isEqualTo(-188683207);
    }

    @Test
    public void testInteger() {
        int num = this.testRandom.nextInt();
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(num);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((int)num)).as("Integer hash should match hash of little-endian bytes", new Object[0])).isEqualTo(this.hashBytes(buffer.array()));
    }

    @Test
    public void testLong() {
        long num = this.testRandom.nextLong();
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(num);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((long)num)).as("Long hash should match hash of little-endian bytes", new Object[0])).isEqualTo(this.hashBytes(buffer.array()));
    }

    @Test
    public void testIntegerTypePromotion() {
        int randomInt = this.testRandom.nextInt();
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((long)randomInt)).as("Integer and Long bucket results should match", new Object[0])).isEqualTo(BucketUtil.hash((int)randomInt));
    }

    @Test
    public void testFloatTypePromotion() {
        float randomFloat = this.testRandom.nextFloat();
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((double)randomFloat)).as("Float and Double bucket results should match", new Object[0])).isEqualTo(BucketUtil.hash((float)randomFloat));
    }

    @Test
    public void testFloatNegativeZero() {
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((float)0.0f)).as("Positive and negative 0.0f should have the same hash", new Object[0])).isEqualTo(BucketUtil.hash((float)-0.0f));
    }

    @Test
    public void testDoubleNegativeZero() {
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((double)0.0)).as("Positive and negative 0.0 should have the same hash", new Object[0])).isEqualTo(BucketUtil.hash((double)-0.0));
    }

    @Test
    public void testFloatNaN() {
        float[] testNaNs;
        double canonicalNaN = Double.longBitsToDouble(9221120237041090560L);
        for (float value : testNaNs = new float[]{Float.NaN, Float.intBitsToFloat(2139095041), Float.intBitsToFloat(2140847326), Float.intBitsToFloat(2146290601), Float.intBitsToFloat(Integer.MAX_VALUE), Float.intBitsToFloat(-8388607), Float.intBitsToFloat(-6636322), Float.intBitsToFloat(-1193047), Float.intBitsToFloat(-1)}) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)Float.isNaN(value)).as("Bit pattern is expected to be NaN.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((double)canonicalNaN)).as("All NaN representations should result in the same hash", new Object[0])).isEqualTo(BucketUtil.hash((float)value));
        }
    }

    @Test
    public void testDoubleNaN() {
        double[] testNaNs;
        double canonicalNaN = Double.longBitsToDouble(9221120237041090560L);
        for (double value : testNaNs = new double[]{Double.NaN, Double.longBitsToDouble(9218868437227405313L), Double.longBitsToDouble(9219188693200907213L), Double.longBitsToDouble(9222751540906115873L), Double.longBitsToDouble(Long.MAX_VALUE), Double.longBitsToDouble(-4503599627370495L), Double.longBitsToDouble(-4183343653868595L), Double.longBitsToDouble(-620495948659935L), Double.longBitsToDouble(-1L)}) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)Double.isNaN(value)).as("Bit pattern is expected to be NaN.", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((double)canonicalNaN)).as("All NaN representations should result in the same hash", new Object[0])).isEqualTo(BucketUtil.hash((double)value));
        }
    }

    @Test
    public void testDecimal() {
        double num = this.testRandom.nextDouble();
        BigDecimal decimal = BigDecimal.valueOf(num);
        byte[] unscaledBytes = decimal.unscaledValue().toByteArray();
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((BigDecimal)decimal)).as("Decimal hash should match hash of backing bytes", new Object[0])).isEqualTo(this.hashBytes(unscaledBytes));
    }

    @Test
    public void testString() {
        String string = "string to test murmur3 hash";
        byte[] asBytes = string.getBytes(StandardCharsets.UTF_8);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((CharSequence)string)).as("String hash should match hash of UTF-8 bytes", new Object[0])).isEqualTo(this.hashBytes(asBytes));
    }

    @Test
    public void testStringWithSurrogatePair() {
        String string = "string with a surrogate pair: \ud83d\udcb0";
        ((AbstractLongAssert)Assertions.assertThat((long)string.codePoints().count()).as("string has no surrogate pairs", new Object[0])).isNotEqualTo((long)string.length());
        byte[] asBytes = string.getBytes(StandardCharsets.UTF_8);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((CharSequence)string)).as("String hash should match hash of UTF-8 bytes", new Object[0])).isEqualTo(this.hashBytes(asBytes));
    }

    @Test
    public void testUtf8() {
        Utf8 utf8 = new Utf8("string to test murmur3 hash");
        byte[] asBytes = utf8.toString().getBytes(StandardCharsets.UTF_8);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((CharSequence)utf8)).as("String hash should match hash of UTF-8 bytes", new Object[0])).isEqualTo(this.hashBytes(asBytes));
    }

    @Test
    public void testByteBufferOnHeap() {
        byte[] bytes = this.randomBytes(128);
        ByteBuffer buffer = ByteBuffer.wrap(bytes, 5, 100);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((ByteBuffer)buffer)).as("HeapByteBuffer hash should match hash for correct slice", new Object[0])).isEqualTo(this.hashBytes(bytes, 5, 100));
        ((AbstractIntegerAssert)Assertions.assertThat((int)buffer.position()).as("Buffer position should not change", new Object[0])).isEqualTo(5);
        ((AbstractIntegerAssert)Assertions.assertThat((int)buffer.limit()).as("Buffer limit should not change", new Object[0])).isEqualTo(105);
    }

    @Test
    public void testByteBufferOnHeapArrayOffset() {
        byte[] bytes = this.randomBytes(128);
        ByteBuffer raw = ByteBuffer.wrap(bytes, 5, 100);
        ByteBuffer buffer = raw.slice();
        ((AbstractIntegerAssert)Assertions.assertThat((int)buffer.arrayOffset()).as("Buffer arrayOffset should be 5", new Object[0])).isEqualTo(5);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((ByteBuffer)buffer)).as("HeapByteBuffer hash should match hash for correct slice", new Object[0])).isEqualTo(this.hashBytes(bytes, 5, 100));
        ((AbstractIntegerAssert)Assertions.assertThat((int)buffer.position()).as("Buffer position should be 0", new Object[0])).isEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)buffer.limit()).as("Buffer limit should not change", new Object[0])).isEqualTo(100);
    }

    @Test
    public void testByteBufferOffHeap() {
        byte[] bytes = this.randomBytes(128);
        ByteBuffer buffer = ByteBuffer.allocateDirect(128);
        buffer.position(5);
        buffer.limit(105);
        buffer.mark();
        buffer.put(bytes, 5, 100);
        buffer.reset();
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((ByteBuffer)buffer)).as("DirectByteBuffer hash should match hash for correct slice", new Object[0])).isEqualTo(this.hashBytes(bytes, 5, 100));
        ((AbstractIntegerAssert)Assertions.assertThat((int)buffer.position()).as("Buffer position should not change", new Object[0])).isEqualTo(5);
        ((AbstractIntegerAssert)Assertions.assertThat((int)buffer.limit()).as("Buffer limit should not change", new Object[0])).isEqualTo(105);
    }

    @Test
    public void testUUIDHash() {
        byte[] uuidBytes = this.randomBytes(16);
        UUID uuid = TestBucketing.newUUID(uuidBytes);
        ((AbstractIntegerAssert)Assertions.assertThat((int)BucketUtil.hash((UUID)uuid)).as("UUID hash should match hash of backing bytes", new Object[0])).isEqualTo(this.hashBytes(uuidBytes));
    }

    @Test
    public void testVerifiedIllegalNumBuckets() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Bucket.get((int)0)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid number of buckets: 0 (must be > 0)");
    }

    private byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        this.testRandom.nextBytes(bytes);
        return bytes;
    }

    private int hashBytes(byte[] bytes) {
        return this.hashBytes(bytes, 0, bytes.length);
    }

    private int hashBytes(byte[] bytes, int offset, int length) {
        return MURMUR3.hashBytes(bytes, offset, length).asInt();
    }

    private static UUID newUUID(byte[] bytes) {
        try {
            return uuidBytesConstructor.newInstance(new Object[]{bytes});
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

