/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.iceberg.transforms.Truncate;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SerializableFunction;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestTruncate {
    @Test
    public void testDeprecatedTruncateInteger() {
        Truncate trunc = Truncate.get((Type)Types.IntegerType.get(), (int)10);
        Assertions.assertThat((int)((Integer)trunc.apply((Object)0))).isZero();
        Assertions.assertThat((int)((Integer)trunc.apply((Object)1))).isZero();
        Assertions.assertThat((int)((Integer)trunc.apply((Object)5))).isZero();
        Assertions.assertThat((int)((Integer)trunc.apply((Object)9))).isZero();
        Assertions.assertThat((int)((Integer)trunc.apply((Object)10))).isEqualTo(10);
        Assertions.assertThat((int)((Integer)trunc.apply((Object)11))).isEqualTo(10);
        Assertions.assertThat((int)((Integer)trunc.apply((Object)-1))).isEqualTo(-10);
        Assertions.assertThat((int)((Integer)trunc.apply((Object)-5))).isEqualTo(-10);
        Assertions.assertThat((int)((Integer)trunc.apply((Object)-10))).isEqualTo(-10);
        Assertions.assertThat((int)((Integer)trunc.apply((Object)-11))).isEqualTo(-20);
    }

    @Test
    public void testTruncateInteger() {
        SerializableFunction trunc = Truncate.get((int)10).bind((Type)Types.IntegerType.get());
        Assertions.assertThat((int)((Integer)trunc.apply(0))).isZero();
        Assertions.assertThat((int)((Integer)trunc.apply(1))).isZero();
        Assertions.assertThat((int)((Integer)trunc.apply(5))).isZero();
        Assertions.assertThat((int)((Integer)trunc.apply(9))).isZero();
        Assertions.assertThat((int)((Integer)trunc.apply(10))).isEqualTo(10);
        Assertions.assertThat((int)((Integer)trunc.apply(11))).isEqualTo(10);
        Assertions.assertThat((int)((Integer)trunc.apply(-1))).isEqualTo(-10);
        Assertions.assertThat((int)((Integer)trunc.apply(-5))).isEqualTo(-10);
        Assertions.assertThat((int)((Integer)trunc.apply(-10))).isEqualTo(-10);
        Assertions.assertThat((int)((Integer)trunc.apply(-11))).isEqualTo(-20);
    }

    @Test
    public void testTruncateLong() {
        SerializableFunction trunc = Truncate.get((int)10).bind((Type)Types.LongType.get());
        Assertions.assertThat((long)((Long)trunc.apply(0L))).isZero();
        Assertions.assertThat((long)((Long)trunc.apply(1L))).isZero();
        Assertions.assertThat((long)((Long)trunc.apply(5L))).isZero();
        Assertions.assertThat((long)((Long)trunc.apply(9L))).isZero();
        Assertions.assertThat((long)((Long)trunc.apply(10L))).isEqualTo(10L);
        Assertions.assertThat((long)((Long)trunc.apply(11L))).isEqualTo(10L);
        Assertions.assertThat((long)((Long)trunc.apply(-1L))).isEqualTo(-10L);
        Assertions.assertThat((long)((Long)trunc.apply(-5L))).isEqualTo(-10L);
        Assertions.assertThat((long)((Long)trunc.apply(-10L))).isEqualTo(-10L);
        Assertions.assertThat((long)((Long)trunc.apply(-11L))).isEqualTo(-20L);
    }

    @Test
    public void testTruncateDecimal() {
        SerializableFunction trunc = Truncate.get((int)10).bind((Type)Types.DecimalType.of((int)9, (int)2));
        Assertions.assertThat(trunc.apply(new BigDecimal("12.34"))).isEqualTo((Object)new BigDecimal("12.30"));
        Assertions.assertThat(trunc.apply(new BigDecimal("12.30"))).isEqualTo((Object)new BigDecimal("12.30"));
        Assertions.assertThat(trunc.apply(new BigDecimal("12.29"))).isEqualTo((Object)new BigDecimal("12.20"));
        Assertions.assertThat(trunc.apply(new BigDecimal("0.05"))).isEqualTo((Object)new BigDecimal("0.00"));
        Assertions.assertThat(trunc.apply(new BigDecimal("-0.05"))).isEqualTo((Object)new BigDecimal("-0.10"));
    }

    @Test
    public void testTruncateString() {
        SerializableFunction trunc = Truncate.get((int)5).bind((Type)Types.StringType.get());
        ((ObjectAssert)Assertions.assertThat(trunc.apply("abcdefg")).as("Should truncate strings longer than length", new Object[0])).isEqualTo((Object)"abcde");
        ((ObjectAssert)Assertions.assertThat(trunc.apply("abc")).as("Should not pad strings shorter than length", new Object[0])).isEqualTo((Object)"abc");
        ((ObjectAssert)Assertions.assertThat(trunc.apply("abcde")).as("Should not alter strings equal to length", new Object[0])).isEqualTo((Object)"abcde");
    }

    @Test
    public void testTruncateByteBuffer() {
        SerializableFunction trunc = Truncate.get((int)4).bind((Type)Types.BinaryType.get());
        ((ObjectAssert)Assertions.assertThat(trunc.apply(ByteBuffer.wrap("abcdefg".getBytes(StandardCharsets.UTF_8)))).as("Should truncate binary longer than length", new Object[0])).isEqualTo((Object)ByteBuffer.wrap("abcd".getBytes(StandardCharsets.UTF_8)));
        ((ObjectAssert)Assertions.assertThat(trunc.apply(ByteBuffer.wrap("abc".getBytes(StandardCharsets.UTF_8)))).as("Should not pad binary shorter than length", new Object[0])).isEqualTo((Object)ByteBuffer.wrap("abc".getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    public void testVerifiedIllegalWidth() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Truncate.get((int)0)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid truncate width: 0 (must be > 0)");
    }
}

