/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.CheckCompatibility;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class TestReadabilityChecks {
    private static final Type.PrimitiveType[] PRIMITIVES = new Type.PrimitiveType[]{Types.BooleanType.get(), Types.IntegerType.get(), Types.LongType.get(), Types.FloatType.get(), Types.DoubleType.get(), Types.DateType.get(), Types.TimeType.get(), Types.TimestampType.withoutZone(), Types.TimestampType.withZone(), Types.StringType.get(), Types.UUIDType.get(), Types.FixedType.ofLength((int)3), Types.FixedType.ofLength((int)4), Types.BinaryType.get(), Types.DecimalType.of((int)9, (int)2), Types.DecimalType.of((int)11, (int)2), Types.DecimalType.of((int)9, (int)3)};

    @Test
    public void testPrimitiveTypes() {
        for (Type.PrimitiveType from : PRIMITIVES) {
            Schema fromSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"from_field", (Type)from)});
            for (Type.PrimitiveType to : PRIMITIVES) {
                List errors = CheckCompatibility.writeCompatibilityErrors((Schema)new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)to)}), (Schema)fromSchema);
                if (TypeUtil.isPromotionAllowed((Type)from, (Type.PrimitiveType)to)) {
                    ((ListAssert)Assertions.assertThat((List)errors).as("Should produce 0 error messages", new Object[0])).isEmpty();
                    continue;
                }
                Assertions.assertThat((List)errors).hasSize(1);
                ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain that promotion is not allowed", new Object[0])).contains(new CharSequence[]{"cannot be promoted to"});
            }
            this.testDisallowPrimitiveToStruct(from, fromSchema);
            this.testDisallowPrimitiveToList(from, fromSchema);
            this.testDisallowPrimitiveToMap(from, fromSchema);
        }
    }

    private void testDisallowPrimitiveToMap(Type.PrimitiveType from, Schema fromSchema) {
        Schema mapSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"map_field", (Type)Types.MapType.ofRequired((int)2, (int)3, (Type)Types.StringType.get(), (Type)from))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)mapSchema, (Schema)fromSchema);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain that primitive to map is not allowed", new Object[0])).contains(new CharSequence[]{"cannot be read as a map"});
    }

    private void testDisallowPrimitiveToList(Type.PrimitiveType from, Schema fromSchema) {
        Schema listSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"list_field", (Type)Types.ListType.ofRequired((int)2, (Type)from))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)listSchema, (Schema)fromSchema);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain that primitive to list is not allowed", new Object[0])).contains(new CharSequence[]{"cannot be read as a list"});
    }

    private void testDisallowPrimitiveToStruct(Type.PrimitiveType from, Schema fromSchema) {
        Schema structSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"struct_field", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"from", (Type)from)}))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)structSchema, (Schema)fromSchema);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain that primitive to struct is not allowed", new Object[0])).contains(new CharSequence[]{"cannot be read as a struct"});
    }

    @Test
    public void testRequiredSchemaField() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"from_field", (Type)Types.IntegerType.get())});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)Types.IntegerType.get())});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain that a required column is optional", new Object[0])).contains(new CharSequence[]{"should be required, but is optional"});
    }

    @Test
    public void testMissingSchemaField() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"other_field", (Type)Types.IntegerType.get())});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)Types.IntegerType.get())});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain that a required column is missing", new Object[0])).contains(new CharSequence[]{"is required, but is missing"});
    }

    @Test
    public void testRequiredStructField() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"from_field", (Type)Types.IntegerType.get())}))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)Types.IntegerType.get())}))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain that a required field is optional", new Object[0])).contains(new CharSequence[]{"should be required, but is optional"});
    }

    @Test
    public void testMissingRequiredStructField() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"from_field", (Type)Types.IntegerType.get())}))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)Types.IntegerType.get())}))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain that a required field is missing", new Object[0])).contains(new CharSequence[]{"is required, but is missing"});
    }

    @Test
    public void testMissingOptionalStructField() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"from_field", (Type)Types.IntegerType.get())}))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"to_field", (Type)Types.IntegerType.get())}))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).isEmpty();
    }

    @Test
    public void testIncompatibleStructField() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"from_field", (Type)Types.IntegerType.get())}))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)Types.FloatType.get())}))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain about incompatible types", new Object[0])).contains(new CharSequence[]{"cannot be promoted to float"});
    }

    @Test
    public void testIncompatibleStructAndPrimitive() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"from_field", (Type)Types.StringType.get())}))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StringType.get())});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain about incompatible types", new Object[0])).contains(new CharSequence[]{"struct cannot be read as a string"});
    }

    @Test
    public void testMultipleErrors() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"from_field", (Type)Types.IntegerType.get())}))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)Types.FloatType.get())}))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).hasSize(2);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain that a required field is optional", new Object[0])).contains(new CharSequence[]{"should be required, but is optional"});
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(1))).as("Should complain about incompatible types", new Object[0])).contains(new CharSequence[]{"cannot be promoted to float"});
    }

    @Test
    public void testRequiredMapValue() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_field", (Type)Types.MapType.ofOptional((int)1, (int)2, (Type)Types.StringType.get(), (Type)Types.IntegerType.get()))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_field", (Type)Types.MapType.ofRequired((int)1, (int)2, (Type)Types.StringType.get(), (Type)Types.IntegerType.get()))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain that values are optional", new Object[0])).contains(new CharSequence[]{"values should be required, but are optional"});
    }

    @Test
    public void testIncompatibleMapKey() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_field", (Type)Types.MapType.ofOptional((int)1, (int)2, (Type)Types.IntegerType.get(), (Type)Types.StringType.get()))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_field", (Type)Types.MapType.ofOptional((int)1, (int)2, (Type)Types.DoubleType.get(), (Type)Types.StringType.get()))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain about incompatible types", new Object[0])).contains(new CharSequence[]{"cannot be promoted to double"});
    }

    @Test
    public void testIncompatibleMapValue() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_field", (Type)Types.MapType.ofOptional((int)1, (int)2, (Type)Types.StringType.get(), (Type)Types.IntegerType.get()))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_field", (Type)Types.MapType.ofOptional((int)1, (int)2, (Type)Types.StringType.get(), (Type)Types.DoubleType.get()))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain about incompatible types", new Object[0])).contains(new CharSequence[]{"cannot be promoted to double"});
    }

    @Test
    public void testIncompatibleMapAndPrimitive() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_field", (Type)Types.MapType.ofOptional((int)1, (int)2, (Type)Types.StringType.get(), (Type)Types.IntegerType.get()))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_field", (Type)Types.StringType.get())});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain about incompatible types", new Object[0])).contains(new CharSequence[]{"map cannot be read as a string"});
    }

    @Test
    public void testRequiredListElement() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"list_field", (Type)Types.ListType.ofOptional((int)1, (Type)Types.IntegerType.get()))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"list_field", (Type)Types.ListType.ofRequired((int)1, (Type)Types.IntegerType.get()))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain that elements are optional", new Object[0])).contains(new CharSequence[]{"elements should be required, but are optional"});
    }

    @Test
    public void testIncompatibleListElement() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"list_field", (Type)Types.ListType.ofOptional((int)1, (Type)Types.IntegerType.get()))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"list_field", (Type)Types.ListType.ofOptional((int)1, (Type)Types.StringType.get()))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain about incompatible types", new Object[0])).contains(new CharSequence[]{"cannot be promoted to string"});
    }

    @Test
    public void testIncompatibleListAndPrimitive() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"list_field", (Type)Types.ListType.ofOptional((int)1, (Type)Types.IntegerType.get()))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"list_field", (Type)Types.StringType.get())});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain about incompatible types", new Object[0])).contains(new CharSequence[]{"list cannot be read as a string"});
    }

    @Test
    public void testDifferentFieldOrdering() {
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"field_a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"field_b", (Type)Types.IntegerType.get())}))});
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"field_b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"field_a", (Type)Types.IntegerType.get())}))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write, (boolean)false);
        ((ListAssert)Assertions.assertThat((List)errors).as("Should produce 0 error message", new Object[0])).isEmpty();
    }

    @Test
    public void testStructWriteReordering() {
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"field_a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"field_b", (Type)Types.IntegerType.get())}))});
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"field_b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"field_a", (Type)Types.IntegerType.get())}))});
        List errors = CheckCompatibility.writeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)errors.get(0))).as("Should complain about field_b before field_a", new Object[0])).contains(new CharSequence[]{"field_b is out of order, before field_a"});
    }

    @Test
    public void testStructReadReordering() {
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"field_a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"field_b", (Type)Types.IntegerType.get())}))});
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"field_b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"field_a", (Type)Types.IntegerType.get())}))});
        List errors = CheckCompatibility.readCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).isEmpty();
    }

    @Test
    public void testCaseInsensitiveSchemaProjection() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"locations", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())})))});
        Assertions.assertThat((Object)schema.caseInsensitiveSelect(new String[]{"ID"}).findField(0)).isNotNull();
        Assertions.assertThat((Object)schema.caseInsensitiveSelect(new String[]{"loCATIONs"}).findField(5)).isNotNull();
        Assertions.assertThat((Object)schema.caseInsensitiveSelect(new String[]{"LoCaTiOnS.LaT"}).findField(1)).isNotNull();
        Assertions.assertThat((Object)schema.caseInsensitiveSelect(new String[]{"locations.LONG"}).findField(2)).isNotNull();
    }

    @Test
    public void testCheckNullabilityRequiredSchemaField() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"from_field", (Type)Types.IntegerType.get())});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)Types.IntegerType.get())});
        List errors = CheckCompatibility.typeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).isEmpty();
    }

    @Test
    public void testCheckNullabilityRequiredStructField() {
        Schema write = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"from_field", (Type)Types.IntegerType.get())}))});
        Schema read = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"to_field", (Type)Types.IntegerType.get())}))});
        List errors = CheckCompatibility.typeCompatibilityErrors((Schema)read, (Schema)write);
        Assertions.assertThat((List)errors).isEmpty();
    }
}

