/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTypes {
    @Test
    public void fromPrimitiveString() {
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"boolean")).isSameAs((Object)Types.BooleanType.get());
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"BooLean")).isSameAs((Object)Types.BooleanType.get());
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"timestamp")).isSameAs((Object)Types.TimestampType.withoutZone());
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"Fixed[ 3 ]")).isEqualTo((Object)Types.FixedType.ofLength((int)3));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"Decimal( 2 , 3 )")).isEqualTo((Object)Types.DecimalType.of((int)2, (int)3));
        Assertions.assertThat((Object)Types.fromPrimitiveString((String)"Decimal(2,3)")).isEqualTo((Object)Types.DecimalType.of((int)2, (int)3));
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> Types.fromPrimitiveString((String)"Unknown")).withMessageContaining("Unknown");
    }
}

