/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public interface CloseableIterator<T>
extends Iterator<T>,
Closeable {
    public static <E> CloseableIterator<E> empty() {
        return CloseableIterator.withClose(Collections.emptyIterator());
    }

    public static <E> CloseableIterator<E> withClose(final Iterator<E> iterator) {
        if (iterator instanceof CloseableIterator) {
            return (CloseableIterator)iterator;
        }
        return new CloseableIterator<E>(){

            @Override
            public void close() throws IOException {
                if (iterator instanceof Closeable) {
                    ((Closeable)((Object)iterator)).close();
                }
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                return iterator.next();
            }
        };
    }

    public static <I, O> CloseableIterator<O> transform(final CloseableIterator<I> iterator, final Function<I, O> transform) {
        Preconditions.checkNotNull(transform, (Object)"Invalid transform: null");
        return new CloseableIterator<O>(){

            @Override
            public void close() throws IOException {
                iterator.close();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public O next() {
                return transform.apply(iterator.next());
            }
        };
    }

    public static <T> CloseableIterator<T> count(final Counter counter, final CloseableIterator<T> iterator) {
        return new CloseableIterator<T>(){

            @Override
            public void close() throws IOException {
                iterator.close();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                Object next = iterator.next();
                counter.increment();
                return next;
            }
        };
    }
}

