/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.math.BigDecimal;
import java.util.UUID;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLiteralSerialization {
    @Test
    public void testLiterals() throws Exception {
        Literal[] literals;
        for (Literal lit : literals = new Literal[]{Literal.of((boolean)false), Literal.of((int)34), Literal.of((long)35L), Literal.of((float)36.75f), Literal.of((double)8.75), Literal.of((CharSequence)"2017-11-29").to((Type)Types.DateType.get()), Literal.of((CharSequence)"11:30:07").to((Type)Types.TimeType.get()), Literal.of((CharSequence)"2017-11-29T11:30:07.123").to((Type)Types.TimestampType.withoutZone()), Literal.of((CharSequence)"2017-11-29T11:30:07.123+01:00").to((Type)Types.TimestampType.withZone()), Literal.of((CharSequence)"abc"), Literal.of((UUID)UUID.randomUUID()), Literal.of((byte[])new byte[]{1, 2, 3}).to((Type)Types.FixedType.ofLength((int)3)), Literal.of((byte[])new byte[]{3, 4, 5, 6}).to((Type)Types.BinaryType.get()), Literal.of((BigDecimal)new BigDecimal("122.50"))}) {
            this.checkValue(lit);
        }
    }

    private <T> void checkValue(Literal<T> lit) throws Exception {
        Literal<T> copy = TestHelpers.roundTripSerialize(lit);
        ((AbstractIntegerAssert)Assertions.assertThat((int)lit.comparator().compare(lit.value(), copy.value())).as("Literal's comparator should consider values equal", new Object[0])).isZero();
        ((AbstractIntegerAssert)Assertions.assertThat((int)copy.comparator().compare(lit.value(), copy.value())).as("Copy's comparator should consider values equal", new Object[0])).isZero();
    }
}

