/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.math.BigDecimal;
import java.util.stream.IntStream;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Literals;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

public class TestNumericLiteralConversions {
    @Test
    public void testIntegerToLongConversion() {
        Literal lit = Literal.of((int)34);
        Literal longLit = lit.to((Type)Types.LongType.get());
        Assertions.assertThat((long)((Long)longLit.value())).isEqualTo(34L);
    }

    @Test
    public void testIntegerToFloatConversion() {
        Literal lit = Literal.of((int)34);
        Literal floatLit = lit.to((Type)Types.FloatType.get());
        Assertions.assertThat((Float)((Float)floatLit.value())).isCloseTo(34.0f, Offset.offset((Number)Float.valueOf(1.0E-10f)));
    }

    @Test
    public void testIntegerToDoubleConversion() {
        Literal lit = Literal.of((int)34);
        Literal doubleLit = lit.to((Type)Types.DoubleType.get());
        Assertions.assertThat((Double)((Double)doubleLit.value())).isCloseTo(34.0, Offset.offset((Number)1.0E-10));
    }

    @Test
    public void testIntegerToDecimalConversion() {
        Literal lit = Literal.of((int)34);
        Assertions.assertThat((Object)lit.to((Type)Types.DecimalType.of((int)9, (int)0)).value()).isEqualTo((Object)new BigDecimal("34"));
        Assertions.assertThat((Object)lit.to((Type)Types.DecimalType.of((int)9, (int)2)).value()).isEqualTo((Object)new BigDecimal("34.00"));
        Assertions.assertThat((Object)lit.to((Type)Types.DecimalType.of((int)9, (int)4)).value()).isEqualTo((Object)new BigDecimal("34.0000"));
    }

    @Test
    public void testLongToIntegerConversion() {
        Literal lit = Literal.of((long)34L);
        Literal intLit = lit.to((Type)Types.IntegerType.get());
        Assertions.assertThat((int)((Integer)intLit.value())).isEqualTo(34);
        ((ObjectAssert)Assertions.assertThat((Object)Literal.of((long)0x80000000L).to((Type)Types.IntegerType.get())).as("Values above Integer.MAX_VALUE should be Literals.aboveMax()", new Object[0])).isEqualTo((Object)Literals.aboveMax());
        ((ObjectAssert)Assertions.assertThat((Object)Literal.of((long)-2147483649L).to((Type)Types.IntegerType.get())).as("Values below Integer.MIN_VALUE should be Literals.belowMin()", new Object[0])).isEqualTo((Object)Literals.belowMin());
    }

    @Test
    public void testLongToFloatConversion() {
        Literal lit = Literal.of((long)34L);
        Literal floatLit = lit.to((Type)Types.FloatType.get());
        Assertions.assertThat((Float)((Float)floatLit.value())).isCloseTo(34.0f, Offset.offset((Number)Float.valueOf(1.0E-10f)));
    }

    @Test
    public void testLongToDoubleConversion() {
        Literal lit = Literal.of((long)34L);
        Literal doubleLit = lit.to((Type)Types.DoubleType.get());
        Assertions.assertThat((Double)((Double)doubleLit.value())).isCloseTo(34.0, Offset.offset((Number)1.0E-10));
    }

    @Test
    public void testLongToDecimalConversion() {
        Literal lit = Literal.of((long)34L);
        Assertions.assertThat((Object)lit.to((Type)Types.DecimalType.of((int)9, (int)0)).value()).isEqualTo((Object)new BigDecimal("34"));
        Assertions.assertThat((Object)lit.to((Type)Types.DecimalType.of((int)9, (int)2)).value()).isEqualTo((Object)new BigDecimal("34.00"));
        Assertions.assertThat((Object)lit.to((Type)Types.DecimalType.of((int)9, (int)4)).value()).isEqualTo((Object)new BigDecimal("34.0000"));
    }

    @Test
    public void testFloatToDoubleConversion() {
        Literal lit = Literal.of((float)34.56f);
        Literal doubleLit = lit.to((Type)Types.DoubleType.get());
        Assertions.assertThat((Double)((Double)doubleLit.value())).isCloseTo(34.56, Offset.offset((Number)0.001));
    }

    @Test
    public void testFloatToDecimalConversion() {
        Literal lit = Literal.of((float)34.56f);
        ((ObjectAssert)Assertions.assertThat((Object)lit.to((Type)Types.DecimalType.of((int)9, (int)1)).value()).as("Value should round using HALF_UP", new Object[0])).isEqualTo((Object)new BigDecimal("34.6"));
        Assertions.assertThat((Object)lit.to((Type)Types.DecimalType.of((int)9, (int)2)).value()).isEqualTo((Object)new BigDecimal("34.56"));
        Assertions.assertThat((Object)lit.to((Type)Types.DecimalType.of((int)9, (int)4)).value()).isEqualTo((Object)new BigDecimal("34.5600"));
    }

    @Test
    public void testDoubleToFloatConversion() {
        Literal lit = Literal.of((double)34.56);
        Literal doubleLit = lit.to((Type)Types.FloatType.get());
        Assertions.assertThat((Float)((Float)doubleLit.value())).isCloseTo(34.56f, Offset.offset((Number)Float.valueOf(0.001f)));
        ((ObjectAssert)Assertions.assertThat((Object)Literal.of((double)6.805646932770577E38).to((Type)Types.FloatType.get())).as("Values above Float.MAX_VALUE should be Literals.aboveMax()", new Object[0])).isEqualTo((Object)Literals.aboveMax());
        ((ObjectAssert)Assertions.assertThat((Object)Literal.of((double)-6.805646932770577E38).to((Type)Types.FloatType.get())).as("Values below Float.MIN_VALUE should be Literals.belowMin()", new Object[0])).isEqualTo((Object)Literals.belowMin());
    }

    @Test
    public void testDoubleToDecimalConversion() {
        Literal lit = Literal.of((double)34.56);
        ((ObjectAssert)Assertions.assertThat((Object)lit.to((Type)Types.DecimalType.of((int)9, (int)1)).value()).as("Value should round using HALF_UP", new Object[0])).isEqualTo((Object)new BigDecimal("34.6"));
        Assertions.assertThat((Object)lit.to((Type)Types.DecimalType.of((int)9, (int)2)).value()).isEqualTo((Object)new BigDecimal("34.56"));
        Assertions.assertThat((Object)lit.to((Type)Types.DecimalType.of((int)9, (int)4)).value()).isEqualTo((Object)new BigDecimal("34.5600"));
    }

    @Test
    public void testDecimalToDecimalConversion() {
        Literal lit = Literal.of((BigDecimal)new BigDecimal("34.11"));
        IntStream.range(0, 10).forEach(scale -> {
            ((ObjectAssert)Assertions.assertThat((Object)lit.to((Type)Types.DecimalType.of((int)9, (int)scale))).as("Should return identical object", new Object[0])).isSameAs((Object)lit);
            ((ObjectAssert)Assertions.assertThat((Object)lit.to((Type)Types.DecimalType.of((int)11, (int)scale))).as("Should return identical object", new Object[0])).isSameAs((Object)lit);
        });
    }

    @Test
    public void testIntegerToDateConversion() {
        Literal lit = Literal.of((int)0);
        Assertions.assertThat((Object)new Literals.DateLiteral(Integer.valueOf(0))).isEqualTo((Object)lit.to((Type)Types.DateType.get()));
        lit = Literal.of((int)18250);
        Assertions.assertThat((Object)new Literals.DateLiteral(Integer.valueOf(18250))).isEqualTo((Object)lit.to((Type)Types.DateType.get()));
    }

    @Test
    public void testLongToDateConversion() {
        Literal lit = Literal.of((long)0L);
        Assertions.assertThat((Object)new Literals.DateLiteral(Integer.valueOf(0))).isEqualTo((Object)lit.to((Type)Types.DateType.get()));
        lit = Literal.of((long)18250L);
        Assertions.assertThat((Object)new Literals.DateLiteral(Integer.valueOf(18250))).isEqualTo((Object)lit.to((Type)Types.DateType.get()));
    }
}

