/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.StrictMetricsEvaluator;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStrictMetricsEvaluator {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"no_stats", (Type)Types.IntegerType.get()), Types.NestedField.required((int)3, (String)"required", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"all_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)5, (String)"some_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"no_nulls", (Type)Types.StringType.get()), Types.NestedField.required((int)7, (String)"always_5", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)8, (String)"all_nans", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)9, (String)"some_nans", (Type)Types.FloatType.get()), Types.NestedField.optional((int)10, (String)"no_nans", (Type)Types.FloatType.get()), Types.NestedField.optional((int)11, (String)"all_nulls_double", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)12, (String)"all_nans_v1_stats", (Type)Types.FloatType.get()), Types.NestedField.optional((int)13, (String)"nan_and_null_only", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)14, (String)"no_nan_stats", (Type)Types.DoubleType.get())});
    private static final int INT_MIN_VALUE = 30;
    private static final int INT_MAX_VALUE = 79;
    private static final DataFile FILE = new TestHelpers.TestDataFile("file.avro", TestHelpers.Row.of(new Object[0]), 50L, (Map<Integer, Long>)ImmutableMap.builder().put((Object)4, (Object)50L).put((Object)5, (Object)50L).put((Object)6, (Object)50L).put((Object)8, (Object)50L).put((Object)9, (Object)50L).put((Object)10, (Object)50L).put((Object)11, (Object)50L).put((Object)12, (Object)50L).put((Object)13, (Object)50L).put((Object)14, (Object)50L).buildOrThrow(), (Map<Integer, Long>)ImmutableMap.builder().put((Object)4, (Object)50L).put((Object)5, (Object)10L).put((Object)6, (Object)0L).put((Object)11, (Object)50L).put((Object)12, (Object)0L).put((Object)13, (Object)1L).buildOrThrow(), (Map<Integer, Long>)ImmutableMap.of((Object)8, (Object)50L, (Object)9, (Object)10L, (Object)10, (Object)0L), (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)30), (Object)7, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)5), (Object)12, (Object)Conversions.toByteBuffer((Type)Types.FloatType.get(), (Object)Float.valueOf(Float.NaN)), (Object)13, (Object)Conversions.toByteBuffer((Type)Types.DoubleType.get(), (Object)Double.NaN)), (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)79), (Object)7, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)5), (Object)12, (Object)Conversions.toByteBuffer((Type)Types.FloatType.get(), (Object)Float.valueOf(Float.NaN)), (Object)13, (Object)Conversions.toByteBuffer((Type)Types.DoubleType.get(), (Object)Double.NaN)));
    private static final DataFile FILE_2 = new TestHelpers.TestDataFile("file_2.avro", TestHelpers.Row.of(new Object[0]), 50L, (Map<Integer, Long>)ImmutableMap.of((Object)4, (Object)50L, (Object)5, (Object)50L, (Object)6, (Object)50L, (Object)8, (Object)50L), (Map<Integer, Long>)ImmutableMap.of((Object)4, (Object)50L, (Object)5, (Object)10L, (Object)6, (Object)0L), null, (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)5, (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"bbb")), (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)5, (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"eee")));
    private static final DataFile FILE_3 = new TestHelpers.TestDataFile("file_3.avro", TestHelpers.Row.of(new Object[0]), 50L, (Map<Integer, Long>)ImmutableMap.of((Object)4, (Object)50L, (Object)5, (Object)50L, (Object)6, (Object)50L), (Map<Integer, Long>)ImmutableMap.of((Object)4, (Object)50L, (Object)5, (Object)10L, (Object)6, (Object)0L), null, (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)5, (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"bbb")), (Map<Integer, ByteBuffer>)ImmutableMap.of((Object)5, (Object)Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"bbb")));

    @Test
    public void testAllNulls() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notNull((String)"all_nulls")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: no non-null value in all null column", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notNull((String)"some_nulls")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: column with some nulls contains a non-null value", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notNull((String)"no_nulls")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: non-null column contains no null values", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"all_nulls", (Object)"a")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: notEqual on all nulls column", new Object[0])).isTrue();
    }

    @Test
    public void testNoNulls() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.isNull((String)"all_nulls")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: all values are null", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.isNull((String)"some_nulls")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: not all values are null", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.isNull((String)"no_nulls")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: no values are null", new Object[0])).isFalse();
    }

    @Test
    public void testSomeNulls() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThan((String)"some_nulls", (Object)"ggg")).eval((ContentFile)FILE_2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: lessThan on some nulls column", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"some_nulls", (Object)"eee")).eval((ContentFile)FILE_2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: lessThanOrEqual on some nulls column", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThan((String)"some_nulls", (Object)"aaa")).eval((ContentFile)FILE_2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: greaterThan on some nulls column", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"some_nulls", (Object)"bbb")).eval((ContentFile)FILE_2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: greaterThanOrEqual on some nulls column", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"some_nulls", (Object)"bbb")).eval((ContentFile)FILE_3);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: equal on some nulls column", new Object[0])).isFalse();
    }

    @Test
    public void testIsNaN() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.isNaN((String)"all_nans")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: all values are nan", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.isNaN((String)"some_nans")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: at least one non-nan value in some nan column", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.isNaN((String)"no_nans")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: at least one non-nan value in no nan column", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.isNaN((String)"all_nulls_double")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: at least one non-nan value in all null column", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.isNaN((String)"no_nan_stats")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: cannot determine without nan stats", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.isNaN((String)"all_nans_v1_stats")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: cannot determine without nan stats", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.isNaN((String)"nan_and_null_only")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: null values are not nan", new Object[0])).isFalse();
    }

    @Test
    public void testNotNaN() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notNaN((String)"all_nans")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all values are nan", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notNaN((String)"some_nans")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: at least one nan value in some nan column", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notNaN((String)"no_nans")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: no value is nan", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notNaN((String)"all_nulls_double")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: no nan value in all null column", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notNaN((String)"no_nan_stats")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: cannot determine without nan stats", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notNaN((String)"all_nans_v1_stats")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all values are nan", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notNaN((String)"nan_and_null_only")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: null values are not nan", new Object[0])).isFalse();
    }

    @Test
    public void testRequiredColumn() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notNull((String)"required")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: required columns are always non-null", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.isNull((String)"required")).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: required columns never contain null", new Object[0])).isFalse();
    }

    @Test
    public void testMissingColumn() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThan((String)"missing", (Object)5)).eval((ContentFile)FILE)).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'missing'");
    }

    @Test
    public void testMissingStats() {
        Expression[] exprs;
        TestHelpers.TestDataFile missingStats = new TestHelpers.TestDataFile("file.parquet", TestHelpers.Row.of(new Object[0]), 50L);
        for (Expression expr : exprs = new Expression[]{Expressions.lessThan((String)"no_stats", (Object)5), Expressions.lessThanOrEqual((String)"no_stats", (Object)30), Expressions.equal((String)"no_stats", (Object)70), Expressions.greaterThan((String)"no_stats", (Object)78), Expressions.greaterThanOrEqual((String)"no_stats", (Object)90), Expressions.notEqual((String)"no_stats", (Object)101), Expressions.isNull((String)"no_stats"), Expressions.notNull((String)"no_stats"), Expressions.isNaN((String)"all_nans"), Expressions.notNaN((String)"all_nans")}) {
            boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, expr).eval((ContentFile)missingStats);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should never match when stats are missing for expr: " + expr, new Object[0])).isFalse();
        }
    }

    @Test
    public void testZeroRecordFile() {
        Expression[] exprs;
        TestHelpers.TestDataFile empty = new TestHelpers.TestDataFile("file.parquet", TestHelpers.Row.of(new Object[0]), 0L);
        for (Expression expr : exprs = new Expression[]{Expressions.lessThan((String)"id", (Object)5), Expressions.lessThanOrEqual((String)"id", (Object)30), Expressions.equal((String)"id", (Object)70), Expressions.greaterThan((String)"id", (Object)78), Expressions.greaterThanOrEqual((String)"id", (Object)90), Expressions.notEqual((String)"id", (Object)101), Expressions.isNull((String)"some_nulls"), Expressions.notNull((String)"some_nulls"), Expressions.isNaN((String)"all_nans"), Expressions.notNaN((String)"all_nans")}) {
            boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, expr).eval((ContentFile)empty);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should always match 0-record file: " + expr, new Object[0])).isTrue();
        }
    }

    @Test
    public void testNot() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.lessThan((String)"id", (Object)5))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: not(false)", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.greaterThan((String)"id", (Object)5))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: not(true)", new Object[0])).isFalse();
    }

    @Test
    public void testAnd() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, Expressions.and((Expression)Expressions.greaterThan((String)"id", (Object)5), (Expression)Expressions.lessThanOrEqual((String)"id", (Object)30))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: range may not overlap data", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, Expressions.and((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)0))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: range does not overlap data", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, Expressions.and((Expression)Expressions.lessThan((String)"id", (Object)85), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)0))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: range includes all data", new Object[0])).isTrue();
    }

    @Test
    public void testOr() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, Expressions.or((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)80))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: no matching values", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, Expressions.or((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)60))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some values do not match", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, Expressions.or((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)30))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: all values match >= 30", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerLt() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThan((String)"id", (Object)30)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: always false", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThan((String)"id", (Object)31)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 32 and greater not in range", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThan((String)"id", (Object)79)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 79 not in range", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThan((String)"id", (Object)80)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: all values in range", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerLtEq() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"id", (Object)29)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: always false", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"id", (Object)30)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 31 and greater not in range", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"id", (Object)79)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: all values in range", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.lessThanOrEqual((String)"id", (Object)80)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: all values in range", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerGt() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThan((String)"id", (Object)79)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: always false", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThan((String)"id", (Object)78)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 77 and less not in range", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThan((String)"id", (Object)30)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 30 not in range", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThan((String)"id", (Object)29)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: all values in range", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerGtEq() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)80)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: no values in range", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)79)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 78 and lower are not in range", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)31)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: 30 not in range", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)30)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: all values in range", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerEq() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)5)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all values != 5", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)30)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some values != 30", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)75)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some values != 75", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)79)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some values != 79", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"id", (Object)80)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some values != 80", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.equal((String)"always_5", (Object)5)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: all values == 5", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerNotEq() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)5)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: no values == 5", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)29)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: no values == 39", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)30)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some value may be == 30", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)75)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some value may be == 75", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)79)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some value may be == 79", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)80)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: no values == 80", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notEqual((String)"id", (Object)85)).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: no values == 85", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerNotEqRewritten() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)5))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: no values == 5", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)29))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: no values == 39", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)30))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some value may be == 30", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)75))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some value may be == 75", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)79))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some value may be == 79", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)80))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: no values == 80", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, Expressions.not((Expression)Expressions.equal((String)"id", (Object)85))).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: no values == 85", new Object[0])).isTrue();
    }

    @Test
    public void testIntegerIn() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{5, 6})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all values != 5 and != 6", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{29, 30})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some values != 30 and != 31", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{75, 76})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some values != 75 and != 76", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{79, 80})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some values != 78 and != 79", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"id", (Object[])new Integer[]{80, 81})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some values != 80 and != 81)", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"always_5", (Object[])new Integer[]{5, 6})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: all values == 5", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"all_nulls", (Object[])new String[]{"abc", "def"})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: in on all nulls column", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"some_nulls", (Object[])new String[]{"abc", "def"})).eval((ContentFile)FILE_3);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: in on some nulls column", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.in((String)"no_nulls", (Object[])new String[]{"abc", "def"})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: no_nulls field does not have bounds", new Object[0])).isFalse();
    }

    @Test
    public void testIntegerNotIn() {
        boolean shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{5, 6})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: all values !=5 and !=6", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{29, 30})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some values may be == 30", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{75, 76})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some value may be == 75 or == 76", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{79, 80})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: some value may be == 79", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{80, 81})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: no values == 80 or == 81", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"always_5", (Object[])new Integer[]{5, 6})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: all values == 5", new Object[0])).isFalse();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"all_nulls", (Object[])new String[]{"abc", "def"})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: notIn on all nulls column", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"some_nulls", (Object[])new String[]{"abc", "def"})).eval((ContentFile)FILE_3);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should match: notIn on some nulls column, 'bbb' > 'abc' and 'bbb' < 'def'", new Object[0])).isTrue();
        shouldRead = new StrictMetricsEvaluator(SCHEMA, (Expression)Expressions.notIn((String)"no_nulls", (Object[])new String[]{"abc", "def"})).eval((ContentFile)FILE);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not match: no_nulls field does not have bounds", new Object[0])).isFalse();
    }
}

