/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.False;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.transforms.Truncate;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStartsWith {
    private static final String COLUMN = "someStringCol";
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"someStringCol", (Type)Types.StringType.get())});

    @Test
    public void testTruncateProjections() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).truncate(COLUMN, 4).build();
        this.assertProjectionInclusive(spec, Expressions.startsWith((String)COLUMN, (String)"ab"), "ab", Expression.Operation.STARTS_WITH);
        this.assertProjectionInclusive(spec, Expressions.startsWith((String)COLUMN, (String)"abab"), "abab", Expression.Operation.EQ);
        this.assertProjectionInclusive(spec, Expressions.startsWith((String)COLUMN, (String)"ababab"), "abab", Expression.Operation.STARTS_WITH);
        this.assertProjectionStrict(spec, Expressions.startsWith((String)COLUMN, (String)"ab"), "ab", Expression.Operation.STARTS_WITH);
        this.assertProjectionStrict(spec, Expressions.startsWith((String)COLUMN, (String)"abab"), "abab", Expression.Operation.EQ);
        Expression projection = Projections.strict((PartitionSpec)spec).project((Expression)Expressions.startsWith((String)COLUMN, (String)"ababab"));
        Assertions.assertThat((Object)projection).isInstanceOf(False.class);
    }

    @Test
    public void testTruncateString() {
        Truncate trunc = Truncate.get((int)2);
        UnboundPredicate expr = Expressions.startsWith((String)COLUMN, (String)"abcde");
        BoundPredicate boundExpr = (BoundPredicate)Binder.bind((Types.StructType)SCHEMA.asStruct(), (Expression)expr, (boolean)false);
        UnboundPredicate projected = trunc.project(COLUMN, boundExpr);
        Evaluator evaluator = new Evaluator(SCHEMA.asStruct(), (Expression)projected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("abcdg"))).as("startsWith(abcde, truncate(abcdg,2))  => true", new Object[0])).isTrue();
    }

    private void assertProjectionInclusive(PartitionSpec spec, UnboundPredicate<?> filter, String expectedLiteral, Expression.Operation expectedOp) {
        Expression projection = Projections.inclusive((PartitionSpec)spec).project(filter);
        this.assertProjection(spec, expectedLiteral, projection, expectedOp);
    }

    private void assertProjectionStrict(PartitionSpec spec, UnboundPredicate<?> filter, String expectedLiteral, Expression.Operation expectedOp) {
        Expression projection = Projections.strict((PartitionSpec)spec).project(filter);
        this.assertProjection(spec, expectedLiteral, projection, expectedOp);
    }

    private void assertProjection(PartitionSpec spec, String expectedLiteral, Expression projection, Expression.Operation expectedOp) {
        UnboundPredicate predicate = TestHelpers.assertAndUnwrapUnbound(projection);
        Literal literal = predicate.literal();
        Truncate transform = (Truncate)((PartitionField)spec.getFieldsBySourceId(1).get(0)).transform();
        String output = transform.toHumanString((Type)Types.StringType.get(), (Object)((String)literal.value()));
        Assertions.assertThat((Comparable)predicate.op()).isEqualTo((Object)expectedOp);
        Assertions.assertThat((String)output).isEqualTo(expectedLiteral);
    }
}

