/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.Comparator;
import org.apache.iceberg.expressions.Literal;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestComparableComparator {
    @Test
    public void testNaturalOrder() {
        Comparator cmp = Literal.of((long)34L).comparator();
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(33L, 34L)).as("Should use the natural order for non-null values", new Object[0])).isLessThan(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(33L, -34L)).as("Should use signed ordering", new Object[0])).isGreaterThan(0);
    }

    @Test
    public void testNullHandling() {
        Comparator cmp = Literal.of((long)34L).comparator();
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(null, 34L)).as("null comes before non-null", new Object[0])).isLessThan(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(34L, null)).as("null comes before non-null", new Object[0])).isGreaterThan(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)cmp.compare(null, null)).as("null equals null", new Object[0])).isZero();
    }
}

