/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.CharSequenceMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCharSequenceMap {
    @Test
    public void nullString() {
        Assertions.assertThat((Map)CharSequenceMap.create()).doesNotContainKey(null);
        Assertions.assertThat((Map)CharSequenceMap.create()).doesNotContainValue(null);
    }

    @Test
    public void testEmptyMap() {
        CharSequenceMap map = CharSequenceMap.create();
        Assertions.assertThat((Map)map).isEmpty();
        Assertions.assertThat((Map)map).hasSize(0);
        Assertions.assertThat((Map)map).doesNotContainKey((Object)"key");
        Assertions.assertThat((Map)map).doesNotContainValue((Object)"value");
        Assertions.assertThat((Collection)map.values()).isEmpty();
        Assertions.assertThat((Collection)map.keySet()).isEmpty();
        Assertions.assertThat((Collection)map.entrySet()).isEmpty();
    }

    @Test
    public void testDifferentCharSequenceImplementations() {
        CharSequenceMap map = CharSequenceMap.create();
        map.put((CharSequence)"abc", (Object)"value1");
        map.put((CharSequence)new StringBuffer("def"), (Object)"value2");
        Assertions.assertThat((Map)map).containsEntry((Object)new StringBuilder("abc"), (Object)"value1");
        Assertions.assertThat((Map)map).containsEntry((Object)"def", (Object)"value2");
    }

    @Test
    public void testPutAndGet() {
        CharSequenceMap map = CharSequenceMap.create();
        map.put((CharSequence)"key1", (Object)"value1");
        Assertions.assertThat((Map)map).containsEntry((Object)"key1", (Object)"value1");
    }

    @Test
    public void testRemove() {
        CharSequenceMap map = CharSequenceMap.create();
        map.put((CharSequence)"key1", (Object)"value1");
        map.remove((Object)new StringBuilder("key1"));
        Assertions.assertThat((Map)map).doesNotContainKey((Object)"key1");
        Assertions.assertThat((Map)map).isEmpty();
    }

    @Test
    public void testPutAll() {
        CharSequenceMap map = CharSequenceMap.create();
        map.putAll((Map)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2"));
        Assertions.assertThat((Map)map).containsEntry((Object)"key1", (Object)"value1");
        Assertions.assertThat((Map)map).containsEntry((Object)"key2", (Object)"value2");
    }

    @Test
    public void testClear() {
        CharSequenceMap map = CharSequenceMap.create();
        map.put((CharSequence)"key1", (Object)"value1");
        map.clear();
        Assertions.assertThat((Map)map).isEmpty();
    }

    @Test
    public void testValues() {
        CharSequenceMap map = CharSequenceMap.create();
        map.put((CharSequence)"key1", (Object)"value1");
        map.put((CharSequence)"key2", (Object)"value2");
        Assertions.assertThat((Collection)map.values()).containsAll((Iterable)ImmutableList.of((Object)"value1", (Object)"value2"));
    }

    @Test
    public void testEntrySet() {
        CharSequenceMap map = CharSequenceMap.create();
        map.put((CharSequence)"key1", (Object)"value1");
        map.put((CharSequence)new StringBuilder("key2"), (Object)"value2");
        Assertions.assertThat((Collection)map.entrySet()).hasSize(2);
    }

    @Test
    public void testEquals() {
        CharSequenceMap map1 = CharSequenceMap.create();
        map1.put((CharSequence)new StringBuilder("key"), (Object)"value");
        CharSequenceMap map2 = CharSequenceMap.create();
        map2.put((CharSequence)"key", (Object)"value");
        Assertions.assertThat((Map)map1).isEqualTo((Object)map2);
    }

    @Test
    public void testHashCode() {
        CharSequenceMap map1 = CharSequenceMap.create();
        map1.put((CharSequence)new StringBuilder("key"), (Object)"value");
        CharSequenceMap map2 = CharSequenceMap.create();
        map2.put((CharSequence)"key", (Object)"value");
        Assertions.assertThat((int)map1.hashCode()).isEqualTo(map2.hashCode());
    }

    @Test
    public void testToString() {
        CharSequenceMap map = CharSequenceMap.create();
        Assertions.assertThat((String)map.toString()).isEqualTo("{}");
        map.put((CharSequence)"key1", (Object)"value1");
        Assertions.assertThat((String)map.toString()).isEqualTo("{key1=value1}");
        map.put((CharSequence)"key2", (Object)"value2");
        map.put((CharSequence)"key3", (Object)"value3");
        String toStringResult = map.toString();
        Assertions.assertThat((String)toStringResult).contains(new CharSequence[]{"key1=value1", "key2=value2", "key3=value3"});
    }

    @Test
    public void testComputeIfAbsent() {
        CharSequenceMap map = CharSequenceMap.create();
        String result1 = (String)map.computeIfAbsent((Object)"key1", key -> "computedValue1");
        Assertions.assertThat((String)result1).isEqualTo("computedValue1");
        Assertions.assertThat((Map)map).containsEntry((Object)"key1", (Object)"computedValue1");
        String result2 = (String)map.computeIfAbsent((Object)"key1", key -> "newValue");
        Assertions.assertThat((String)result2).isEqualTo("computedValue1");
        Assertions.assertThat((Map)map).containsEntry((Object)"key1", (Object)"computedValue1");
    }

    @Test
    public void testMerge() {
        CharSequenceMap map = CharSequenceMap.create();
        map.put((CharSequence)"key1", (Object)"value1");
        map.put((CharSequence)"key2", (Object)"value2");
        map.merge((Object)new StringBuilder("key1"), (Object)"newValue", (oldVal, newVal) -> oldVal + newVal);
        Assertions.assertThat((Map)map).containsEntry((Object)"key1", (Object)"value1newValue");
        map.merge((Object)new StringBuffer("key3"), (Object)"value3", (oldVal, newVal) -> oldVal + newVal);
        Assertions.assertThat((Map)map).containsEntry((Object)"key3", (Object)"value3");
        map.merge((Object)"key2", (Object)"replacedValue", (oldVal, newVal) -> null);
        Assertions.assertThat((Map)map).doesNotContainKey((Object)"key2");
        map.remove((Object)"key1");
        map.merge((Object)"key1", (Object)"reAddedValue", (oldVal, newVal) -> oldVal + newVal);
        Assertions.assertThat((Map)map).containsEntry((Object)"key1", (Object)"reAddedValue");
    }

    @Test
    public void testConcurrentReadAccess() throws InterruptedException {
        CharSequenceMap map = CharSequenceMap.create();
        map.put((CharSequence)"key1", (Object)"value1");
        map.put((CharSequence)"key2", (Object)"value2");
        map.put((CharSequence)"key3", (Object)"value3");
        int numThreads = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            executorService.submit(() -> {
                Assertions.assertThat((String)((String)map.get((Object)"key1"))).isEqualTo("value1");
                Assertions.assertThat((String)((String)map.get((Object)"key2"))).isEqualTo("value2");
                Assertions.assertThat((String)((String)map.get((Object)"key3"))).isEqualTo("value3");
            });
        }
        executorService.shutdown();
        Assertions.assertThat((boolean)executorService.awaitTermination(1L, TimeUnit.MINUTES)).isTrue();
    }
}

