/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;

public class ParameterizedTestExtension
implements TestTemplateInvocationContextProvider {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"parameterized"});
    private static final String PARAMETERS_STORE_KEY = "parameters";
    private static final String PARAMETER_FIELD_STORE_KEY_PREFIX = "parameterField_";
    private static final String INDEX_TEMPLATE = "{index}";

    public boolean supportsTestTemplate(ExtensionContext context) {
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        Object parameterValues;
        List parameterProviders = AnnotationSupport.findAnnotatedMethods((Class)context.getRequiredTestClass(), Parameters.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        if (parameterProviders.isEmpty()) {
            throw new IllegalStateException("Cannot find any parameter provider");
        }
        Method parameterProvider = (Method)parameterProviders.get(0);
        String testNameTemplate = parameterProvider.getAnnotation(Parameters.class).name();
        try {
            parameterProvider.setAccessible(true);
            parameterValues = parameterProvider.invoke(null, new Object[0]);
            context.getStore(NAMESPACE).put((Object)PARAMETERS_STORE_KEY, parameterValues);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to invoke parameter provider", e);
        }
        Preconditions.checkState((parameterValues != null ? 1 : 0) != 0, (Object)"Parameter values cannot be null");
        if (parameterValues instanceof Object[][]) {
            Object[][] typedParameterValues = (Object[][])parameterValues;
            return this.createContextForParameters(Arrays.stream(typedParameterValues), testNameTemplate, context);
        }
        if (parameterValues instanceof Collection) {
            Collection typedParameterValues = (Collection)parameterValues;
            Stream<Object[]> parameterValueStream = typedParameterValues.stream().map(parameterValue -> {
                if (parameterValue instanceof Object[]) {
                    return (Object[])parameterValue;
                }
                return new Object[]{parameterValue};
            });
            return this.createContextForParameters(parameterValueStream, testNameTemplate, context);
        }
        throw new IllegalStateException(String.format("Return type of @Parameters annotated method \"%s\" should be either Object[][] or Collection", parameterProvider));
    }

    private Stream<TestTemplateInvocationContext> createContextForParameters(Stream<Object[]> parameterValueStream, String testNameTemplate, ExtensionContext context) {
        List parameterFields = AnnotationSupport.findAnnotatedFields((Class)context.getRequiredTestClass(), Parameter.class, field -> true, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        if (parameterFields.isEmpty()) {
            return parameterValueStream.map(parameterValue -> new ConstructorParameterResolverInvocationContext(testNameTemplate, (Object[])parameterValue));
        }
        for (Field parameterField : parameterFields) {
            int index = parameterField.getAnnotation(Parameter.class).index();
            context.getStore(NAMESPACE).put((Object)ParameterizedTestExtension.getParameterFieldStoreKey(index), (Object)parameterField);
        }
        return parameterValueStream.map(parameterValue -> new FieldInjectingInvocationContext(testNameTemplate, (Object[])parameterValue));
    }

    private static String getParameterFieldStoreKey(int parameterIndex) {
        return PARAMETER_FIELD_STORE_KEY_PREFIX + parameterIndex;
    }

    private static Field getParameterField(int parameterIndex, ExtensionContext context) {
        return (Field)context.getStore(NAMESPACE).get((Object)ParameterizedTestExtension.getParameterFieldStoreKey(parameterIndex));
    }

    private static class ConstructorParameterResolverInvocationContext
    implements TestTemplateInvocationContext {
        private final String testNameTemplate;
        private final Object[] parameterValues;

        private ConstructorParameterResolverInvocationContext(String testNameTemplate, Object[] parameterValues) {
            this.testNameTemplate = testNameTemplate;
            this.parameterValues = parameterValues;
        }

        public String getDisplayName(int invocationIndex) {
            if (ParameterizedTestExtension.INDEX_TEMPLATE.equals(this.testNameTemplate)) {
                return super.getDisplayName(invocationIndex);
            }
            return MessageFormat.format(this.testNameTemplate, this.parameterValues);
        }

        public List<Extension> getAdditionalExtensions() {
            return Collections.singletonList(new ConstructorParameterResolver(this.parameterValues));
        }

        private static class ConstructorParameterResolver
        implements ParameterResolver {
            private final Object[] parameterValues;

            private ConstructorParameterResolver(Object[] parameterValues) {
                this.parameterValues = parameterValues;
            }

            public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
                return true;
            }

            public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
                return this.parameterValues[parameterContext.getIndex()];
            }
        }
    }

    private static class FieldInjectingInvocationContext
    implements TestTemplateInvocationContext {
        private final String testNameTemplate;
        private final Object[] parameterValues;

        private FieldInjectingInvocationContext(String testNameTemplate, Object[] parameterValues) {
            this.testNameTemplate = testNameTemplate;
            this.parameterValues = parameterValues;
        }

        public String getDisplayName(int invocationIndex) {
            if (ParameterizedTestExtension.INDEX_TEMPLATE.equals(this.testNameTemplate)) {
                return super.getDisplayName(invocationIndex);
            }
            return MessageFormat.format(this.testNameTemplate, this.parameterValues);
        }

        public List<Extension> getAdditionalExtensions() {
            return Collections.singletonList(new FieldInjectingHook(this.parameterValues));
        }

        private static class FieldInjectingHook
        implements BeforeEachCallback {
            private final Object[] parameterValues;

            private FieldInjectingHook(Object[] parameterValues) {
                this.parameterValues = parameterValues;
            }

            public void beforeEach(ExtensionContext context) throws Exception {
                for (int i = 0; i < this.parameterValues.length; ++i) {
                    ParameterizedTestExtension.getParameterField(i, context).setAccessible(true);
                    ParameterizedTestExtension.getParameterField(i, context).set(context.getRequiredTestInstance(), this.parameterValues[i]);
                }
            }
        }
    }
}

