/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMetricsSerialization {
    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        Metrics original = TestMetricsSerialization.generateMetrics();
        byte[] serialized = TestMetricsSerialization.serialize(original);
        Metrics result = TestMetricsSerialization.deserialize(serialized);
        TestMetricsSerialization.assertEquals(original, result);
    }

    @Test
    public void testSerializationWithNulls() throws IOException, ClassNotFoundException {
        Metrics original = TestMetricsSerialization.generateMetricsWithNulls();
        byte[] serialized = TestMetricsSerialization.serialize(original);
        Metrics result = TestMetricsSerialization.deserialize(serialized);
        TestMetricsSerialization.assertEquals(original, result);
    }

    private static byte[] serialize(Metrics metrics) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(metrics);
            objectOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    private static Metrics deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Metrics metrics = (Metrics)objectInputStream.readObject();
            return metrics;
        }
    }

    private static Metrics generateMetrics() {
        HashMap longMap1 = Maps.newHashMap();
        longMap1.put(1, 2L);
        longMap1.put(3, 4L);
        HashMap longMap2 = Maps.newHashMap();
        longMap2.put(5, 6L);
        HashMap longMap3 = Maps.newHashMap();
        longMap3.put(7, 8L);
        HashMap byteMap1 = Maps.newHashMap();
        byteMap1.put(1, ByteBuffer.wrap(new byte[]{1, 2, 3}));
        byteMap1.put(2, ByteBuffer.wrap(new byte[]{1, 2, 3, 4}));
        HashMap byteMap2 = Maps.newHashMap();
        byteMap1.put(3, ByteBuffer.wrap(new byte[]{1, 2}));
        return new Metrics(Long.valueOf(0L), (Map)longMap1, (Map)longMap2, (Map)longMap3, null, (Map)byteMap1, (Map)byteMap2);
    }

    private static Metrics generateMetricsWithNulls() {
        HashMap longMap = Maps.newHashMap();
        longMap.put(null, 1L);
        longMap.put(2, null);
        HashMap byteMap = Maps.newHashMap();
        byteMap.put(null, ByteBuffer.wrap(new byte[]{1, 2, 3}));
        byteMap.put(4, null);
        return new Metrics(null, null, (Map)longMap, (Map)longMap, null, null, (Map)byteMap);
    }

    private static void assertEquals(Metrics expected, Metrics actual) {
        Assertions.assertThat((Long)actual.recordCount()).isEqualTo((Object)expected.recordCount());
        Assertions.assertThat((Map)actual.columnSizes()).isEqualTo((Object)expected.columnSizes());
        Assertions.assertThat((Map)actual.valueCounts()).isEqualTo((Object)expected.valueCounts());
        Assertions.assertThat((Map)actual.nullValueCounts()).isEqualTo((Object)expected.nullValueCounts());
        TestMetricsSerialization.assertEquals(expected.lowerBounds(), actual.lowerBounds());
        TestMetricsSerialization.assertEquals(expected.upperBounds(), actual.upperBounds());
    }

    private static void assertEquals(Map<Integer, ByteBuffer> expected, Map<Integer, ByteBuffer> actual) {
        if (expected == null) {
            Assertions.assertThat(actual).isNull();
        } else {
            Assertions.assertThat(actual).hasSameSizeAs(expected);
            expected.keySet().forEach(key -> Assertions.assertThat((Comparable)((ByteBuffer)actual.get(key))).isEqualTo(expected.get(key)));
        }
    }
}

