/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestSchema {
    private static final Schema TS_NANO_CASES = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"ts", (Type)Types.TimestampNanoType.withZone()), Types.NestedField.optional((int)3, (String)"arr", (Type)Types.ListType.ofRequired((int)4, (Type)Types.TimestampNanoType.withoutZone())), Types.NestedField.required((int)5, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)6, (String)"inner_ts", (Type)Types.TimestampNanoType.withZone()), Types.NestedField.required((int)7, (String)"data", (Type)Types.StringType.get())})), Types.NestedField.optional((int)8, (String)"struct_arr", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)9, (String)"ts", (Type)Types.TimestampNanoType.withoutZone())}))});
    private static final Schema INITIAL_DEFAULT_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((String)"has_default").withId(2).ofType((Type)Types.StringType.get()).withInitialDefault((Object)"--").withWriteDefault((Object)"--").build()});
    private static final Schema WRITE_DEFAULT_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((String)"has_default").withId(2).ofType((Type)Types.StringType.get()).withWriteDefault((Object)"--").build()});

    @ParameterizedTest
    @ValueSource(ints={1, 2})
    public void testUnsupportedTimestampNano(int formatVersion) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Schema.checkCompatibility((Schema)TS_NANO_CASES, (int)formatVersion)).isInstanceOf(IllegalStateException.class)).hasMessage("Invalid schema for v%s:\n- Invalid type for ts: timestamptz_ns is not supported until v3\n- Invalid type for arr.element: timestamp_ns is not supported until v3\n- Invalid type for struct.inner_ts: timestamptz_ns is not supported until v3\n- Invalid type for struct_arr.ts: timestamp_ns is not supported until v3", new Object[]{formatVersion});
    }

    @Test
    public void testSupportedTimestampNano() {
        Assertions.assertThatCode(() -> Schema.checkCompatibility((Schema)TS_NANO_CASES, (int)3)).doesNotThrowAnyException();
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2})
    public void testUnsupportedInitialDefault(int formatVersion) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Schema.checkCompatibility((Schema)INITIAL_DEFAULT_SCHEMA, (int)formatVersion)).isInstanceOf(IllegalStateException.class)).hasMessage("Invalid schema for v%s:\n- Invalid initial default for has_default: non-null default (--) is not supported until v3", new Object[]{formatVersion});
    }

    @Test
    public void testSupportedInitialDefault() {
        Assertions.assertThatCode(() -> Schema.checkCompatibility((Schema)INITIAL_DEFAULT_SCHEMA, (int)3)).doesNotThrowAnyException();
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 3})
    public void testSupportedWriteDefault(int formatVersion) {
        Assertions.assertThatCode(() -> Schema.checkCompatibility((Schema)WRITE_DEFAULT_SCHEMA, (int)formatVersion)).doesNotThrowAnyException();
    }
}

