/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSchemaCaseSensitivity {
    @Test
    public void testCaseInsensitiveFieldCollision() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"DATA", (Type)Types.StringType.get())});
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> schema.caseInsensitiveFindField("DATA")).withMessage("Cannot build lower case index: data and DATA collide");
    }

    @Test
    public void testCaseSensitiveFindField() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"DATA", (Type)Types.StringType.get())});
        Types.NestedField actual1 = schema.findField("data");
        Assertions.assertThat((Object)actual1).isEqualTo((Object)Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()));
        Types.NestedField actual2 = schema.findField("DATA");
        Assertions.assertThat((Object)actual2).isEqualTo((Object)Types.NestedField.required((int)3, (String)"DATA", (Type)Types.StringType.get()));
    }

    @Test
    public void testCaseInsensitiveField() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        Types.NestedField actual1 = schema.caseInsensitiveFindField("DATA");
        Assertions.assertThat((Object)actual1).isEqualTo((Object)Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()));
    }
}

