/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.SortOrderComparators;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SerializableFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSortOrderComparators {
    private static final TestHelpers.Row SINGLE_SORT_FILED_NULL_VALUE = TestHelpers.Row.of("id4", null);

    private static void assertComparesCorrectly(Schema schema, SortOrder sortOrder, StructLike less, StructLike greater, StructLike lessCopy, StructLike nullValue) {
        Comparator comparator = SortOrderComparators.forSchema((Schema)schema, (SortOrder)sortOrder);
        Assertions.assertThat(sortOrder.fields().stream().map(SortField::direction).distinct()).hasSize(1);
        SortDirection direction = ((SortField)sortOrder.fields().get(0)).direction();
        Assertions.assertThat((int)comparator.compare(less, less)).isEqualTo(0);
        Assertions.assertThat((int)comparator.compare(greater, greater)).isEqualTo(0);
        Assertions.assertThat((int)comparator.compare(less, lessCopy)).isEqualTo(0);
        if (direction == SortDirection.ASC) {
            Assertions.assertThat((int)comparator.compare(less, greater)).isEqualTo(-1);
            Assertions.assertThat((int)comparator.compare(greater, less)).isEqualTo(1);
            Assertions.assertThat((int)comparator.compare(nullValue, less)).isEqualTo(-1);
            Assertions.assertThat((int)comparator.compare(less, nullValue)).isEqualTo(1);
        } else {
            Assertions.assertThat((int)comparator.compare(less, greater)).isEqualTo(1);
            Assertions.assertThat((int)comparator.compare(greater, less)).isEqualTo(-1);
            Assertions.assertThat((int)comparator.compare(nullValue, greater)).isEqualTo(1);
            Assertions.assertThat((int)comparator.compare(less, nullValue)).isEqualTo(-1);
        }
    }

    private static Schema singleSortFildSchema(Type type) {
        return new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"field", (Type)type)});
    }

    private static SortOrder ascOrder(Schema schema) {
        return ((SortOrder.Builder)SortOrder.builderFor((Schema)schema).asc("field")).build();
    }

    private static SortOrder descOrder(Schema schema) {
        return ((SortOrder.Builder)SortOrder.builderFor((Schema)schema).desc("field", NullOrder.NULLS_LAST)).build();
    }

    private static void testIdentitySortField(Schema schema, TestHelpers.Row less, TestHelpers.Row greater, TestHelpers.Row lessCopy) {
        TestSortOrderComparators.assertComparesCorrectly(schema, TestSortOrderComparators.ascOrder(schema), less, greater, lessCopy, SINGLE_SORT_FILED_NULL_VALUE);
        TestSortOrderComparators.assertComparesCorrectly(schema, TestSortOrderComparators.descOrder(schema), less, greater, lessCopy, SINGLE_SORT_FILED_NULL_VALUE);
    }

    @Test
    public void testBoolean() {
        TestSortOrderComparators.testIdentitySortField(TestSortOrderComparators.singleSortFildSchema((Type)Types.BooleanType.get()), TestHelpers.Row.of("id3", Boolean.FALSE), TestHelpers.Row.of("id2", Boolean.TRUE), TestHelpers.Row.of("id1", Boolean.FALSE));
    }

    @Test
    public void testInt() {
        TestSortOrderComparators.testIdentitySortField(TestSortOrderComparators.singleSortFildSchema((Type)Types.IntegerType.get()), TestHelpers.Row.of("id3", 111), TestHelpers.Row.of("id2", 222), TestHelpers.Row.of("id1", 111));
    }

    @Test
    public void testLong() {
        TestSortOrderComparators.testIdentitySortField(TestSortOrderComparators.singleSortFildSchema((Type)Types.LongType.get()), TestHelpers.Row.of("id3", 111L), TestHelpers.Row.of("id2", 222L), TestHelpers.Row.of("id1", 111L));
    }

    @Test
    public void testFloat() {
        TestSortOrderComparators.testIdentitySortField(TestSortOrderComparators.singleSortFildSchema((Type)Types.FloatType.get()), TestHelpers.Row.of("id3", Float.valueOf(1.11f)), TestHelpers.Row.of("id1", Float.valueOf(2.22f)), TestHelpers.Row.of("id1", Float.valueOf(1.11f)));
    }

    @Test
    public void testDouble() {
        TestSortOrderComparators.testIdentitySortField(TestSortOrderComparators.singleSortFildSchema((Type)Types.DoubleType.get()), TestHelpers.Row.of("id3", 1.11), TestHelpers.Row.of("id2", 2.22), TestHelpers.Row.of("id1", 1.11));
    }

    @Test
    public void testDate() {
        TestSortOrderComparators.testIdentitySortField(TestSortOrderComparators.singleSortFildSchema((Type)Types.DateType.get()), TestHelpers.Row.of("id3", 111), TestHelpers.Row.of("id2", 222), TestHelpers.Row.of("id1", 111));
    }

    @Test
    public void testTime() {
        TestSortOrderComparators.testIdentitySortField(TestSortOrderComparators.singleSortFildSchema((Type)Types.TimeType.get()), TestHelpers.Row.of("id3", 111L), TestHelpers.Row.of("id2", 222L), TestHelpers.Row.of("id1", 111L));
    }

    @Test
    public void testTimestamp() {
        Schema schemaWithZone = TestSortOrderComparators.singleSortFildSchema((Type)Types.TimestampType.withZone());
        Schema schemaWithoutZone = TestSortOrderComparators.singleSortFildSchema((Type)Types.TimestampType.withoutZone());
        long lessMicro = TimeUnit.SECONDS.toMicros(LocalDateTime.of(2022, 1, 10, 0, 0, 0).toEpochSecond(ZoneOffset.UTC));
        long greaterMicro = TimeUnit.SECONDS.toMicros(LocalDateTime.of(2022, 1, 10, 1, 0, 0).toEpochSecond(ZoneOffset.UTC));
        long lessCopyMicro = TimeUnit.SECONDS.toMicros(LocalDateTime.of(2022, 1, 10, 0, 0, 0).toEpochSecond(ZoneOffset.UTC));
        TestHelpers.Row less = TestHelpers.Row.of("id3", lessMicro);
        TestHelpers.Row greater = TestHelpers.Row.of("id2", greaterMicro);
        TestHelpers.Row lessCopy = TestHelpers.Row.of("id1", lessCopyMicro);
        TestSortOrderComparators.testIdentitySortField(schemaWithZone, less, greater, lessCopy);
        TestSortOrderComparators.testIdentitySortField(schemaWithoutZone, less, greater, lessCopy);
    }

    @Test
    public void testTimestampTransform() {
        Schema schema = TestSortOrderComparators.singleSortFildSchema((Type)Types.TimestampType.withZone());
        Transform bucket = Transforms.day();
        SerializableFunction transform = bucket.bind((Type)Types.TimestampType.withZone());
        long lessMicro = TimeUnit.SECONDS.toMicros(LocalDateTime.of(2022, 1, 10, 0, 0, 0).toEpochSecond(ZoneOffset.UTC));
        long greaterMicro = TimeUnit.SECONDS.toMicros(LocalDateTime.of(2022, 1, 11, 0, 0, 0).toEpochSecond(ZoneOffset.UTC));
        long lessCopyMicro = TimeUnit.SECONDS.toMicros(LocalDateTime.of(2022, 1, 10, 1, 0, 0).toEpochSecond(ZoneOffset.UTC));
        Assertions.assertThat((Integer)((Integer)transform.apply((Object)lessMicro))).isLessThan((Comparable)((Integer)transform.apply((Object)greaterMicro)));
        Assertions.assertThat((Integer)((Integer)transform.apply((Object)lessMicro))).isEqualTo(transform.apply((Object)lessCopyMicro));
        TestHelpers.Row less = TestHelpers.Row.of("id3", lessMicro);
        TestHelpers.Row greater = TestHelpers.Row.of("id2", greaterMicro);
        TestHelpers.Row lessCopy = TestHelpers.Row.of("id1", lessCopyMicro);
        SortOrder sortOrder = SortOrder.builderFor((Schema)schema).sortBy((Term)Expressions.day((String)"field"), SortDirection.ASC, NullOrder.NULLS_FIRST).build();
        TestSortOrderComparators.assertComparesCorrectly(schema, sortOrder, less, greater, lessCopy, SINGLE_SORT_FILED_NULL_VALUE);
    }

    @Test
    public void testString() {
        TestSortOrderComparators.testIdentitySortField(TestSortOrderComparators.singleSortFildSchema((Type)Types.StringType.get()), TestHelpers.Row.of("id3", "aaa"), TestHelpers.Row.of("id2", "bbb"), TestHelpers.Row.of("id1", "aaa"));
    }

    @Test
    public void testStringBucket() {
        Schema schema = TestSortOrderComparators.singleSortFildSchema((Type)Types.StringType.get());
        Transform bucket = Transforms.bucket((int)4);
        SerializableFunction transform = bucket.bind((Type)Types.StringType.get());
        Assertions.assertThat((Integer)((Integer)transform.apply((Object)"bbb"))).isLessThan((Comparable)((Integer)transform.apply((Object)"aaa")));
        Assertions.assertThat((Integer)((Integer)transform.apply((Object)"bbb"))).isEqualTo(transform.apply((Object)"cca"));
        TestHelpers.Row less = TestHelpers.Row.of("id3", "bbb");
        TestHelpers.Row greater = TestHelpers.Row.of("id2", "aaa");
        TestHelpers.Row lessCopy = TestHelpers.Row.of("id1", "cca");
        SortOrder sortOrder = SortOrder.builderFor((Schema)schema).sortBy((Term)Expressions.bucket((String)"field", (int)4), SortDirection.ASC, NullOrder.NULLS_FIRST).build();
        TestSortOrderComparators.assertComparesCorrectly(schema, sortOrder, less, greater, lessCopy, SINGLE_SORT_FILED_NULL_VALUE);
    }

    @Test
    public void testUuid() {
        Schema schema = TestSortOrderComparators.singleSortFildSchema((Type)Types.UUIDType.get());
        TestHelpers.Row less = TestHelpers.Row.of("id3", UUID.fromString("81873e7d-1374-4493-8e1d-9095eff7046c"));
        TestHelpers.Row greater = TestHelpers.Row.of("id2", UUID.fromString("fd02441d-1423-4a3f-8785-c7dd5647e26b"));
        TestHelpers.Row lessCopy = TestHelpers.Row.of("id1", UUID.fromString("81873e7d-1374-4493-8e1d-9095eff7046c"));
        TestSortOrderComparators.testIdentitySortField(schema, less, greater, lessCopy);
    }

    @Test
    public void testUUIDBucket() {
        Schema schema = TestSortOrderComparators.singleSortFildSchema((Type)Types.UUIDType.get());
        Transform bucket = Transforms.bucket((int)4);
        SerializableFunction transform = bucket.bind((Type)Types.UUIDType.get());
        Assertions.assertThat((Integer)((Integer)transform.apply((Object)UUID.fromString("fd02441d-1423-4a3f-8785-c7dd5647e26b")))).isLessThan((Comparable)((Integer)transform.apply((Object)UUID.fromString("86873e7d-1374-4493-8e1d-9095eff7046c"))));
        Assertions.assertThat((Integer)((Integer)transform.apply((Object)UUID.fromString("fd02441d-1423-4a3f-8785-c7dd5647e26b")))).isEqualTo(transform.apply((Object)UUID.fromString("81873e7d-1374-4493-8e1d-9095eff7046c")));
        TestHelpers.Row less = TestHelpers.Row.of("id3", UUID.fromString("fd02441d-1423-4a3f-8785-c7dd5647e26b"));
        TestHelpers.Row greater = TestHelpers.Row.of("id2", UUID.fromString("86873e7d-1374-4493-8e1d-9095eff7046c"));
        TestHelpers.Row lessCopy = TestHelpers.Row.of("id1", UUID.fromString("81873e7d-1374-4493-8e1d-9095eff7046c"));
        SortOrder sortOrder = SortOrder.builderFor((Schema)schema).sortBy((Term)Expressions.bucket((String)"field", (int)4), SortDirection.ASC, NullOrder.NULLS_FIRST).build();
        TestSortOrderComparators.assertComparesCorrectly(schema, sortOrder, less, greater, lessCopy, SINGLE_SORT_FILED_NULL_VALUE);
    }

    @Test
    public void testFixed() {
        TestSortOrderComparators.testIdentitySortField(TestSortOrderComparators.singleSortFildSchema((Type)Types.FixedType.ofLength((int)3)), TestHelpers.Row.of("id3", ByteBuffer.wrap(new byte[]{1, 2, 3})), TestHelpers.Row.of("id2", ByteBuffer.wrap(new byte[]{3, 2, 1})), TestHelpers.Row.of("id1", ByteBuffer.wrap(new byte[]{1, 2, 3})));
    }

    @Test
    public void testBinary() {
        TestSortOrderComparators.testIdentitySortField(TestSortOrderComparators.singleSortFildSchema((Type)Types.BinaryType.get()), TestHelpers.Row.of("id3", ByteBuffer.wrap(new byte[]{1, 1})), TestHelpers.Row.of("id2", ByteBuffer.wrap(new byte[]{1, 1, 1})), TestHelpers.Row.of("id1", ByteBuffer.wrap(new byte[]{1, 1})));
    }

    @Test
    public void testBinaryTruncate() {
        Schema schema = TestSortOrderComparators.singleSortFildSchema((Type)Types.BinaryType.get());
        Transform truncate = Transforms.truncate((int)2);
        SerializableFunction transform = truncate.bind((Type)Types.BinaryType.get());
        Assertions.assertThat((Comparable)((ByteBuffer)transform.apply((Object)ByteBuffer.wrap(new byte[]{1, 2, 3})))).isLessThan((Comparable)((ByteBuffer)transform.apply((Object)ByteBuffer.wrap(new byte[]{1, 3, 1}))));
        Assertions.assertThat((Comparable)((ByteBuffer)transform.apply((Object)ByteBuffer.wrap(new byte[]{1, 2, 3})))).isEqualTo(transform.apply((Object)ByteBuffer.wrap(new byte[]{1, 2, 5, 6})));
        TestHelpers.Row less = TestHelpers.Row.of("id3", ByteBuffer.wrap(new byte[]{1, 2, 3}));
        TestHelpers.Row greater = TestHelpers.Row.of("id2", ByteBuffer.wrap(new byte[]{1, 3, 1}));
        TestHelpers.Row lessCopy = TestHelpers.Row.of("id1", ByteBuffer.wrap(new byte[]{1, 2, 5, 6}));
        SortOrder sortOrder = SortOrder.builderFor((Schema)schema).sortBy((Term)Expressions.truncate((String)"field", (int)2), SortDirection.ASC, NullOrder.NULLS_FIRST).build();
        TestSortOrderComparators.assertComparesCorrectly(schema, sortOrder, less, greater, lessCopy, SINGLE_SORT_FILED_NULL_VALUE);
    }

    @Test
    public void testDecimal() {
        TestSortOrderComparators.testIdentitySortField(TestSortOrderComparators.singleSortFildSchema((Type)Types.DecimalType.of((int)9, (int)5)), TestHelpers.Row.of("id3", BigDecimal.valueOf(0.1)), TestHelpers.Row.of("id2", BigDecimal.valueOf(0.2)), TestHelpers.Row.of("id1", BigDecimal.valueOf(0.1)));
    }

    @Test
    public void testStruct() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)11, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)12, (String)"long", (Type)Types.FloatType.get())}))});
        SortOrder latOnlyAsc = ((SortOrder.Builder)SortOrder.builderFor((Schema)schema).asc("location.lat")).build();
        TestHelpers.Row lessLat = TestHelpers.Row.of("id4", TestHelpers.Row.of(Float.valueOf(1.0f), Float.valueOf(1.0f)));
        TestHelpers.Row greaterLat = TestHelpers.Row.of("id3", TestHelpers.Row.of(Float.valueOf(2.0f), Float.valueOf(1.0f)));
        TestHelpers.Row lessLatCopy = TestHelpers.Row.of("id2", TestHelpers.Row.of(Float.valueOf(1.0f), Float.valueOf(1.0f)));
        TestHelpers.Row nullLat = TestHelpers.Row.of("id1", TestHelpers.Row.of(null, Float.valueOf(1.0f)));
        TestSortOrderComparators.assertComparesCorrectly(schema, latOnlyAsc, lessLat, greaterLat, lessLatCopy, nullLat);
        SortOrder longOnlyDesc = ((SortOrder.Builder)SortOrder.builderFor((Schema)schema).desc("location.long", NullOrder.NULLS_LAST)).build();
        TestHelpers.Row lessLong = TestHelpers.Row.of("id4", TestHelpers.Row.of(Float.valueOf(1.0f), Float.valueOf(1.0f)));
        TestHelpers.Row greaterLong = TestHelpers.Row.of("id3", TestHelpers.Row.of(Float.valueOf(1.0f), Float.valueOf(2.0f)));
        TestHelpers.Row lessLongCopy = TestHelpers.Row.of("id2", TestHelpers.Row.of(Float.valueOf(1.0f), Float.valueOf(1.0f)));
        TestHelpers.Row nullLong = TestHelpers.Row.of("id1", TestHelpers.Row.of(Float.valueOf(1.0f), null));
        TestSortOrderComparators.assertComparesCorrectly(schema, longOnlyDesc, lessLong, greaterLong, lessLongCopy, nullLong);
        SortOrder twoFieldsSortOrder = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)schema).asc("location.lat")).asc("location.long")).build();
        TestHelpers.Row lessTwoSortFields = TestHelpers.Row.of("id4", TestHelpers.Row.of(Float.valueOf(1.0f), Float.valueOf(1.0f)));
        TestHelpers.Row greaterLatTwoSortFields = TestHelpers.Row.of("id3", TestHelpers.Row.of(Float.valueOf(2.0f), Float.valueOf(1.0f)));
        TestHelpers.Row greaterLongTwoSortFields = TestHelpers.Row.of("id3", TestHelpers.Row.of(Float.valueOf(1.0f), Float.valueOf(2.0f)));
        TestHelpers.Row greaterBothTwoSortFields = TestHelpers.Row.of("id3", TestHelpers.Row.of(Float.valueOf(2.0f), Float.valueOf(2.0f)));
        TestHelpers.Row lessTwoSortFieldsCopy = TestHelpers.Row.of("id2", TestHelpers.Row.of(Float.valueOf(1.0f), Float.valueOf(1.0f)));
        TestHelpers.Row nullLatTwoSortFields = TestHelpers.Row.of("id1", TestHelpers.Row.of(null, Float.valueOf(1.0f)));
        TestHelpers.Row nullLongTwoSortFields = TestHelpers.Row.of("id1", TestHelpers.Row.of(Float.valueOf(1.0f), null));
        TestHelpers.Row nullBothTowSortFields = TestHelpers.Row.of("id1", TestHelpers.Row.of(null, null));
        TestSortOrderComparators.assertComparesCorrectly(schema, twoFieldsSortOrder, lessTwoSortFields, greaterLatTwoSortFields, lessTwoSortFieldsCopy, nullLatTwoSortFields);
        TestSortOrderComparators.assertComparesCorrectly(schema, twoFieldsSortOrder, lessTwoSortFields, greaterLongTwoSortFields, lessTwoSortFieldsCopy, nullLongTwoSortFields);
        TestSortOrderComparators.assertComparesCorrectly(schema, twoFieldsSortOrder, lessTwoSortFields, greaterBothTwoSortFields, lessTwoSortFieldsCopy, nullBothTowSortFields);
    }

    @Test
    public void testStructTransform() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)11, (String)"left", (Type)Types.BinaryType.get()), Types.NestedField.required((int)12, (String)"right", (Type)Types.BinaryType.get())}))});
        Transform bucket = Transforms.truncate((int)2);
        SerializableFunction transform = bucket.bind((Type)Types.BinaryType.get());
        Assertions.assertThat((Comparable)((ByteBuffer)transform.apply((Object)ByteBuffer.wrap(new byte[]{2, 3, 4})))).isLessThan((Comparable)((ByteBuffer)transform.apply((Object)ByteBuffer.wrap(new byte[]{9, 3, 4}))));
        Assertions.assertThat((Comparable)((ByteBuffer)transform.apply((Object)ByteBuffer.wrap(new byte[]{2, 3, 4})))).isEqualTo(transform.apply((Object)ByteBuffer.wrap(new byte[]{2, 3, 9})));
        TestHelpers.Row less = TestHelpers.Row.of("id4", TestHelpers.Row.of(ByteBuffer.wrap(new byte[]{1}), ByteBuffer.wrap(new byte[]{2, 3, 4})));
        TestHelpers.Row greater = TestHelpers.Row.of("id3", TestHelpers.Row.of(ByteBuffer.wrap(new byte[]{1}), ByteBuffer.wrap(new byte[]{9, 3, 4})));
        TestHelpers.Row lessCopy = TestHelpers.Row.of("id2", TestHelpers.Row.of(ByteBuffer.wrap(new byte[]{1}), ByteBuffer.wrap(new byte[]{2, 3, 9})));
        TestHelpers.Row nullRight = TestHelpers.Row.of("id1", TestHelpers.Row.of(ByteBuffer.wrap(new byte[]{1}), null));
        SortOrder sortOrder = SortOrder.builderFor((Schema)schema).sortBy((Term)Expressions.truncate((String)"struct.left", (int)2), SortDirection.ASC, NullOrder.NULLS_FIRST).sortBy((Term)Expressions.truncate((String)"struct.right", (int)2), SortDirection.ASC, NullOrder.NULLS_FIRST).build();
        TestSortOrderComparators.assertComparesCorrectly(schema, sortOrder, less, greater, lessCopy, nullRight);
    }

    @Test
    public void testNestedStruct() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"user", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)11, (String)"name", (Type)Types.StringType.get()), Types.NestedField.optional((int)12, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)101, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)102, (String)"long", (Type)Types.FloatType.get())}))}))});
        SortOrder build = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)schema).asc("user.location.lat")).asc("user.location.long")).build();
        TestHelpers.Row less = TestHelpers.Row.of("id4", TestHelpers.Row.of("user4", TestHelpers.Row.of(Float.valueOf(1.0f), Float.valueOf(1.0f))));
        TestHelpers.Row greaterLat = TestHelpers.Row.of("id3", TestHelpers.Row.of("user3", TestHelpers.Row.of(Float.valueOf(2.0f), Float.valueOf(1.0f))));
        TestHelpers.Row greaterLong = TestHelpers.Row.of("id3", TestHelpers.Row.of("user3", TestHelpers.Row.of(Float.valueOf(1.0f), Float.valueOf(2.0f))));
        TestHelpers.Row greaterBoth = TestHelpers.Row.of("id3", TestHelpers.Row.of("user3", TestHelpers.Row.of(Float.valueOf(2.0f), Float.valueOf(2.0f))));
        TestHelpers.Row lessCopy = TestHelpers.Row.of("id2", TestHelpers.Row.of("user2", TestHelpers.Row.of(Float.valueOf(1.0f), Float.valueOf(1.0f))));
        TestHelpers.Row nullLat = TestHelpers.Row.of("id1", TestHelpers.Row.of("user1", TestHelpers.Row.of(null, Float.valueOf(1.0f))));
        TestHelpers.Row nullLong = TestHelpers.Row.of("id1", TestHelpers.Row.of("user1", TestHelpers.Row.of(Float.valueOf(1.0f), null)));
        TestHelpers.Row nullBoth = TestHelpers.Row.of("id1", TestHelpers.Row.of("user1", TestHelpers.Row.of(null, null)));
        TestSortOrderComparators.assertComparesCorrectly(schema, build, less, greaterLat, lessCopy, nullLat);
        TestSortOrderComparators.assertComparesCorrectly(schema, build, less, greaterLong, lessCopy, nullLong);
        TestSortOrderComparators.assertComparesCorrectly(schema, build, less, greaterBoth, lessCopy, nullBoth);
    }
}

