/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.util.Collection;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.expressions.And;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.BoundTransform;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.NamedReference;
import org.apache.iceberg.expressions.Not;
import org.apache.iceberg.expressions.Or;
import org.apache.iceberg.expressions.Predicate;
import org.apache.iceberg.expressions.Reference;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTransform;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExpressionSerialization {
    @Test
    public void testExpressions() throws Exception {
        Expression[] expressions;
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)34, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)35, (String)"s", (Type)Types.StringType.get())});
        for (Expression expression : expressions = new Expression[]{Expressions.alwaysFalse(), Expressions.alwaysTrue(), Expressions.lessThan((String)"x", (Object)5), Expressions.lessThanOrEqual((String)"y", (Object)-3), Expressions.greaterThan((String)"z", (Object)0), Expressions.greaterThanOrEqual((String)"t", (Object)129), Expressions.equal((String)"col", (Object)"data"), Expressions.in((String)"col", (Object[])new String[]{"a", "b"}), Expressions.notIn((String)"col", (Object[])new Integer[]{1, 2, 3}), Expressions.notEqual((String)"col", (Object)"abc"), Expressions.notNull((String)"maybeNull"), Expressions.isNull((String)"maybeNull2"), Expressions.isNaN((String)"maybeNaN"), Expressions.notNaN((String)"maybeNaN2"), Expressions.startsWith((String)"col", (String)"abc"), Expressions.notStartsWith((String)"col", (String)"abc"), Expressions.not((Expression)Expressions.greaterThan((String)"a", (Object)10)), Expressions.and((Expression)Expressions.greaterThanOrEqual((String)"a", (Object)0), (Expression)Expressions.lessThan((String)"a", (Object)3)), Expressions.or((Expression)Expressions.lessThan((String)"a", (Object)0), (Expression)Expressions.greaterThan((String)"a", (Object)10)), Expressions.equal((String)"a", (Object)5).bind(schema.asStruct()), Expressions.in((String)"a", (Object[])new Integer[]{5, 6, 7}).bind(schema.asStruct()), Expressions.notIn((String)"s", (Object[])new String[]{"abc", "xyz"}).bind(schema.asStruct()), Expressions.isNull((String)"a").bind(schema.asStruct()), Expressions.startsWith((String)"s", (String)"abc").bind(schema.asStruct()), Expressions.notStartsWith((String)"s", (String)"xyz").bind(schema.asStruct())}) {
            Expression copy = TestHelpers.roundTripSerialize(expression);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestExpressionSerialization.equals(expression, copy)).as("Expression should equal the deserialized copy: " + expression + " != " + copy, new Object[0])).isTrue();
        }
    }

    private static boolean equals(Expression left, Expression right) {
        if (left.op() != right.op()) {
            return false;
        }
        if (left instanceof Predicate) {
            if (!left.getClass().isInstance(right)) {
                return false;
            }
            return TestExpressionSerialization.equals((Predicate)left, (Predicate)right);
        }
        switch (left.op()) {
            case FALSE: 
            case TRUE: {
                return true;
            }
            case NOT: {
                return TestExpressionSerialization.equals(((Not)left).child(), ((Not)right).child());
            }
            case AND: {
                return TestExpressionSerialization.equals(((And)left).left(), ((And)right).left()) && TestExpressionSerialization.equals(((And)left).right(), ((And)right).right());
            }
            case OR: {
                return TestExpressionSerialization.equals(((Or)left).left(), ((Or)right).left()) && TestExpressionSerialization.equals(((Or)left).right(), ((Or)right).right());
            }
        }
        return false;
    }

    private static boolean equals(Term left, Term right) {
        if (left instanceof Reference && right instanceof Reference) {
            return TestExpressionSerialization.equals((Reference)left, (Reference)right);
        }
        if (left instanceof UnboundTransform && right instanceof UnboundTransform) {
            UnboundTransform unboundLeft = (UnboundTransform)left;
            UnboundTransform unboundRight = (UnboundTransform)right;
            return TestExpressionSerialization.equals(unboundLeft.ref(), unboundRight.ref()) && unboundLeft.transform().toString().equals(unboundRight.transform().toString());
        }
        if (left instanceof BoundTransform && right instanceof BoundTransform) {
            BoundTransform boundLeft = (BoundTransform)left;
            BoundTransform boundRight = (BoundTransform)right;
            return TestExpressionSerialization.equals(boundLeft.ref(), boundRight.ref()) && boundLeft.transform().toString().equals(boundRight.transform().toString());
        }
        return false;
    }

    private static boolean equals(Predicate left, Predicate right) {
        if (left.op() != right.op()) {
            return false;
        }
        if (!TestExpressionSerialization.equals(left.term(), right.term())) {
            return false;
        }
        if (left.op() == Expression.Operation.IS_NULL || left.op() == Expression.Operation.NOT_NULL || left.op() == Expression.Operation.IS_NAN || left.op() == Expression.Operation.NOT_NAN) {
            return true;
        }
        if (left.getClass() != right.getClass()) {
            return false;
        }
        if (left instanceof UnboundPredicate) {
            UnboundPredicate lpred = (UnboundPredicate)left;
            UnboundPredicate rpred = (UnboundPredicate)right;
            if (left.op() == Expression.Operation.IN || left.op() == Expression.Operation.NOT_IN) {
                return TestExpressionSerialization.equals(lpred.literals(), rpred.literals());
            }
            return lpred.literal().comparator().compare(lpred.literal().value(), rpred.literal().value()) == 0;
        }
        if (left instanceof BoundPredicate) {
            BoundPredicate lpred = (BoundPredicate)left;
            BoundPredicate rpred = (BoundPredicate)right;
            if (lpred.isLiteralPredicate() && rpred.isLiteralPredicate()) {
                return lpred.asLiteralPredicate().literal().comparator().compare(lpred.asLiteralPredicate().literal().value(), rpred.asLiteralPredicate().literal().value()) == 0;
            }
            if (lpred.isSetPredicate() && rpred.isSetPredicate()) {
                return TestExpressionSerialization.equals(lpred.asSetPredicate().literalSet(), rpred.asSetPredicate().literalSet());
            }
            return lpred.isUnaryPredicate() && rpred.isUnaryPredicate();
        }
        throw new UnsupportedOperationException(String.format("Predicate equality check for %s is not supported", left.getClass()));
    }

    private static boolean equals(Collection<Literal<?>> left, Collection<Literal<?>> right) {
        if (left.size() != right.size()) {
            return false;
        }
        return left.containsAll(right);
    }

    private static boolean equals(Reference<?> left, Reference<?> right) {
        if (left instanceof NamedReference) {
            if (!(right instanceof NamedReference)) {
                return false;
            }
            NamedReference lref = (NamedReference)left;
            NamedReference rref = (NamedReference)right;
            return lref.name().equals(rref.name());
        }
        if (left instanceof BoundReference) {
            if (!(right instanceof BoundReference)) {
                return false;
            }
            BoundReference lref = (BoundReference)left;
            BoundReference rref = (BoundReference)right;
            return lref.fieldId() == rref.fieldId() && lref.type().equals(rref.type());
        }
        return false;
    }
}

