/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.time.format.DateTimeParseException;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTimestampLiteralConversions {
    @Test
    public void testTimestampToTimestampNanoConversion() {
        Literal timestamp = Literal.of((CharSequence)"2017-11-16T14:31:08.000000001").to((Type)Types.TimestampType.withoutZone());
        Assertions.assertThat((Long)((Long)timestamp.value())).isEqualTo(1510842668000000L);
        Literal timestampNano = timestamp.to((Type)Types.TimestampNanoType.withoutZone());
        Assertions.assertThat((Long)((Long)timestampNano.value())).isEqualTo(1510842668000000000L);
        timestamp = Literal.of((CharSequence)"1970-01-01T00:00:00.000000001").to((Type)Types.TimestampType.withoutZone());
        Assertions.assertThat((Long)((Long)timestamp.value())).isEqualTo(0L);
        timestampNano = timestamp.to((Type)Types.TimestampNanoType.withoutZone());
        Assertions.assertThat((Long)((Long)timestampNano.value())).isEqualTo(0L);
        timestamp = Literal.of((CharSequence)"1969-12-31T23:59:59.999999999").to((Type)Types.TimestampType.withoutZone());
        Assertions.assertThat((Long)((Long)timestamp.value())).isEqualTo(0L);
        timestampNano = timestamp.to((Type)Types.TimestampNanoType.withoutZone());
        Assertions.assertThat((Long)((Long)timestampNano.value())).isEqualTo(0L);
        timestamp = Literal.of((CharSequence)"1969-12-31T23:59:59.999999000").to((Type)Types.TimestampType.withoutZone());
        Assertions.assertThat((Long)((Long)timestamp.value())).isEqualTo(-1L);
        timestampNano = timestamp.to((Type)Types.TimestampNanoType.withoutZone());
        Assertions.assertThat((Long)((Long)timestampNano.value())).isEqualTo(-1000L);
    }

    @Test
    public void testTimestampToDateConversion() {
        Literal ts = Literal.of((CharSequence)"2017-11-16T14:31:08.000001").to((Type)Types.TimestampType.withoutZone());
        int dateOrdinal = (Integer)ts.to((Type)Types.DateType.get()).value();
        Assertions.assertThat((int)dateOrdinal).isEqualTo(DateTimeUtil.isoDateToDays((String)"2017-11-16"));
        ts = Literal.of((CharSequence)"1970-01-01T00:00:00.000001").to((Type)Types.TimestampType.withoutZone());
        dateOrdinal = (Integer)ts.to((Type)Types.DateType.get()).value();
        Assertions.assertThat((int)dateOrdinal).isEqualTo(0);
        ts = Literal.of((CharSequence)"1969-12-31T23:59:59.999999").to((Type)Types.TimestampType.withoutZone());
        dateOrdinal = (Integer)ts.to((Type)Types.DateType.get()).value();
        Assertions.assertThat((int)dateOrdinal).isEqualTo(-1);
        ts = Literal.of((CharSequence)"2017-11-16T14:31:08.000000001").to((Type)Types.TimestampType.withoutZone());
        dateOrdinal = (Integer)ts.to((Type)Types.DateType.get()).value();
        Assertions.assertThat((int)dateOrdinal).isEqualTo(DateTimeUtil.isoDateToDays((String)"2017-11-16"));
        ts = Literal.of((CharSequence)"1970-01-01T00:00:00.000000001").to((Type)Types.TimestampType.withoutZone());
        dateOrdinal = (Integer)ts.to((Type)Types.DateType.get()).value();
        Assertions.assertThat((int)dateOrdinal).isEqualTo(0).isEqualTo(DateTimeUtil.isoDateToDays((String)"1970-01-01"));
        ts = Literal.of((CharSequence)"1969-12-31T23:59:59.999999999").to((Type)Types.TimestampType.withoutZone());
        dateOrdinal = (Integer)ts.to((Type)Types.DateType.get()).value();
        Assertions.assertThat((int)dateOrdinal).isEqualTo(0).isEqualTo(DateTimeUtil.isoDateToDays((String)"1970-01-01"));
        ts = Literal.of((CharSequence)"1969-12-31T23:59:59.999999000").to((Type)Types.TimestampType.withoutZone());
        dateOrdinal = (Integer)ts.to((Type)Types.DateType.get()).value();
        Assertions.assertThat((int)dateOrdinal).isEqualTo(-1).isEqualTo(DateTimeUtil.isoDateToDays((String)"1969-12-31"));
    }

    @Test
    public void testTimestampMicrosToDateConversion() {
        Literal ts = Literal.of((CharSequence)"2017-11-16T14:31:08.000000001").to((Type)Types.TimestampType.withoutZone());
        int dateOrdinal = (Integer)ts.to((Type)Types.DateType.get()).value();
        Assertions.assertThat((int)dateOrdinal).isEqualTo(DateTimeUtil.isoDateToDays((String)"2017-11-16"));
        ts = Literal.of((CharSequence)"1970-01-01T00:00:00.000000001").to((Type)Types.TimestampType.withoutZone());
        dateOrdinal = (Integer)ts.to((Type)Types.DateType.get()).value();
        Assertions.assertThat((int)dateOrdinal).isEqualTo(0);
        ts = Literal.of((CharSequence)"1969-12-31T23:59:59.999999999").to((Type)Types.TimestampType.withoutZone());
        dateOrdinal = (Integer)ts.to((Type)Types.DateType.get()).value();
        Assertions.assertThat((int)dateOrdinal).isEqualTo(0);
        ts = Literal.of((CharSequence)"1969-12-31T23:59:59.999999000").to((Type)Types.TimestampType.withoutZone());
        dateOrdinal = (Integer)ts.to((Type)Types.DateType.get()).value();
        Assertions.assertThat((int)dateOrdinal).isEqualTo(-1);
    }

    @Test
    public void testTimestampNanoToTimestampConversion() {
        Literal timestamp = Literal.of((CharSequence)"2017-11-16T14:31:08.000000001").to((Type)Types.TimestampNanoType.withoutZone());
        Assertions.assertThat((Long)((Long)timestamp.value())).isEqualTo(1510842668000000001L);
        Literal timestampNano = timestamp.to((Type)Types.TimestampType.withoutZone());
        Assertions.assertThat((Long)((Long)timestampNano.value())).isEqualTo(1510842668000000L);
        timestamp = Literal.of((CharSequence)"1970-01-01T00:00:00.000000001").to((Type)Types.TimestampNanoType.withoutZone());
        Assertions.assertThat((Long)((Long)timestamp.value())).isEqualTo(1L);
        timestampNano = timestamp.to((Type)Types.TimestampType.withoutZone());
        Assertions.assertThat((Long)((Long)timestampNano.value())).isEqualTo(0L);
        timestamp = Literal.of((CharSequence)"1969-12-31T23:59:59.999999999").to((Type)Types.TimestampNanoType.withoutZone());
        Assertions.assertThat((Long)((Long)timestamp.value())).isEqualTo(-1L);
        timestampNano = timestamp.to((Type)Types.TimestampType.withoutZone());
        Assertions.assertThat((Long)((Long)timestampNano.value())).isEqualTo(-1L);
        timestamp = Literal.of((CharSequence)"1969-12-31T23:59:59.999999000").to((Type)Types.TimestampNanoType.withoutZone());
        Assertions.assertThat((Long)((Long)timestamp.value())).isEqualTo(-1000L);
        timestampNano = timestamp.to((Type)Types.TimestampType.withoutZone());
        Assertions.assertThat((Long)((Long)timestampNano.value())).isEqualTo(-1L);
    }

    @Test
    public void testTimestampNanosToDateConversion() {
        Literal ts = Literal.of((CharSequence)"2017-11-16T14:31:08.000000001").to((Type)Types.TimestampNanoType.withoutZone());
        int dateOrdinal = (Integer)ts.to((Type)Types.DateType.get()).value();
        Assertions.assertThat((int)dateOrdinal).isEqualTo(DateTimeUtil.isoDateToDays((String)"2017-11-16"));
        ts = Literal.of((CharSequence)"1970-01-01T00:00:00.000000001").to((Type)Types.TimestampNanoType.withoutZone());
        dateOrdinal = (Integer)ts.to((Type)Types.DateType.get()).value();
        Assertions.assertThat((int)dateOrdinal).isEqualTo(0);
        ts = Literal.of((CharSequence)"1969-12-31T23:59:59.999999999").to((Type)Types.TimestampNanoType.withoutZone());
        dateOrdinal = (Integer)ts.to((Type)Types.DateType.get()).value();
        Assertions.assertThat((int)dateOrdinal).isEqualTo(-1);
        ts = Literal.of((CharSequence)"1969-12-31T23:59:59.999999000").to((Type)Types.TimestampNanoType.withoutZone());
        dateOrdinal = (Integer)ts.to((Type)Types.DateType.get()).value();
        Assertions.assertThat((int)dateOrdinal).isEqualTo(-1);
    }

    @Test
    public void testTimestampNanosWithZoneConversion() {
        Literal isoTimestampNanosWithZoneOffset = Literal.of((CharSequence)"2017-11-16T14:31:08.000000001+00:00");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> isoTimestampNanosWithZoneOffset.to((Type)Types.TimestampType.withoutZone())).as("Should not convert timestamp with offset to a timestamp without zone", new Object[0])).isInstanceOf(DateTimeParseException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> isoTimestampNanosWithZoneOffset.to((Type)Types.TimestampNanoType.withoutZone())).as("Should not convert timestamp with offset to a timestamp without zone", new Object[0])).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThat((Object)isoTimestampNanosWithZoneOffset.to((Type)Types.TimestampType.withZone()).value()).isEqualTo((Object)1510842668000000L);
        Assertions.assertThat((Object)isoTimestampNanosWithZoneOffset.to((Type)Types.TimestampNanoType.withZone()).value()).isEqualTo((Object)1510842668000000001L);
    }

    @Test
    public void testTimestampMicrosWithZoneConversion() {
        Literal isoTimestampMicrosWithZoneOffset = Literal.of((CharSequence)"2017-11-16T14:31:08.000001+00:00");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> isoTimestampMicrosWithZoneOffset.to((Type)Types.TimestampType.withoutZone())).as("Should not convert timestamp with offset to a timestamp without zone", new Object[0])).isInstanceOf(DateTimeParseException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> isoTimestampMicrosWithZoneOffset.to((Type)Types.TimestampNanoType.withoutZone())).as("Should not convert timestamp with offset to a timestamp without zone", new Object[0])).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThat((Object)isoTimestampMicrosWithZoneOffset.to((Type)Types.TimestampType.withZone()).value()).isEqualTo((Object)1510842668000001L);
        Assertions.assertThat((Object)isoTimestampMicrosWithZoneOffset.to((Type)Types.TimestampNanoType.withZone()).value()).isEqualTo((Object)1510842668000001000L);
    }

    @Test
    public void testTimestampNanosWithoutZoneConversion() {
        Literal isoTimestampNanosWithoutZoneOffset = Literal.of((CharSequence)"2017-11-16T14:31:08.000000001");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> isoTimestampNanosWithoutZoneOffset.to((Type)Types.TimestampType.withZone())).as("Should not convert timestamp without offset to a timestamp with zone", new Object[0])).isInstanceOf(DateTimeParseException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> isoTimestampNanosWithoutZoneOffset.to((Type)Types.TimestampNanoType.withZone())).as("Should not convert timestamp without offset to a timestamp with zone", new Object[0])).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThat((Object)isoTimestampNanosWithoutZoneOffset.to((Type)Types.TimestampType.withoutZone()).value()).isEqualTo((Object)1510842668000000L);
        Assertions.assertThat((Object)isoTimestampNanosWithoutZoneOffset.to((Type)Types.TimestampNanoType.withoutZone()).value()).isEqualTo((Object)1510842668000000001L);
    }

    @Test
    public void testTimestampMicrosWithoutZoneConversion() {
        Literal isoTimestampMicrosWithoutZoneOffset = Literal.of((CharSequence)"2017-11-16T14:31:08.000001");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> isoTimestampMicrosWithoutZoneOffset.to((Type)Types.TimestampType.withZone())).as("Should not convert timestamp without offset to a timestamp with zone", new Object[0])).isInstanceOf(DateTimeParseException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> isoTimestampMicrosWithoutZoneOffset.to((Type)Types.TimestampNanoType.withZone())).as("Should not convert timestamp without offset to a timestamp with zone", new Object[0])).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThat((Object)isoTimestampMicrosWithoutZoneOffset.to((Type)Types.TimestampType.withoutZone()).value()).isEqualTo((Object)1510842668000001L);
        Assertions.assertThat((Object)isoTimestampMicrosWithoutZoneOffset.to((Type)Types.TimestampNanoType.withoutZone()).value()).isEqualTo((Object)1510842668000001000L);
    }
}

