/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.Closeable;
import java.io.IOException;
import org.apache.iceberg.io.CloseableGroup;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestCloseableGroup {
    @Test
    public void callCloseToAllCloseables() throws IOException {
        Closeable closeable1 = (Closeable)Mockito.mock(Closeable.class);
        Closeable closeable2 = (Closeable)Mockito.mock(Closeable.class);
        Closeable closeable3 = (Closeable)Mockito.mock(Closeable.class);
        CloseableGroup closeableGroup = new CloseableGroup();
        closeableGroup.addCloseable(closeable1);
        closeableGroup.addCloseable(closeable2);
        closeableGroup.addCloseable(closeable3);
        closeableGroup.close();
        ((Closeable)Mockito.verify((Object)closeable1)).close();
        ((Closeable)Mockito.verify((Object)closeable2)).close();
        ((Closeable)Mockito.verify((Object)closeable3)).close();
    }

    @Test
    public void callCloseHandlesAutoCloseable() throws Exception {
        Closeable closeable1 = (Closeable)Mockito.mock(Closeable.class);
        AutoCloseable closeable2 = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        CloseableGroup closeableGroup = new CloseableGroup();
        closeableGroup.addCloseable(closeable1);
        closeableGroup.addCloseable(closeable2);
        closeableGroup.close();
        ((Closeable)Mockito.verify((Object)closeable1)).close();
        ((AutoCloseable)Mockito.verify((Object)closeable2)).close();
    }

    @Test
    public void suppressExceptionIfSetSuppressIsTrue() throws Exception {
        Closeable closeable1 = (Closeable)Mockito.mock(Closeable.class);
        AutoCloseable closeable2 = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        Closeable closeable3 = (Closeable)Mockito.mock(Closeable.class);
        ((Closeable)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("exception1")}).when((Object)closeable1)).close();
        ((AutoCloseable)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("exception2")}).when((Object)closeable2)).close();
        CloseableGroup closeableGroup = new CloseableGroup();
        closeableGroup.addCloseable(closeable1);
        closeableGroup.addCloseable(closeable2);
        closeableGroup.addCloseable(closeable3);
        closeableGroup.setSuppressCloseFailure(true);
        closeableGroup.close();
        ((Closeable)Mockito.verify((Object)closeable1)).close();
        ((AutoCloseable)Mockito.verify((Object)closeable2)).close();
        ((Closeable)Mockito.verify((Object)closeable3)).close();
    }

    @Test
    public void notSuppressExceptionIfSetSuppressIsFalse() throws Exception {
        IOException ioException = new IOException("e1");
        Closeable closeable1 = (Closeable)Mockito.mock(Closeable.class);
        Closeable closeable2 = (Closeable)Mockito.mock(Closeable.class);
        Closeable closeable3 = (Closeable)Mockito.mock(Closeable.class);
        ((Closeable)Mockito.doThrow((Throwable[])new Throwable[]{ioException}).when((Object)closeable2)).close();
        CloseableGroup closeableGroup = new CloseableGroup();
        closeableGroup.addCloseable(closeable1);
        closeableGroup.addCloseable(closeable2);
        closeableGroup.addCloseable(closeable3);
        Assertions.assertThatThrownBy(() -> ((CloseableGroup)closeableGroup).close()).isEqualTo((Object)ioException);
        ((Closeable)Mockito.verify((Object)closeable1)).close();
        ((Closeable)Mockito.verify((Object)closeable2)).close();
        Mockito.verifyNoInteractions((Object[])new Object[]{closeable3});
    }

    @Test
    public void notSuppressExceptionIfSetSuppressIsFalseForAutoCloseable() throws Exception {
        IOException ioException = new IOException("e1");
        AutoCloseable closeable1 = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        AutoCloseable closeable2 = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        AutoCloseable closeable3 = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        ((AutoCloseable)Mockito.doThrow((Throwable[])new Throwable[]{ioException}).when((Object)closeable2)).close();
        CloseableGroup closeableGroup = new CloseableGroup();
        closeableGroup.addCloseable(closeable1);
        closeableGroup.addCloseable(closeable2);
        closeableGroup.addCloseable(closeable3);
        Assertions.assertThatThrownBy(() -> ((CloseableGroup)closeableGroup).close()).isEqualTo((Object)ioException);
        ((AutoCloseable)Mockito.verify((Object)closeable1)).close();
        ((AutoCloseable)Mockito.verify((Object)closeable2)).close();
        Mockito.verifyNoInteractions((Object[])new Object[]{closeable3});
    }

    @Test
    public void wrapAutoCloseableFailuresWithRuntimeException() throws Exception {
        Exception generalException = new Exception("e");
        AutoCloseable throwingAutoCloseable = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        ((AutoCloseable)Mockito.doThrow((Throwable[])new Throwable[]{generalException}).when((Object)throwingAutoCloseable)).close();
        CloseableGroup closeableGroup = new CloseableGroup();
        closeableGroup.addCloseable(throwingAutoCloseable);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CloseableGroup)closeableGroup).close()).isInstanceOf(RuntimeException.class)).hasRootCause((Throwable)generalException);
    }

    @Test
    public void notWrapRuntimeException() throws Exception {
        RuntimeException runtimeException = new RuntimeException("e2");
        Closeable throwingCloseable = (Closeable)Mockito.mock(Closeable.class);
        ((Closeable)Mockito.doThrow((Throwable[])new Throwable[]{runtimeException}).when((Object)throwingCloseable)).close();
        CloseableGroup closeableGroup = new CloseableGroup();
        closeableGroup.addCloseable(throwingCloseable);
        Assertions.assertThatThrownBy(() -> ((CloseableGroup)closeableGroup).close()).isEqualTo((Object)runtimeException);
    }

    @Test
    public void notWrapRuntimeExceptionFromAutoCloseable() throws Exception {
        RuntimeException runtimeException = new RuntimeException("e2");
        AutoCloseable throwingAutoCloseable = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        ((AutoCloseable)Mockito.doThrow((Throwable[])new Throwable[]{runtimeException}).when((Object)throwingAutoCloseable)).close();
        CloseableGroup closeableGroup = new CloseableGroup();
        closeableGroup.addCloseable(throwingAutoCloseable);
        Assertions.assertThatThrownBy(() -> ((CloseableGroup)closeableGroup).close()).isEqualTo((Object)runtimeException);
    }
}

