/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.transforms.Dates;
import org.apache.iceberg.transforms.Days;
import org.apache.iceberg.transforms.Hours;
import org.apache.iceberg.transforms.Months;
import org.apache.iceberg.transforms.Timestamps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.transforms.Years;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTimestamps {
    @Test
    public void testMicrosSatisfiesOrderOfDates() {
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_HOUR.satisfiesOrderOf((Transform)Dates.DAY)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_HOUR.satisfiesOrderOf((Transform)Dates.MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_HOUR.satisfiesOrderOf((Transform)Dates.YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_DAY.satisfiesOrderOf((Transform)Dates.DAY)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_DAY.satisfiesOrderOf((Transform)Dates.MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_DAY.satisfiesOrderOf((Transform)Dates.YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_MONTH.satisfiesOrderOf((Transform)Dates.DAY)).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_MONTH.satisfiesOrderOf((Transform)Dates.MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_MONTH.satisfiesOrderOf((Transform)Dates.YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_YEAR.satisfiesOrderOf((Transform)Dates.DAY)).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_YEAR.satisfiesOrderOf((Transform)Dates.MONTH)).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_YEAR.satisfiesOrderOf((Transform)Dates.YEAR)).isTrue();
    }

    @Test
    public void testMicrosSatisfiesOrderOfTimestamps() {
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_HOUR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_HOUR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_HOUR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_DAY)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_HOUR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_HOUR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_DAY.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_DAY.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_DAY)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_DAY.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_DAY.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_MONTH.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_MONTH.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_DAY)).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_MONTH.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_MONTH.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_YEAR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_YEAR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_DAY)).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_YEAR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_MONTH)).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_YEAR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_YEAR)).isTrue();
    }

    @Test
    public void testMicrosSatisfiesOrderOfTimestampNanos() {
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_HOUR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_HOUR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_HOUR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_DAY)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_HOUR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_HOUR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_DAY.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_DAY.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_DAY)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_DAY.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_DAY.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_MONTH.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_MONTH.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_DAY)).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_MONTH.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_MONTH.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_YEAR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_YEAR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_DAY)).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_YEAR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_MONTH)).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_YEAR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_YEAR)).isTrue();
    }

    @Test
    public void testMicrosSatisfiesOrderOfTimeTransforms() {
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_HOUR.satisfiesOrderOf((Transform)Hours.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_HOUR.satisfiesOrderOf((Transform)Days.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_HOUR.satisfiesOrderOf((Transform)Months.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_HOUR.satisfiesOrderOf((Transform)Years.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_DAY.satisfiesOrderOf((Transform)Hours.get())).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_DAY.satisfiesOrderOf((Transform)Days.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_DAY.satisfiesOrderOf((Transform)Months.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_DAY.satisfiesOrderOf((Transform)Years.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_MONTH.satisfiesOrderOf((Transform)Hours.get())).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_MONTH.satisfiesOrderOf((Transform)Days.get())).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_MONTH.satisfiesOrderOf((Transform)Months.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_MONTH.satisfiesOrderOf((Transform)Years.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_YEAR.satisfiesOrderOf((Transform)Hours.get())).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_YEAR.satisfiesOrderOf((Transform)Days.get())).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_YEAR.satisfiesOrderOf((Transform)Months.get())).isFalse();
        Assertions.assertThat((boolean)Timestamps.MICROS_TO_YEAR.satisfiesOrderOf((Transform)Years.get())).isTrue();
    }

    @Test
    public void testNanosSatisfiesOrderOfDates() {
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_HOUR.satisfiesOrderOf((Transform)Dates.DAY)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_HOUR.satisfiesOrderOf((Transform)Dates.MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_HOUR.satisfiesOrderOf((Transform)Dates.YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_DAY.satisfiesOrderOf((Transform)Dates.DAY)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_DAY.satisfiesOrderOf((Transform)Dates.MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_DAY.satisfiesOrderOf((Transform)Dates.YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_MONTH.satisfiesOrderOf((Transform)Dates.DAY)).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_MONTH.satisfiesOrderOf((Transform)Dates.MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_MONTH.satisfiesOrderOf((Transform)Dates.YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_YEAR.satisfiesOrderOf((Transform)Dates.DAY)).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_YEAR.satisfiesOrderOf((Transform)Dates.MONTH)).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_YEAR.satisfiesOrderOf((Transform)Dates.YEAR)).isTrue();
    }

    @Test
    public void testNanosSatisfiesOrderOfTimestamps() {
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_HOUR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_HOUR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_HOUR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_DAY)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_HOUR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_HOUR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_DAY.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_DAY.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_DAY)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_DAY.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_DAY.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_MONTH.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_MONTH.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_DAY)).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_MONTH.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_MONTH.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_YEAR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_YEAR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_DAY)).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_YEAR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_MONTH)).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_YEAR.satisfiesOrderOf((Transform)Timestamps.MICROS_TO_YEAR)).isTrue();
    }

    @Test
    public void testNanosSatisfiesOrderOfTimestampNanos() {
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_HOUR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_HOUR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_HOUR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_DAY)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_HOUR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_HOUR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_DAY.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_DAY.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_DAY)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_DAY.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_DAY.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_MONTH.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_MONTH.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_DAY)).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_MONTH.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_MONTH)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_MONTH.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_YEAR)).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_YEAR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_HOUR)).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_YEAR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_DAY)).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_YEAR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_MONTH)).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_YEAR.satisfiesOrderOf((Transform)Timestamps.NANOS_TO_YEAR)).isTrue();
    }

    @Test
    public void testNanosSatisfiesOrderOfTimeTransforms() {
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_HOUR.satisfiesOrderOf((Transform)Hours.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_HOUR.satisfiesOrderOf((Transform)Days.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_HOUR.satisfiesOrderOf((Transform)Months.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_HOUR.satisfiesOrderOf((Transform)Years.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_DAY.satisfiesOrderOf((Transform)Hours.get())).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_DAY.satisfiesOrderOf((Transform)Days.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_DAY.satisfiesOrderOf((Transform)Months.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_DAY.satisfiesOrderOf((Transform)Years.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_MONTH.satisfiesOrderOf((Transform)Hours.get())).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_MONTH.satisfiesOrderOf((Transform)Days.get())).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_MONTH.satisfiesOrderOf((Transform)Months.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_MONTH.satisfiesOrderOf((Transform)Years.get())).isTrue();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_YEAR.satisfiesOrderOf((Transform)Hours.get())).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_YEAR.satisfiesOrderOf((Transform)Days.get())).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_YEAR.satisfiesOrderOf((Transform)Months.get())).isFalse();
        Assertions.assertThat((boolean)Timestamps.NANOS_TO_YEAR.satisfiesOrderOf((Transform)Years.get())).isTrue();
    }

    @Test
    public void testDeprecatedTimestampTransform() {
        Types.TimestampType type = Types.TimestampType.withoutZone();
        Literal ts = Literal.of((CharSequence)"2017-12-01T10:12:55.038194").to((Type)type);
        Literal pts = Literal.of((CharSequence)"1970-01-01T00:00:01.000001").to((Type)type);
        Literal nts = Literal.of((CharSequence)"1969-12-31T23:59:59.999999").to((Type)type);
        Transform years = Transforms.year((Type)type);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.apply((Object)((Long)ts.value())))).as("Should produce 2017 - 1970 = 47", new Object[0])).isEqualTo(47);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.apply((Object)((Long)pts.value())))).as("Should produce 1970 - 1970 = 0", new Object[0])).isZero();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.apply((Object)((Long)nts.value())))).as("Should produce 1969 - 1970 = -1", new Object[0])).isEqualTo(-1);
        Transform months = Transforms.month((Type)type);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)months.apply((Object)((Long)ts.value())))).as("Should produce 47 * 12 + 11 = 575", new Object[0])).isEqualTo(575);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)months.apply((Object)((Long)pts.value())))).as("Should produce 0 * 12 + 0 = 0", new Object[0])).isZero();
        Assertions.assertThat((int)((Integer)months.apply((Object)((Long)nts.value())))).isEqualTo(-1);
        Transform days = Transforms.day((Type)type);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)days.apply((Object)((Long)ts.value())))).as("Should produce 17501", new Object[0])).isEqualTo(17501);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)days.apply((Object)((Long)pts.value())))).as("Should produce 0 * 365 + 0 = 0", new Object[0])).isZero();
        Assertions.assertThat((int)((Integer)days.apply((Object)((Long)nts.value())))).isEqualTo(-1);
        Transform hours = Transforms.hour((Type)type);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)hours.apply((Object)((Long)ts.value())))).as("Should produce 17501 * 24 + 10", new Object[0])).isEqualTo(420034);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)hours.apply((Object)((Long)pts.value())))).as("Should produce 0 * 24 + 0 = 0", new Object[0])).isZero();
        Assertions.assertThat((int)((Integer)hours.apply((Object)((Long)nts.value())))).isEqualTo(-1);
    }

    @Test
    public void testDeprecatedTimestampNanoTransform() {
        Types.TimestampNanoType type = Types.TimestampNanoType.withoutZone();
        Literal ts = Literal.of((CharSequence)"2017-12-01T10:12:55.038194789").to((Type)type);
        Literal pts = Literal.of((CharSequence)"1970-01-01T00:00:01.000000001").to((Type)type);
        Literal nts = Literal.of((CharSequence)"1969-12-31T23:59:59.999999999").to((Type)type);
        Transform years = Transforms.year((Type)type);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.apply((Object)((Long)ts.value())))).as("Should produce 2017 - 1970 = 47", new Object[0])).isEqualTo(47);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.apply((Object)((Long)pts.value())))).as("Should produce 1970 - 1970 = 0", new Object[0])).isZero();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.apply((Object)((Long)nts.value())))).as("Should produce 1969 - 1970 = -1", new Object[0])).isEqualTo(-1);
        Transform months = Transforms.month((Type)type);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)months.apply((Object)((Long)ts.value())))).as("Should produce 47 * 12 + 11 = 575", new Object[0])).isEqualTo(575);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)months.apply((Object)((Long)pts.value())))).as("Should produce 0 * 12 + 0 = 0", new Object[0])).isZero();
        Assertions.assertThat((int)((Integer)months.apply((Object)((Long)nts.value())))).isEqualTo(-1);
        Transform days = Transforms.day((Type)type);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)days.apply((Object)((Long)ts.value())))).as("Should produce 17501", new Object[0])).isEqualTo(17501);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)days.apply((Object)((Long)pts.value())))).as("Should produce 0 * 365 + 0 = 0", new Object[0])).isZero();
        Assertions.assertThat((int)((Integer)days.apply((Object)((Long)nts.value())))).isEqualTo(-1);
        Transform hours = Transforms.hour((Type)type);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)hours.apply((Object)((Long)ts.value())))).as("Should produce 17501 * 24 + 10", new Object[0])).isEqualTo(420034);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)hours.apply((Object)((Long)pts.value())))).as("Should produce 0 * 24 + 0 = 0", new Object[0])).isZero();
        Assertions.assertThat((int)((Integer)hours.apply((Object)((Long)nts.value())))).isEqualTo(-1);
    }

    @Test
    public void testTimestampTransform() {
        Types.TimestampType type = Types.TimestampType.withoutZone();
        Literal ts = Literal.of((CharSequence)"2017-12-01T10:12:55.038194").to((Type)type);
        Literal pts = Literal.of((CharSequence)"1970-01-01T00:00:01.000001").to((Type)type);
        Literal nts = Literal.of((CharSequence)"1969-12-31T23:59:59.999999").to((Type)type);
        Transform years = Transforms.year();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.bind((Type)type).apply((Object)((Long)ts.value())))).as("Should produce 2017 - 1970 = 47", new Object[0])).isEqualTo(47);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.bind((Type)type).apply((Object)((Long)pts.value())))).as("Should produce 1970 - 1970 = 0", new Object[0])).isZero();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.bind((Type)type).apply((Object)((Long)nts.value())))).as("Should produce 1969 - 1970 = -1", new Object[0])).isEqualTo(-1);
        Transform months = Transforms.month();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)months.bind((Type)type).apply((Object)((Long)ts.value())))).as("Should produce 47 * 12 + 11 = 575", new Object[0])).isEqualTo(575);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)months.bind((Type)type).apply((Object)((Long)pts.value())))).as("Should produce 0 * 12 + 0 = 0", new Object[0])).isZero();
        Assertions.assertThat((int)((Integer)months.bind((Type)type).apply((Object)((Long)nts.value())))).isEqualTo(-1);
        Transform days = Transforms.day();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)days.bind((Type)type).apply((Object)((Long)ts.value())))).as("Should produce 17501", new Object[0])).isEqualTo(17501);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)days.bind((Type)type).apply((Object)((Long)pts.value())))).as("Should produce 0 * 365 + 0 = 0", new Object[0])).isZero();
        Assertions.assertThat((int)((Integer)days.bind((Type)type).apply((Object)((Long)nts.value())))).isEqualTo(-1);
        Transform hours = Transforms.hour();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)hours.bind((Type)type).apply((Object)((Long)ts.value())))).as("Should produce 17501 * 24 + 10", new Object[0])).isEqualTo(420034);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)hours.bind((Type)type).apply((Object)((Long)pts.value())))).as("Should produce 0 * 24 + 0 = 0", new Object[0])).isZero();
        Assertions.assertThat((int)((Integer)hours.bind((Type)type).apply((Object)((Long)nts.value())))).isEqualTo(-1);
    }

    @Test
    public void testTimestampNanoTransform() {
        Types.TimestampNanoType type = Types.TimestampNanoType.withoutZone();
        Literal ts = Literal.of((CharSequence)"2017-12-01T10:12:55.038194789").to((Type)type);
        Literal pts = Literal.of((CharSequence)"1970-01-01T00:00:01.000000001").to((Type)type);
        Literal nts = Literal.of((CharSequence)"1969-12-31T23:59:59.999999999").to((Type)type);
        Transform years = Transforms.year();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.bind((Type)type).apply((Object)((Long)ts.value())))).as("Should produce 2017 - 1970 = 47", new Object[0])).isEqualTo(47);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.bind((Type)type).apply((Object)((Long)pts.value())))).as("Should produce 1970 - 1970 = 0", new Object[0])).isZero();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)years.bind((Type)type).apply((Object)((Long)nts.value())))).as("Should produce 1969 - 1970 = -1", new Object[0])).isEqualTo(-1);
        Transform months = Transforms.month();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)months.bind((Type)type).apply((Object)((Long)ts.value())))).as("Should produce 47 * 12 + 11 = 575", new Object[0])).isEqualTo(575);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)months.bind((Type)type).apply((Object)((Long)pts.value())))).as("Should produce 0 * 12 + 0 = 0", new Object[0])).isZero();
        Assertions.assertThat((int)((Integer)months.bind((Type)type).apply((Object)((Long)nts.value())))).isEqualTo(-1);
        Transform days = Transforms.day();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)days.bind((Type)type).apply((Object)((Long)ts.value())))).as("Should produce 17501", new Object[0])).isEqualTo(17501);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)days.bind((Type)type).apply((Object)((Long)pts.value())))).as("Should produce 0 * 365 + 0 = 0", new Object[0])).isZero();
        Assertions.assertThat((int)((Integer)days.bind((Type)type).apply((Object)((Long)nts.value())))).isEqualTo(-1);
        Transform hours = Transforms.hour();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)hours.bind((Type)type).apply((Object)((Long)ts.value())))).as("Should produce 17501 * 24 + 10", new Object[0])).isEqualTo(420034);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)hours.bind((Type)type).apply((Object)((Long)pts.value())))).as("Should produce 0 * 24 + 0 = 0", new Object[0])).isZero();
        Assertions.assertThat((int)((Integer)hours.bind((Type)type).apply((Object)((Long)nts.value())))).isEqualTo(-1);
    }

    @Test
    public void testTimestampWithoutZoneToHumanString() {
        Types.TimestampType type = Types.TimestampType.withoutZone();
        Literal date = Literal.of((CharSequence)"2017-12-01T10:12:55.038194").to((Type)type);
        Transform year = Transforms.year();
        Assertions.assertThat((String)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("2017");
        Transform month = Transforms.month();
        Assertions.assertThat((String)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("2017-12");
        Transform day = Transforms.day();
        Assertions.assertThat((String)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("2017-12-01");
        Transform hour = Transforms.hour();
        Assertions.assertThat((String)hour.toHumanString((Type)type, (Object)((Integer)hour.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("2017-12-01-10");
    }

    @Test
    public void testTimestampNanoWithoutZoneToHumanString() {
        Types.TimestampNanoType type = Types.TimestampNanoType.withoutZone();
        Literal date = Literal.of((CharSequence)"2017-12-01T10:12:55.038194789").to((Type)type);
        Transform year = Transforms.year();
        Assertions.assertThat((String)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("2017");
        Transform month = Transforms.month();
        Assertions.assertThat((String)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("2017-12");
        Transform day = Transforms.day();
        Assertions.assertThat((String)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("2017-12-01");
        Transform hour = Transforms.hour();
        Assertions.assertThat((String)hour.toHumanString((Type)type, (Object)((Integer)hour.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("2017-12-01-10");
    }

    @Test
    public void testNegativeTimestampWithoutZoneToHumanString() {
        Types.TimestampType type = Types.TimestampType.withoutZone();
        Literal date = Literal.of((CharSequence)"1969-12-30T10:12:55.038194").to((Type)type);
        Transform year = Transforms.year();
        Assertions.assertThat((String)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969");
        Transform month = Transforms.month();
        Assertions.assertThat((String)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12");
        Transform day = Transforms.day();
        Assertions.assertThat((String)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12-30");
        Transform hour = Transforms.hour();
        Assertions.assertThat((String)hour.toHumanString((Type)type, (Object)((Integer)hour.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12-30-10");
    }

    @Test
    public void testNegativeTimestampNanoWithoutZoneToHumanString() {
        Types.TimestampNanoType type = Types.TimestampNanoType.withoutZone();
        Literal date = Literal.of((CharSequence)"1969-12-30T10:12:55.038194789").to((Type)type);
        Transform year = Transforms.year();
        Assertions.assertThat((String)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969");
        Transform month = Transforms.month();
        Assertions.assertThat((String)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12");
        Transform day = Transforms.day();
        Assertions.assertThat((String)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12-30");
        Transform hour = Transforms.hour();
        Assertions.assertThat((String)hour.toHumanString((Type)type, (Object)((Integer)hour.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12-30-10");
    }

    @Test
    public void testNegativeTimestampWithoutZoneToHumanStringLowerBound() {
        Types.TimestampType type = Types.TimestampType.withoutZone();
        Literal date = Literal.of((CharSequence)"1969-12-30T00:00:00.000000").to((Type)type);
        Transform year = Transforms.year();
        Assertions.assertThat((String)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969");
        Transform month = Transforms.month();
        Assertions.assertThat((String)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12");
        Transform day = Transforms.day();
        Assertions.assertThat((String)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12-30");
        Transform hour = Transforms.hour();
        Assertions.assertThat((String)hour.toHumanString((Type)type, (Object)((Integer)hour.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12-30-00");
    }

    @Test
    public void testNegativeTimestampNanoWithoutZoneToHumanStringLowerBound() {
        Types.TimestampNanoType type = Types.TimestampNanoType.withoutZone();
        Literal date = Literal.of((CharSequence)"1969-12-30T00:00:00.000000000").to((Type)type);
        Transform year = Transforms.year();
        Assertions.assertThat((String)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969");
        Transform month = Transforms.month();
        Assertions.assertThat((String)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12");
        Transform day = Transforms.day();
        Assertions.assertThat((String)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12-30");
        Transform hour = Transforms.hour();
        Assertions.assertThat((String)hour.toHumanString((Type)type, (Object)((Integer)hour.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12-30-00");
    }

    @Test
    public void testNegativeTimestampWithoutZoneToHumanStringUpperBound() {
        Types.TimestampType type = Types.TimestampType.withoutZone();
        Literal date = Literal.of((CharSequence)"1969-12-31T23:59:59.999999").to((Type)type);
        Transform year = Transforms.year();
        Assertions.assertThat((String)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969");
        Transform month = Transforms.month();
        Assertions.assertThat((String)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12");
        Transform day = Transforms.day();
        Assertions.assertThat((String)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12-31");
        Transform hour = Transforms.hour();
        Assertions.assertThat((String)hour.toHumanString((Type)type, (Object)((Integer)hour.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12-31-23");
    }

    @Test
    public void testNegativeTimestampNanoWithoutZoneToHumanStringUpperBound() {
        Types.TimestampNanoType type = Types.TimestampNanoType.withoutZone();
        Literal date = Literal.of((CharSequence)"1969-12-31T23:59:59.999999999").to((Type)type);
        Transform year = Transforms.year();
        Assertions.assertThat((String)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969");
        Transform month = Transforms.month();
        Assertions.assertThat((String)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12");
        Transform day = Transforms.day();
        Assertions.assertThat((String)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12-31");
        Transform hour = Transforms.hour();
        Assertions.assertThat((String)hour.toHumanString((Type)type, (Object)((Integer)hour.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("1969-12-31-23");
    }

    @Test
    public void testTimestampWithZoneToHumanString() {
        Types.TimestampType type = Types.TimestampType.withZone();
        Literal date = Literal.of((CharSequence)"2017-12-01T10:12:55.038194-08:00").to((Type)type);
        Transform year = Transforms.year();
        Assertions.assertThat((String)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("2017");
        Transform month = Transforms.month();
        Assertions.assertThat((String)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("2017-12");
        Transform day = Transforms.day();
        Assertions.assertThat((String)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("2017-12-01");
        Transform hour = Transforms.hour();
        Assertions.assertThat((String)hour.toHumanString((Type)type, (Object)((Integer)hour.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("2017-12-01-18");
    }

    @Test
    public void testTimestampNanoWithZoneToHumanString() {
        Types.TimestampNanoType type = Types.TimestampNanoType.withZone();
        Literal date = Literal.of((CharSequence)"2017-12-01T10:12:55.038194789-08:00").to((Type)type);
        Transform year = Transforms.year();
        Assertions.assertThat((String)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("2017");
        Transform month = Transforms.month();
        Assertions.assertThat((String)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("2017-12");
        Transform day = Transforms.day();
        Assertions.assertThat((String)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("2017-12-01");
        Transform hour = Transforms.hour();
        Assertions.assertThat((String)hour.toHumanString((Type)type, (Object)((Integer)hour.bind((Type)type).apply((Object)((Long)date.value()))))).isEqualTo("2017-12-01-18");
    }

    @Test
    public void testTimestampNullHumanString() {
        Types.TimestampType type = Types.TimestampType.withZone();
        ((AbstractStringAssert)Assertions.assertThat((String)Transforms.year().toHumanString((Type)type, null)).as("Should produce \"null\" for null", new Object[0])).isEqualTo("null");
        ((AbstractStringAssert)Assertions.assertThat((String)Transforms.month().toHumanString((Type)type, null)).as("Should produce \"null\" for null", new Object[0])).isEqualTo("null");
        ((AbstractStringAssert)Assertions.assertThat((String)Transforms.day().toHumanString((Type)type, null)).as("Should produce \"null\" for null", new Object[0])).isEqualTo("null");
        ((AbstractStringAssert)Assertions.assertThat((String)Transforms.hour().toHumanString((Type)type, null)).as("Should produce \"null\" for null", new Object[0])).isEqualTo("null");
    }

    @Test
    public void testTimestampNanoNullHumanString() {
        Types.TimestampNanoType type = Types.TimestampNanoType.withZone();
        ((AbstractStringAssert)Assertions.assertThat((String)Transforms.year().toHumanString((Type)type, null)).as("Should produce \"null\" for null", new Object[0])).isEqualTo("null");
        ((AbstractStringAssert)Assertions.assertThat((String)Transforms.month().toHumanString((Type)type, null)).as("Should produce \"null\" for null", new Object[0])).isEqualTo("null");
        ((AbstractStringAssert)Assertions.assertThat((String)Transforms.day().toHumanString((Type)type, null)).as("Should produce \"null\" for null", new Object[0])).isEqualTo("null");
        ((AbstractStringAssert)Assertions.assertThat((String)Transforms.hour().toHumanString((Type)type, null)).as("Should produce \"null\" for null", new Object[0])).isEqualTo("null");
    }

    @Test
    public void testTimestampsReturnType() {
        Types.TimestampType type = Types.TimestampType.withZone();
        Transform year = Transforms.year();
        Type yearResultType = year.getResultType((Type)type);
        Assertions.assertThat((Object)yearResultType).isEqualTo((Object)Types.IntegerType.get());
        Transform month = Transforms.month();
        Type monthResultType = month.getResultType((Type)type);
        Assertions.assertThat((Object)monthResultType).isEqualTo((Object)Types.IntegerType.get());
        Transform day = Transforms.day();
        Type dayResultType = day.getResultType((Type)type);
        Assertions.assertThat((Object)dayResultType).isEqualTo((Object)Types.DateType.get());
        Transform hour = Transforms.hour();
        Type hourResultType = hour.getResultType((Type)type);
        Assertions.assertThat((Object)hourResultType).isEqualTo((Object)Types.IntegerType.get());
    }

    @Test
    public void testTimestampNanosReturnType() {
        Types.TimestampNanoType type = Types.TimestampNanoType.withZone();
        Transform year = Transforms.year();
        Type yearResultType = year.getResultType((Type)type);
        Assertions.assertThat((Object)yearResultType).isEqualTo((Object)Types.IntegerType.get());
        Transform month = Transforms.month();
        Type monthResultType = month.getResultType((Type)type);
        Assertions.assertThat((Object)monthResultType).isEqualTo((Object)Types.IntegerType.get());
        Transform day = Transforms.day();
        Type dayResultType = day.getResultType((Type)type);
        Assertions.assertThat((Object)dayResultType).isEqualTo((Object)Types.DateType.get());
        Transform hour = Transforms.hour();
        Type hourResultType = hour.getResultType((Type)type);
        Assertions.assertThat((Object)hourResultType).isEqualTo((Object)Types.IntegerType.get());
    }
}

