/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.TransformUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTruncatesProjection {
    public void assertProjectionStrict(PartitionSpec spec, UnboundPredicate<?> filter, Expression.Operation expectedOp, String expectedLiteral) {
        Expression projection = Projections.strict((PartitionSpec)spec).project(filter);
        UnboundPredicate predicate = TestHelpers.assertAndUnwrapUnbound(projection);
        ((AbstractComparableAssert)((AbstractComparableAssert)Assertions.assertThat((Comparable)predicate.op()).isEqualTo((Object)expectedOp)).as("Strict projection never runs for IN", new Object[0])).isNotEqualTo((Object)Expression.Operation.IN);
        Transform transform = ((PartitionField)spec.getFieldsBySourceId(1).get(0)).transform();
        Type type = spec.partitionType().field(((PartitionField)spec.getFieldsBySourceId(1).get(0)).fieldId()).type();
        if (predicate.op() == Expression.Operation.NOT_IN) {
            Iterable values = Iterables.transform((Iterable)predicate.literals(), Literal::value);
            String actual = Lists.newArrayList((Iterable)values).stream().sorted().map(v -> transform.toHumanString(type, v)).collect(Collectors.toList()).toString();
            Assertions.assertThat((String)actual).isEqualTo(expectedLiteral);
        } else {
            Literal literal = predicate.literal();
            String output = transform.toHumanString(type, literal.value());
            Assertions.assertThat((String)output).isEqualTo(expectedLiteral);
        }
    }

    public void assertProjectionStrictValue(PartitionSpec spec, UnboundPredicate<?> filter, Expression.Operation expectedOp) {
        Expression projection = Projections.strict((PartitionSpec)spec).project(filter);
        Assertions.assertThat((Comparable)expectedOp).isEqualTo((Object)projection.op());
    }

    public void assertProjectionInclusiveValue(PartitionSpec spec, UnboundPredicate<?> filter, Expression.Operation expectedOp) {
        Expression projection = Projections.inclusive((PartitionSpec)spec).project(filter);
        Assertions.assertThat((Comparable)expectedOp).isEqualTo((Object)projection.op());
    }

    public void assertProjectionInclusive(PartitionSpec spec, UnboundPredicate<?> filter, Expression.Operation expectedOp, String expectedLiteral) {
        Expression projection = Projections.inclusive((PartitionSpec)spec).project(filter);
        UnboundPredicate predicate = TestHelpers.assertAndUnwrapUnbound(projection);
        ((AbstractComparableAssert)((AbstractComparableAssert)((AbstractComparableAssert)Assertions.assertThat((Comparable)predicate.op()).as("Operation should match", new Object[0])).isEqualTo((Object)expectedOp)).as("Inclusive projection never runs for NOT_IN", new Object[0])).isNotEqualTo((Object)Expression.Operation.NOT_IN);
        Transform transform = ((PartitionField)spec.getFieldsBySourceId(1).get(0)).transform();
        Type type = spec.partitionType().field(((PartitionField)spec.getFieldsBySourceId(1).get(0)).fieldId()).type();
        if (predicate.op() == Expression.Operation.IN) {
            Iterable values = Iterables.transform((Iterable)predicate.literals(), Literal::value);
            String actual = Lists.newArrayList((Iterable)values).stream().sorted().map(v -> transform.toHumanString(type, v)).collect(Collectors.toList()).toString();
            Assertions.assertThat((String)actual).isEqualTo(expectedLiteral);
        } else {
            Literal literal = predicate.literal();
            String output = transform.toHumanString(type, literal.value());
            Assertions.assertThat((String)output).isEqualTo(expectedLiteral);
        }
    }

    @Test
    public void testIntegerStrictLowerBound() {
        Integer value = 100;
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.IntegerType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 10).build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.LT, "100");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.LT, "100");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.GT, "100");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.GT, "90");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.NOT_EQ, "100");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrict(spec, Expressions.notIn((String)"value", (Object[])new Integer[]{value - 1, value, value + 1}), Expression.Operation.NOT_IN, "[90, 100, 100]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"value", (Object[])new Integer[]{value, value + 1}), Expression.Operation.FALSE);
    }

    @Test
    public void testIntegerStrictUpperBound() {
        Integer value = 99;
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.IntegerType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 10).build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.LT, "90");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.LT, "100");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.GT, "90");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.GT, "90");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.NOT_EQ, "90");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrict(spec, Expressions.notIn((String)"value", (Object[])new Integer[]{value - 1, value, value + 1}), Expression.Operation.NOT_IN, "[90, 90, 100]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"value", (Object[])new Integer[]{value, value - 1}), Expression.Operation.FALSE);
    }

    @Test
    public void testIntegerInclusiveLowerBound() {
        Integer value = 100;
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.IntegerType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 10).build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.LT_EQ, "90");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.LT_EQ, "100");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.GT_EQ, "100");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.GT_EQ, "100");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.EQ, "100");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusive(spec, Expressions.in((String)"value", (Object[])new Integer[]{value - 1, value, value + 1}), Expression.Operation.IN, "[90, 100, 100]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"value", (Object[])new Integer[]{value, value + 1}), Expression.Operation.TRUE);
    }

    @Test
    public void testIntegerInclusiveUpperBound() {
        Integer value = 99;
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.IntegerType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 10).build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.LT_EQ, "90");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.LT_EQ, "90");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.GT_EQ, "100");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.GT_EQ, "90");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.EQ, "90");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusive(spec, Expressions.in((String)"value", (Object[])new Integer[]{value - 1, value, value + 1}), Expression.Operation.IN, "[90, 90, 100]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"value", (Object[])new Integer[]{value, value - 1}), Expression.Operation.TRUE);
    }

    @Test
    public void testLongStrictLowerBound() {
        Long value = 100L;
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.LongType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 10).build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.LT, "100");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.LT, "100");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.GT, "100");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.GT, "90");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.NOT_EQ, "100");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrict(spec, Expressions.notIn((String)"value", (Object[])new Long[]{value - 1L, value, value + 1L}), Expression.Operation.NOT_IN, "[90, 100, 100]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"value", (Object[])new Long[]{value, value + 1L}), Expression.Operation.FALSE);
    }

    @Test
    public void testLongStrictUpperBound() {
        Long value = 99L;
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.LongType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 10).build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.LT, "90");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.LT, "100");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.GT, "90");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.GT, "90");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.NOT_EQ, "90");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrict(spec, Expressions.notIn((String)"value", (Object[])new Long[]{value - 1L, value, value + 1L}), Expression.Operation.NOT_IN, "[90, 90, 100]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"value", (Object[])new Long[]{value, value - 1L}), Expression.Operation.FALSE);
    }

    @Test
    public void testLongInclusiveLowerBound() {
        Long value = 100L;
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.LongType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 10).build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.LT_EQ, "90");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.LT_EQ, "100");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.GT_EQ, "100");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.GT_EQ, "100");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.EQ, "100");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusive(spec, Expressions.in((String)"value", (Object[])new Long[]{value - 1L, value, value + 1L}), Expression.Operation.IN, "[90, 100, 100]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"value", (Object[])new Long[]{value, value + 1L}), Expression.Operation.TRUE);
    }

    @Test
    public void testLongInclusiveUpperBound() {
        Long value = 99L;
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.LongType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 10).build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.LT_EQ, "90");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.LT_EQ, "90");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.GT_EQ, "100");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.GT_EQ, "90");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.EQ, "90");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusive(spec, Expressions.in((String)"value", (Object[])new Long[]{value - 1L, value, value + 1L}), Expression.Operation.IN, "[90, 90, 100]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"value", (Object[])new Long[]{value, value - 1L}), Expression.Operation.TRUE);
    }

    @Test
    public void testDecimalStrictLowerBound() {
        Types.DecimalType type = Types.DecimalType.of((int)9, (int)2);
        BigDecimal value = (BigDecimal)Literal.of((CharSequence)"100.00").to((Type)type).value();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)type)});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 10).build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.LT, "100.00");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.LT, "100.00");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.GT, "100.00");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.GT, "99.90");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.NOT_EQ, "100.00");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.FALSE);
        BigDecimal delta = new BigDecimal(1);
        this.assertProjectionStrict(spec, Expressions.notIn((String)"value", (Object[])new BigDecimal[]{value.add(delta), value, value.subtract(delta)}), Expression.Operation.NOT_IN, "[99.00, 100.00, 101.00]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"value", (Object[])new BigDecimal[]{value, value.add(delta)}), Expression.Operation.FALSE);
    }

    @Test
    public void testDecimalStrictUpperBound() {
        Types.DecimalType type = Types.DecimalType.of((int)9, (int)2);
        BigDecimal value = (BigDecimal)Literal.of((CharSequence)"99.99").to((Type)type).value();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)type)});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 10).build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.LT, "99.90");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.LT, "100.00");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.GT, "99.90");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.GT, "99.90");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.NOT_EQ, "99.90");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.FALSE);
        BigDecimal delta = new BigDecimal(1);
        this.assertProjectionStrict(spec, Expressions.notIn((String)"value", (Object[])new BigDecimal[]{value.add(delta), value, value.subtract(delta)}), Expression.Operation.NOT_IN, "[98.90, 99.90, 100.90]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"value", (Object[])new BigDecimal[]{value, value.subtract(delta)}), Expression.Operation.FALSE);
    }

    @Test
    public void testDecimalInclusiveLowerBound() {
        Types.DecimalType type = Types.DecimalType.of((int)9, (int)2);
        BigDecimal value = (BigDecimal)Literal.of((CharSequence)"100.00").to((Type)type).value();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)type)});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 10).build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.LT_EQ, "99.90");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.LT_EQ, "100.00");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.GT_EQ, "100.00");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.GT_EQ, "100.00");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.EQ, "100.00");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        BigDecimal delta = new BigDecimal(1);
        this.assertProjectionInclusive(spec, Expressions.in((String)"value", (Object[])new BigDecimal[]{value.add(delta), value, value.subtract(delta)}), Expression.Operation.IN, "[99.00, 100.00, 101.00]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"value", (Object[])new BigDecimal[]{value, value.add(delta)}), Expression.Operation.TRUE);
    }

    @Test
    public void testDecimalInclusiveUpperBound() {
        Types.DecimalType type = Types.DecimalType.of((int)9, (int)2);
        BigDecimal value = (BigDecimal)Literal.of((CharSequence)"99.99").to((Type)type).value();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)type)});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 10).build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.LT_EQ, "99.90");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.LT_EQ, "99.90");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.GT_EQ, "100.00");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.GT_EQ, "99.90");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.EQ, "99.90");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        BigDecimal delta = new BigDecimal(1);
        this.assertProjectionInclusive(spec, Expressions.in((String)"value", (Object[])new BigDecimal[]{value.add(delta), value, value.subtract(delta)}), Expression.Operation.IN, "[98.90, 99.90, 100.90]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"value", (Object[])new BigDecimal[]{value, value.subtract(delta)}), Expression.Operation.TRUE);
    }

    @Test
    public void testStringStrict() {
        String value = "abcdefg";
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 5).build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.LT, "abcde");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.LT, "abcde");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.GT, "abcde");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.GT, "abcde");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.NOT_EQ, "abcde");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrict(spec, Expressions.notIn((String)"value", (Object[])new String[]{value, value + "abc"}), Expression.Operation.NOT_IN, "[abcde, abcde]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"value", (Object[])new String[]{value, value + "abc"}), Expression.Operation.FALSE);
    }

    @Test
    public void testStringInclusive() {
        String value = "abcdefg";
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 5).build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.LT_EQ, "abcde");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.LT_EQ, "abcde");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.GT_EQ, "abcde");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.GT_EQ, "abcde");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.EQ, "abcde");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusive(spec, Expressions.in((String)"value", (Object[])new String[]{value, value + "abc"}), Expression.Operation.IN, "[abcde, abcde]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"value", (Object[])new String[]{value, value + "abc"}), Expression.Operation.TRUE);
    }

    @Test
    public void testBinaryStrict() throws Exception {
        ByteBuffer value = ByteBuffer.wrap("abcdefg".getBytes(StandardCharsets.UTF_8));
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.BinaryType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 5).build();
        String expectedValue = TransformUtil.base64encode((ByteBuffer)ByteBuffer.wrap("abcde".getBytes(StandardCharsets.UTF_8)));
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.LT, expectedValue);
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.LT, expectedValue);
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.GT, expectedValue);
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.GT, expectedValue);
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.NOT_EQ, expectedValue);
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.FALSE);
        ByteBuffer anotherValue = ByteBuffer.wrap("abcdehij".getBytes(StandardCharsets.UTF_8));
        this.assertProjectionStrict(spec, Expressions.notIn((String)"value", (Object[])new ByteBuffer[]{value, anotherValue}), Expression.Operation.NOT_IN, String.format("[%s, %s]", expectedValue, expectedValue));
        this.assertProjectionStrictValue(spec, Expressions.in((String)"value", (Object[])new ByteBuffer[]{value, anotherValue}), Expression.Operation.FALSE);
    }

    @Test
    public void testBinaryInclusive() throws Exception {
        ByteBuffer value = ByteBuffer.wrap("abcdefg".getBytes(StandardCharsets.UTF_8));
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.BinaryType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 5).build();
        String expectedValue = TransformUtil.base64encode((ByteBuffer)ByteBuffer.wrap("abcde".getBytes(StandardCharsets.UTF_8)));
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.LT_EQ, expectedValue);
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.LT_EQ, expectedValue);
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.GT_EQ, expectedValue);
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.GT_EQ, expectedValue);
        this.assertProjectionInclusive(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.EQ, expectedValue);
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        ByteBuffer anotherValue = ByteBuffer.wrap("abcdehij".getBytes(StandardCharsets.UTF_8));
        this.assertProjectionInclusive(spec, Expressions.in((String)"value", (Object[])new ByteBuffer[]{value, anotherValue}), Expression.Operation.IN, String.format("[%s, %s]", expectedValue, expectedValue));
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"value", (Object[])new ByteBuffer[]{value, anotherValue}), Expression.Operation.TRUE);
    }
}

