/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTruncatesResiduals {
    public <T> void assertResidualValue(PartitionSpec spec, UnboundPredicate<?> predicate, T partitionValue, Expression.Operation expectedOp) {
        ResidualEvaluator resEval = ResidualEvaluator.of((PartitionSpec)spec, predicate, (boolean)true);
        Expression residual = resEval.residualFor((StructLike)TestHelpers.Row.of(partitionValue));
        Assertions.assertThat((Comparable)residual.op()).isEqualTo((Object)expectedOp);
    }

    public <T> void assertResidualPredicate(PartitionSpec spec, UnboundPredicate<?> predicate, T partitionValue) {
        ResidualEvaluator resEval = ResidualEvaluator.of((PartitionSpec)spec, predicate, (boolean)true);
        Expression residual = resEval.residualFor((StructLike)TestHelpers.Row.of(partitionValue));
        UnboundPredicate unbound = TestHelpers.assertAndUnwrapUnbound(residual);
        Assertions.assertThat((Comparable)unbound.op()).isEqualTo((Object)predicate.op());
        Assertions.assertThat((String)unbound.ref().name()).isEqualTo(predicate.ref().name());
        Assertions.assertThat((Object)unbound.literal().value()).isEqualTo(predicate.literal().value());
    }

    @Test
    public void testIntegerTruncateTransformResiduals() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)50, (String)"value", (Type)Types.IntegerType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 10).build();
        this.assertResidualValue(spec, Expressions.lessThan((String)"value", (Object)100), 110, Expression.Operation.FALSE);
        this.assertResidualValue(spec, Expressions.lessThan((String)"value", (Object)100), 100, Expression.Operation.FALSE);
        this.assertResidualValue(spec, Expressions.lessThan((String)"value", (Object)100), 90, Expression.Operation.TRUE);
        this.assertResidualValue(spec, Expressions.lessThan((String)"value", (Object)99), 100, Expression.Operation.FALSE);
        this.assertResidualPredicate(spec, Expressions.lessThan((String)"value", (Object)99), 90);
        this.assertResidualValue(spec, Expressions.lessThan((String)"value", (Object)99), 80, Expression.Operation.TRUE);
        this.assertResidualValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)100), 110, Expression.Operation.FALSE);
        this.assertResidualPredicate(spec, Expressions.lessThanOrEqual((String)"value", (Object)100), 100);
        this.assertResidualValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)100), 90, Expression.Operation.TRUE);
        this.assertResidualValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)99), 100, Expression.Operation.FALSE);
        this.assertResidualValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)99), 90, Expression.Operation.TRUE);
        this.assertResidualValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)99), 80, Expression.Operation.TRUE);
        this.assertResidualValue(spec, Expressions.greaterThan((String)"value", (Object)100), 110, Expression.Operation.TRUE);
        this.assertResidualPredicate(spec, Expressions.greaterThan((String)"value", (Object)100), 100);
        this.assertResidualValue(spec, Expressions.greaterThan((String)"value", (Object)100), 90, Expression.Operation.FALSE);
        this.assertResidualValue(spec, Expressions.greaterThan((String)"value", (Object)99), 100, Expression.Operation.TRUE);
        this.assertResidualValue(spec, Expressions.greaterThan((String)"value", (Object)99), 90, Expression.Operation.FALSE);
        this.assertResidualValue(spec, Expressions.greaterThan((String)"value", (Object)99), 80, Expression.Operation.FALSE);
        this.assertResidualValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)100), 110, Expression.Operation.TRUE);
        this.assertResidualValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)100), 100, Expression.Operation.TRUE);
        this.assertResidualValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)100), 90, Expression.Operation.FALSE);
        this.assertResidualValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)99), 100, Expression.Operation.TRUE);
        this.assertResidualPredicate(spec, Expressions.greaterThanOrEqual((String)"value", (Object)99), 90);
        this.assertResidualValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)99), 80, Expression.Operation.FALSE);
        this.assertResidualValue(spec, Expressions.equal((String)"value", (Object)100), 110, Expression.Operation.FALSE);
        this.assertResidualPredicate(spec, Expressions.equal((String)"value", (Object)100), 100);
        this.assertResidualValue(spec, Expressions.equal((String)"value", (Object)100), 90, Expression.Operation.FALSE);
        this.assertResidualValue(spec, Expressions.equal((String)"value", (Object)99), 100, Expression.Operation.FALSE);
        this.assertResidualPredicate(spec, Expressions.equal((String)"value", (Object)99), 90);
        this.assertResidualValue(spec, Expressions.equal((String)"value", (Object)99), 80, Expression.Operation.FALSE);
        this.assertResidualValue(spec, Expressions.notEqual((String)"value", (Object)100), 110, Expression.Operation.TRUE);
        this.assertResidualPredicate(spec, Expressions.notEqual((String)"value", (Object)100), 100);
        this.assertResidualValue(spec, Expressions.notEqual((String)"value", (Object)100), 90, Expression.Operation.TRUE);
        this.assertResidualValue(spec, Expressions.notEqual((String)"value", (Object)99), 100, Expression.Operation.TRUE);
        this.assertResidualPredicate(spec, Expressions.notEqual((String)"value", (Object)99), 90);
        this.assertResidualValue(spec, Expressions.notEqual((String)"value", (Object)99), 80, Expression.Operation.TRUE);
    }

    @Test
    public void testStringTruncateTransformResiduals() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)50, (String)"value", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).truncate("value", 2).build();
        this.assertResidualValue(spec, Expressions.lessThan((String)"value", (Object)"bcd"), "ab", Expression.Operation.TRUE);
        this.assertResidualPredicate(spec, Expressions.lessThan((String)"value", (Object)"bcd"), "bc");
        this.assertResidualValue(spec, Expressions.lessThan((String)"value", (Object)"bcd"), "cd", Expression.Operation.FALSE);
        this.assertResidualValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)"bcd"), "ab", Expression.Operation.TRUE);
        this.assertResidualPredicate(spec, Expressions.lessThanOrEqual((String)"value", (Object)"bcd"), "bc");
        this.assertResidualValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)"bcd"), "cd", Expression.Operation.FALSE);
        this.assertResidualValue(spec, Expressions.greaterThan((String)"value", (Object)"bcd"), "ab", Expression.Operation.FALSE);
        this.assertResidualPredicate(spec, Expressions.greaterThan((String)"value", (Object)"bcd"), "bc");
        this.assertResidualValue(spec, Expressions.greaterThan((String)"value", (Object)"bcd"), "cd", Expression.Operation.TRUE);
        this.assertResidualValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)"bcd"), "ab", Expression.Operation.FALSE);
        this.assertResidualPredicate(spec, Expressions.greaterThanOrEqual((String)"value", (Object)"bcd"), "bc");
        this.assertResidualValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)"bcd"), "cd", Expression.Operation.TRUE);
        this.assertResidualValue(spec, Expressions.equal((String)"value", (Object)"bcd"), "ab", Expression.Operation.FALSE);
        this.assertResidualPredicate(spec, Expressions.equal((String)"value", (Object)"bcd"), "bc");
        this.assertResidualValue(spec, Expressions.equal((String)"value", (Object)"bcd"), "cd", Expression.Operation.FALSE);
        this.assertResidualValue(spec, Expressions.notEqual((String)"value", (Object)"bcd"), "ab", Expression.Operation.TRUE);
        this.assertResidualPredicate(spec, Expressions.notEqual((String)"value", (Object)"bcd"), "bc");
        this.assertResidualValue(spec, Expressions.notEqual((String)"value", (Object)"bcd"), "cd", Expression.Operation.TRUE);
        this.assertResidualValue(spec, Expressions.startsWith((String)"value", (String)"bcd"), "ab", Expression.Operation.FALSE);
        this.assertResidualPredicate(spec, Expressions.startsWith((String)"value", (String)"bcd"), "bc");
        this.assertResidualValue(spec, Expressions.startsWith((String)"value", (String)"bcd"), "cd", Expression.Operation.FALSE);
        this.assertResidualPredicate(spec, Expressions.startsWith((String)"value", (String)"bcd"), "bcdd");
        this.assertResidualValue(spec, Expressions.notStartsWith((String)"value", (String)"bcd"), "ab", Expression.Operation.TRUE);
        this.assertResidualPredicate(spec, Expressions.notStartsWith((String)"value", (String)"bcd"), "bc");
        this.assertResidualValue(spec, Expressions.notStartsWith((String)"value", (String)"bcd"), "cd", Expression.Operation.TRUE);
        this.assertResidualPredicate(spec, Expressions.notStartsWith((String)"value", (String)"bcd"), "bcd");
        this.assertResidualPredicate(spec, Expressions.notStartsWith((String)"value", (String)"bcd"), "bcdd");
    }
}

