/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestComparators {
    private <T> void assertComparesCorrectly(Comparator<T> cmp, T less, T greater) {
        Assertions.assertThat((int)cmp.compare(greater, greater)).isZero();
        Assertions.assertThat((int)cmp.compare(less, less)).isZero();
        Assertions.assertThat((int)Integer.signum(cmp.compare(less, greater))).isEqualTo(-1);
        Assertions.assertThat((int)Integer.signum(cmp.compare(greater, less))).isOne();
    }

    @Test
    public void testBoolean() {
        this.assertComparesCorrectly(Comparators.forType((Type.PrimitiveType)Types.BooleanType.get()), false, true);
    }

    @Test
    public void testInt() {
        this.assertComparesCorrectly(Comparators.forType((Type.PrimitiveType)Types.IntegerType.get()), 0, 1);
    }

    @Test
    public void testLong() {
        this.assertComparesCorrectly(Comparators.forType((Type.PrimitiveType)Types.LongType.get()), 0L, 1L);
    }

    @Test
    public void testFloat() {
        this.assertComparesCorrectly(Comparators.forType((Type.PrimitiveType)Types.FloatType.get()), Float.valueOf(0.1f), Float.valueOf(0.2f));
    }

    @Test
    public void testDouble() {
        this.assertComparesCorrectly(Comparators.forType((Type.PrimitiveType)Types.DoubleType.get()), 0.1, 0.2);
    }

    @Test
    public void testDate() {
        this.assertComparesCorrectly(Comparators.forType((Type.PrimitiveType)Types.DateType.get()), 111, 222);
    }

    @Test
    public void testTime() {
        this.assertComparesCorrectly(Comparators.forType((Type.PrimitiveType)Types.TimeType.get()), 111, 222);
    }

    @Test
    public void testTimestamp() {
        this.assertComparesCorrectly(Comparators.forType((Type.PrimitiveType)Types.TimestampType.withoutZone()), 111, 222);
        this.assertComparesCorrectly(Comparators.forType((Type.PrimitiveType)Types.TimestampType.withZone()), 111, 222);
    }

    @Test
    public void testTimestampNanos() {
        this.assertComparesCorrectly(Comparators.forType((Type.PrimitiveType)Types.TimestampNanoType.withoutZone()), 111, 222);
        this.assertComparesCorrectly(Comparators.forType((Type.PrimitiveType)Types.TimestampNanoType.withZone()), 111, 222);
    }

    @Test
    public void testString() {
        this.assertComparesCorrectly(Comparators.forType((Type.PrimitiveType)Types.StringType.get()), "a", "b");
    }

    @Test
    public void testUuid() {
        this.assertComparesCorrectly(Comparators.forType((Type.PrimitiveType)Types.UUIDType.get()), UUID.fromString("81873e7d-1374-4493-8e1d-9095eff7046c"), UUID.fromString("fd02441d-1423-4a3f-8785-c7dd5647e26b"));
    }

    @Test
    public void testFixed() {
        this.assertComparesCorrectly(Comparators.forType((Type.PrimitiveType)Types.FixedType.ofLength((int)3)), ByteBuffer.wrap(new byte[]{1, 1, 3}), ByteBuffer.wrap(new byte[]{1, 2, 1}));
    }

    @Test
    public void testBinary() {
        this.assertComparesCorrectly(Comparators.forType((Type.PrimitiveType)Types.BinaryType.get()), ByteBuffer.wrap(new byte[]{1, 1}), ByteBuffer.wrap(new byte[]{1, 1, 1}));
    }

    @Test
    public void testDecimal() {
        this.assertComparesCorrectly(Comparators.forType((Type.PrimitiveType)Types.DecimalType.of((int)5, (int)7)), BigDecimal.valueOf(0.1), BigDecimal.valueOf(0.2));
    }

    @Test
    public void testList() {
        this.assertComparesCorrectly(Comparators.forType((Types.ListType)Types.ListType.ofRequired((int)18, (Type)Types.IntegerType.get())), ImmutableList.of((Object)1, (Object)1, (Object)1), ImmutableList.of((Object)1, (Object)1, (Object)2));
        this.assertComparesCorrectly(Comparators.forType((Types.ListType)Types.ListType.ofRequired((int)18, (Type)Types.IntegerType.get())), ImmutableList.of((Object)1, (Object)1), ImmutableList.of((Object)1, (Object)1, (Object)1));
        this.assertComparesCorrectly(Comparators.forType((Types.ListType)Types.ListType.ofOptional((int)18, (Type)Types.IntegerType.get())), Collections.singletonList(null), Collections.singletonList(1));
    }

    @Test
    public void testStruct() {
        this.assertComparesCorrectly(Comparators.forType((Types.StructType)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)18, (String)"str19", (Type)Types.StringType.get()), Types.NestedField.required((int)19, (String)"int19", (Type)Types.IntegerType.get())})), TestHelpers.Row.of("a", 1), TestHelpers.Row.of("a", 2));
        this.assertComparesCorrectly(Comparators.forType((Types.StructType)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)18, (String)"str19", (Type)Types.StringType.get())})), TestHelpers.Row.of(new Object[]{null}), TestHelpers.Row.of("a"));
    }
}

