/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import org.apache.iceberg.Schema;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestSerializableTypes {
    @Test
    public void testIdentityTypes() throws Exception {
        Type[] identityPrimitives;
        for (Type type : identityPrimitives = new Type[]{Types.BooleanType.get(), Types.IntegerType.get(), Types.LongType.get(), Types.FloatType.get(), Types.DoubleType.get(), Types.DateType.get(), Types.TimeType.get(), Types.TimestampType.withoutZone(), Types.TimestampType.withZone(), Types.TimestampNanoType.withoutZone(), Types.TimestampNanoType.withZone(), Types.StringType.get(), Types.UUIDType.get(), Types.BinaryType.get()}) {
            ((ObjectAssert)Assertions.assertThat((Object)TestHelpers.roundTripSerialize(type)).as("Serialization result should be identical to starting type", new Object[0])).isSameAs((Object)type);
        }
    }

    @Test
    public void testEqualTypes() throws Exception {
        Type[] equalityPrimitives;
        for (Type type : equalityPrimitives = new Type[]{Types.DecimalType.of((int)9, (int)3), Types.DecimalType.of((int)11, (int)0), Types.FixedType.ofLength((int)4), Types.FixedType.ofLength((int)34)}) {
            ((ObjectAssert)Assertions.assertThat((Object)TestHelpers.roundTripSerialize(type)).as("Serialization result should be equal to starting type", new Object[0])).isEqualTo((Object)type);
        }
    }

    @Test
    public void testStructs() throws Exception {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)34, (String)"Name!", (Type)Types.StringType.get()), Types.NestedField.optional((int)35, (String)"col", (Type)Types.DecimalType.of((int)38, (int)2))});
        Type copy = (Type)TestHelpers.roundTripSerialize(struct);
        ((ObjectAssert)Assertions.assertThat((Object)copy).as("Struct serialization should be equal to starting type", new Object[0])).isEqualTo((Object)struct);
        Type stringType = copy.asNestedType().asStructType().fieldType("Name!");
        ((ObjectAssert)Assertions.assertThat((Object)stringType).as("Struct serialization should preserve identity type", new Object[0])).isSameAs((Object)Types.StringType.get());
        Type decimalType = copy.asNestedType().asStructType().field(35).type();
        ((ObjectAssert)Assertions.assertThat((Object)decimalType).as("Struct serialization should support id lookup", new Object[0])).isEqualTo((Object)Types.DecimalType.of((int)38, (int)2));
    }

    @Test
    public void testMaps() throws Exception {
        Type[] maps;
        for (Type map : maps = new Type[]{Types.MapType.ofOptional((int)1, (int)2, (Type)Types.StringType.get(), (Type)Types.LongType.get()), Types.MapType.ofRequired((int)4, (int)5, (Type)Types.StringType.get(), (Type)Types.LongType.get())}) {
            Type copy = TestHelpers.roundTripSerialize(map);
            ((ObjectAssert)Assertions.assertThat((Object)copy).as("Map serialization should be equal to starting type", new Object[0])).isEqualTo((Object)map);
            ((ObjectAssert)Assertions.assertThat((Object)map.asNestedType().asMapType().valueType()).as("Map serialization should preserve identity type", new Object[0])).isSameAs((Object)Types.LongType.get());
        }
    }

    @Test
    public void testLists() throws Exception {
        Type[] lists;
        for (Type list : lists = new Type[]{Types.ListType.ofOptional((int)2, (Type)Types.DoubleType.get()), Types.ListType.ofRequired((int)5, (Type)Types.DoubleType.get())}) {
            Type copy = TestHelpers.roundTripSerialize(list);
            ((ObjectAssert)Assertions.assertThat((Object)copy).as("List serialization should be equal to starting type", new Object[0])).isEqualTo((Object)list);
            ((ObjectAssert)Assertions.assertThat((Object)list.asNestedType().asListType().elementType()).as("List serialization should preserve identity type", new Object[0])).isSameAs((Object)Types.DoubleType.get());
        }
    }

    @Test
    public void testSchema() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"preferences", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)8, (String)"feature1", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)9, (String)"feature2", (Type)Types.BooleanType.get())})), Types.NestedField.required((int)4, (String)"locations", (Type)Types.MapType.ofRequired((int)10, (int)11, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)13, (String)"long", (Type)Types.FloatType.get())}))), Types.NestedField.optional((int)5, (String)"points", (Type)Types.ListType.ofOptional((int)14, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"x", (Type)Types.LongType.get()), Types.NestedField.required((int)16, (String)"y", (Type)Types.LongType.get())}))), Types.NestedField.required((int)6, (String)"doubles", (Type)Types.ListType.ofRequired((int)17, (Type)Types.DoubleType.get())), Types.NestedField.optional((int)7, (String)"properties", (Type)Types.MapType.ofOptional((int)18, (int)19, (Type)Types.StringType.get(), (Type)Types.StringType.get())), Types.NestedField.required((int)20, (String)"complex_key_map", (Type)Types.MapType.ofOptional((int)21, (int)22, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)23, (String)"x", (Type)Types.LongType.get()), Types.NestedField.optional((int)24, (String)"y", (Type)Types.LongType.get())}), (Type)Types.StringType.get()))});
        ((ObjectAssert)Assertions.assertThat((Object)TestHelpers.roundTripSerialize(schema).asStruct()).as("Schema serialization should be equal to starting schema", new Object[0])).isEqualTo((Object)schema.asStruct());
    }
}

