/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.CharSequenceWrapper;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCharSequenceSet {
    @Test
    public void testSearchingInCharSequenceCollection() {
        CharSequenceSet set = CharSequenceSet.of(Arrays.asList("abc", new StringBuffer("def")));
        Assertions.assertThat((Collection)set).contains((Object[])new CharSequence[]{"abc"});
        Assertions.assertThat((boolean)set.stream().anyMatch("def"::contains)).isTrue();
        Assertions.assertThat((boolean)set.contains("def")).isTrue();
    }

    @Test
    public void nullString() {
        Assertions.assertThat((Collection)CharSequenceSet.of(Arrays.asList(new CharSequence[]{null}))).contains((Object[])new CharSequence[]{null});
        Assertions.assertThat((Collection)CharSequenceSet.empty()).doesNotContain((Object[])new CharSequence[]{null});
    }

    @Test
    public void testRetainAll() {
        CharSequenceSet set = CharSequenceSet.of((Iterable)ImmutableList.of((Object)"123", (Object)"456"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)set.retainAll((Collection)ImmutableList.of((Object)"456", (Object)"789", (Object)123))).overridingErrorMessage("Set should be changed", new Object[0])).isTrue();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)set).hasSize(1)).contains((Object[])new CharSequence[]{"456"});
        set = CharSequenceSet.of((Iterable)ImmutableList.of((Object)"123", (Object)"456"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)set.retainAll((Collection)ImmutableList.of((Object)"123", (Object)"456"))).overridingErrorMessage("Set should not be changed", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)set.retainAll((Collection)ImmutableList.of((Object)123, (Object)456))).overridingErrorMessage("Set should be changed", new Object[0])).isTrue();
        Assertions.assertThat((Collection)set).isEmpty();
    }

    @Test
    public void testRemoveAll() {
        CharSequenceSet set = CharSequenceSet.of((Iterable)ImmutableList.of((Object)"123", (Object)"456"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)set.removeAll((Collection)ImmutableList.of((Object)"456", (Object)"789", (Object)123))).overridingErrorMessage("Set should be changed", new Object[0])).isTrue();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)set).hasSize(1)).contains((Object[])new CharSequence[]{"123"});
        set = CharSequenceSet.of((Iterable)ImmutableList.of((Object)"123", (Object)"456"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)set.removeAll((Collection)ImmutableList.of((Object)123, (Object)456))).overridingErrorMessage("Set should not be changed", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)set.removeAll((Collection)ImmutableList.of((Object)"123", (Object)"456"))).overridingErrorMessage("Set should be changed", new Object[0])).isTrue();
        Assertions.assertThat((Collection)set).isEmpty();
    }

    @Test
    public void testEqualsAndHashCode() {
        CharSequenceSet set1 = CharSequenceSet.empty();
        CharSequenceSet set2 = CharSequenceSet.empty();
        Assertions.assertThat((Collection)set1).isEqualTo((Object)set2);
        Assertions.assertThat((int)set1.hashCode()).isEqualTo(set2.hashCode());
        set1.add((CharSequence)"v1");
        set1.add((CharSequence)"v2");
        set1.add((CharSequence)"v3");
        set2.add((CharSequence)new StringBuilder("v1"));
        set2.add((CharSequence)new StringBuffer("v2"));
        set2.add((CharSequence)"v3");
        Set set3 = Collections.unmodifiableSet(set2);
        ImmutableSet set4 = ImmutableSet.of((Object)CharSequenceWrapper.wrap((CharSequence)"v1"), (Object)CharSequenceWrapper.wrap((CharSequence)new StringBuffer("v2")), (Object)CharSequenceWrapper.wrap((CharSequence)new StringBuffer("v3")));
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)set1).isEqualTo((Object)set2)).isEqualTo(set3)).isEqualTo((Object)set4);
        Assertions.assertThat((int)set1.hashCode()).isEqualTo(set2.hashCode()).isEqualTo(set3.hashCode()).isEqualTo(set4.hashCode());
    }
}

