/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Objects;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.util.WrapperSet;

public class DeleteFileSet
extends WrapperSet<DeleteFile> {
    private static final ThreadLocal<DeleteFileWrapper> WRAPPERS = ThreadLocal.withInitial(() -> DeleteFileWrapper.wrap(null));

    private DeleteFileSet() {
    }

    private DeleteFileSet(Iterable<WrapperSet.Wrapper<DeleteFile>> wrappers) {
        super(wrappers);
    }

    public static DeleteFileSet create() {
        return new DeleteFileSet();
    }

    public static DeleteFileSet of(Iterable<? extends DeleteFile> iterable) {
        return new DeleteFileSet(Iterables.transform(iterable, obj -> {
            Preconditions.checkNotNull((Object)obj, (Object)"Invalid object: null");
            return DeleteFileWrapper.wrap(obj);
        }));
    }

    @Override
    protected WrapperSet.Wrapper<DeleteFile> wrapper() {
        return WRAPPERS.get();
    }

    @Override
    protected WrapperSet.Wrapper<DeleteFile> wrap(DeleteFile deleteFile) {
        return DeleteFileWrapper.wrap(deleteFile);
    }

    @Override
    protected Class<DeleteFile> elementClass() {
        return DeleteFile.class;
    }

    private static class DeleteFileWrapper
    implements WrapperSet.Wrapper<DeleteFile> {
        private DeleteFile file;

        private DeleteFileWrapper(DeleteFile file) {
            this.file = file;
        }

        private static DeleteFileWrapper wrap(DeleteFile deleteFile) {
            return new DeleteFileWrapper(deleteFile);
        }

        @Override
        public DeleteFile get() {
            return this.file;
        }

        @Override
        public WrapperSet.Wrapper<DeleteFile> set(DeleteFile deleteFile) {
            this.file = deleteFile;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeleteFileWrapper)) {
                return false;
            }
            DeleteFileWrapper that = (DeleteFileWrapper)o;
            return Objects.equals(this.file.location(), that.file.location());
        }

        public int hashCode() {
            return Objects.hashCode(this.file.location());
        }

        public String toString() {
            return this.file.location();
        }
    }
}

