/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.ClosureSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.UnboundPartitionSpec;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundSetPredicate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.ByteBuffers;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class TestHelpers {
    public static final int MAX_FORMAT_VERSION = 3;
    public static final int[] ALL_VERSIONS = IntStream.rangeClosed(1, 3).toArray();

    private TestHelpers() {
    }

    public static long waitUntilAfter(long timestampMillis) {
        long current = System.currentTimeMillis();
        while (current <= timestampMillis) {
            current = System.currentTimeMillis();
        }
        return current;
    }

    public static <T> T assertAndUnwrap(Expression expr, Class<T> expected) {
        ((ObjectAssert)Assertions.assertThat((Object)expr).as("Expression should have expected type: " + expected, new Object[0])).isInstanceOf(expected);
        return expected.cast(expr);
    }

    public static <T> BoundPredicate<T> assertAndUnwrap(Expression expr) {
        ((ObjectAssert)Assertions.assertThat((Object)expr).as("Expression should be a bound predicate: " + expr, new Object[0])).isInstanceOf(BoundPredicate.class);
        return (BoundPredicate)expr;
    }

    public static <T> BoundSetPredicate<T> assertAndUnwrapBoundSet(Expression expr) {
        ((ObjectAssert)Assertions.assertThat((Object)expr).as("Expression should be a bound set predicate: " + expr, new Object[0])).isInstanceOf(BoundSetPredicate.class);
        return (BoundSetPredicate)expr;
    }

    public static <T> UnboundPredicate<T> assertAndUnwrapUnbound(Expression expr) {
        ((ObjectAssert)Assertions.assertThat((Object)expr).as("Expression should be an unbound predicate: " + expr, new Object[0])).isInstanceOf(UnboundPredicate.class);
        return (UnboundPredicate)expr;
    }

    public static void assertAllReferencesBound(String message, Expression expr) {
        ExpressionVisitors.visit((Expression)expr, (ExpressionVisitors.ExpressionVisitor)new CheckReferencesBound(message));
    }

    public static <T> T roundTripSerialize(T type) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
            out.writeObject(type);
        }
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));){
            Object object = in.readObject();
            return (T)object;
        }
    }

    public static void assertSameSchemaList(List<Schema> list1, List<Schema> list2) {
        ((ListAssert)Assertions.assertThat(list1).as("Should have same number of schemas in both lists", new Object[0])).hasSameSizeAs(list2);
        IntStream.range(0, list1.size()).forEach(index -> {
            Schema schema1 = (Schema)list1.get(index);
            Schema schema2 = (Schema)list2.get(index);
            ((AbstractIntegerAssert)Assertions.assertThat((int)schema2.schemaId()).as("Should have matching schema id", new Object[0])).isEqualTo(schema1.schemaId());
            ((ObjectAssert)Assertions.assertThat((Object)schema2.asStruct()).as("Should have matching schema struct", new Object[0])).isEqualTo((Object)schema1.asStruct());
        });
    }

    public static void assertSerializedMetadata(Table expected, Table actual) {
        ((AbstractStringAssert)Assertions.assertThat((String)actual.name()).as("Name must match", new Object[0])).isEqualTo(expected.name());
        ((AbstractStringAssert)Assertions.assertThat((String)actual.location()).as("Location must match", new Object[0])).isEqualTo(expected.location());
        ((MapAssert)Assertions.assertThat((Map)actual.properties()).as("Props must match", new Object[0])).isEqualTo((Object)expected.properties());
        ((ObjectAssert)Assertions.assertThat((Object)actual.schema().asStruct()).as("Schema must match", new Object[0])).isEqualTo((Object)expected.schema().asStruct());
        ((ObjectAssert)Assertions.assertThat((Object)actual.spec()).as("Spec must match", new Object[0])).isEqualTo((Object)expected.spec());
        ((ObjectAssert)Assertions.assertThat((Object)actual.sortOrder()).as("Sort order must match", new Object[0])).isEqualTo((Object)expected.sortOrder());
    }

    public static void assertSerializedAndLoadedMetadata(Table expected, Table actual) {
        TestHelpers.assertSerializedMetadata(expected, actual);
        ((MapAssert)Assertions.assertThat((Map)actual.specs()).as("Specs must match", new Object[0])).isEqualTo((Object)expected.specs());
        ((MapAssert)Assertions.assertThat((Map)actual.sortOrders()).as("Sort orders must match", new Object[0])).isEqualTo((Object)expected.sortOrders());
        ((ObjectAssert)Assertions.assertThat((Object)actual.currentSnapshot()).as("Current snapshot must match", new Object[0])).isEqualTo((Object)expected.currentSnapshot());
        ((IterableAssert)Assertions.assertThat((Iterable)actual.snapshots()).as("Snapshots must match", new Object[0])).isEqualTo((Object)expected.snapshots());
        ((ListAssert)Assertions.assertThat((List)actual.history()).as("History must match", new Object[0])).isEqualTo((Object)expected.history());
    }

    public static void assertSameSchemaMap(Map<Integer, Schema> map1, Map<Integer, Schema> map2) {
        ((MapAssert)Assertions.assertThat(map1).as("Should have same number of schemas in both maps", new Object[0])).hasSameSizeAs(map2);
        map1.forEach((schemaId, schema1) -> {
            Schema schema2 = (Schema)map2.get(schemaId);
            ((ObjectAssert)Assertions.assertThat((Object)schema2).as(String.format("Schema ID %s does not exist in map: %s", schemaId, map2), new Object[0])).isNotNull();
            ((AbstractIntegerAssert)Assertions.assertThat((int)schema2.schemaId()).as("Should have matching schema id", new Object[0])).isEqualTo(schema1.schemaId());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)schema1.sameSchema(schema2)).as(String.format("Should be the same schema. Schema 1: %s, schema 2: %s", schema1, schema2), new Object[0])).isTrue();
        });
    }

    public static <T> T deserialize(byte[] objectData) throws IOException, ClassNotFoundException {
        Preconditions.checkNotNull((Object)objectData, (Object)"objectData");
        return TestHelpers.deserialize(new ByteArrayInputStream(objectData));
    }

    public static <T> T deserialize(InputStream inputStream) throws IOException, ClassNotFoundException {
        Preconditions.checkNotNull((Object)inputStream, (Object)"inputStream");
        try (ObjectInputStream in = new ObjectInputStream(inputStream);){
            Object obj;
            Object object = obj = in.readObject();
            return (T)object;
        }
    }

    public static byte[] serialize(Serializable obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        TestHelpers.serialize(obj, baos);
        return baos.toByteArray();
    }

    public static void serialize(Serializable obj, OutputStream outputStream) throws IOException {
        Preconditions.checkNotNull((Object)outputStream, (Object)"outputStream");
        try (ObjectOutputStream out = new ObjectOutputStream(outputStream);){
            out.writeObject(obj);
        }
    }

    public static ExpectedSpecBuilder newExpectedSpecBuilder() {
        return new ExpectedSpecBuilder();
    }

    public static class ExpectedSpecBuilder {
        private final UnboundPartitionSpec.Builder unboundPartitionSpecBuilder = UnboundPartitionSpec.builder();
        private Schema schema;

        private ExpectedSpecBuilder() {
        }

        public ExpectedSpecBuilder withSchema(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        public ExpectedSpecBuilder withSpecId(int newSpecId) {
            this.unboundPartitionSpecBuilder.withSpecId(newSpecId);
            return this;
        }

        public ExpectedSpecBuilder addField(String transformAsString, int sourceId, int partitionId, String name) {
            this.unboundPartitionSpecBuilder.addField(transformAsString, sourceId, partitionId, name);
            return this;
        }

        public ExpectedSpecBuilder addField(String transformAsString, int sourceId, String name) {
            this.unboundPartitionSpecBuilder.addField(transformAsString, sourceId, name);
            return this;
        }

        public PartitionSpec build() {
            Preconditions.checkNotNull((Object)this.schema, (Object)"Field schema is missing");
            return this.unboundPartitionSpecBuilder.build().bind(this.schema);
        }
    }

    public static class TestDataFile
    implements DataFile {
        private final String path;
        private final StructLike partition;
        private final long recordCount;
        private final Map<Integer, Long> valueCounts;
        private final Map<Integer, Long> nullValueCounts;
        private final Map<Integer, Long> nanValueCounts;
        private final Map<Integer, ByteBuffer> lowerBounds;
        private final Map<Integer, ByteBuffer> upperBounds;

        public TestDataFile(String path, StructLike partition, long recordCount) {
            this(path, partition, recordCount, null, null, null, null, null);
        }

        public TestDataFile(String path, StructLike partition, long recordCount, Map<Integer, Long> valueCounts, Map<Integer, Long> nullValueCounts, Map<Integer, Long> nanValueCounts, Map<Integer, ByteBuffer> lowerBounds, Map<Integer, ByteBuffer> upperBounds) {
            this.path = path;
            this.partition = partition;
            this.recordCount = recordCount;
            this.valueCounts = valueCounts;
            this.nullValueCounts = nullValueCounts;
            this.nanValueCounts = nanValueCounts;
            this.lowerBounds = lowerBounds;
            this.upperBounds = upperBounds;
        }

        public Long pos() {
            return null;
        }

        public int specId() {
            return 0;
        }

        public CharSequence path() {
            return this.path;
        }

        public FileFormat format() {
            return FileFormat.fromFileName((CharSequence)this.location());
        }

        public StructLike partition() {
            return this.partition;
        }

        public long recordCount() {
            return this.recordCount;
        }

        public long fileSizeInBytes() {
            return 0L;
        }

        public Map<Integer, Long> columnSizes() {
            return null;
        }

        public Map<Integer, Long> valueCounts() {
            return this.valueCounts;
        }

        public Map<Integer, Long> nullValueCounts() {
            return this.nullValueCounts;
        }

        public Map<Integer, Long> nanValueCounts() {
            return this.nanValueCounts;
        }

        public Map<Integer, ByteBuffer> lowerBounds() {
            return this.lowerBounds;
        }

        public Map<Integer, ByteBuffer> upperBounds() {
            return this.upperBounds;
        }

        public ByteBuffer keyMetadata() {
            return null;
        }

        public DataFile copy() {
            return this;
        }

        public DataFile copyWithoutStats() {
            return this;
        }

        public DataFile copyWithStats(Set<Integer> requestedColumns) {
            return this;
        }

        public List<Long> splitOffsets() {
            return null;
        }
    }

    public static class TestManifestFile
    implements ManifestFile {
        private final String path;
        private final long length;
        private final int specId;
        private final ManifestContent content;
        private final Long snapshotId;
        private final Integer addedFiles;
        private final Long addedRows;
        private final Integer existingFiles;
        private final Long existingRows;
        private final Integer deletedFiles;
        private final Long deletedRows;
        private final List<ManifestFile.PartitionFieldSummary> partitions;
        private final byte[] keyMetadata;

        public TestManifestFile(String path, long length, int specId, Long snapshotId, Integer addedFiles, Integer existingFiles, Integer deletedFiles, List<ManifestFile.PartitionFieldSummary> partitions, ByteBuffer keyMetadata) {
            this.path = path;
            this.length = length;
            this.specId = specId;
            this.content = ManifestContent.DATA;
            this.snapshotId = snapshotId;
            this.addedFiles = addedFiles;
            this.addedRows = null;
            this.existingFiles = existingFiles;
            this.existingRows = null;
            this.deletedFiles = deletedFiles;
            this.deletedRows = null;
            this.partitions = partitions;
            this.keyMetadata = ByteBuffers.toByteArray((ByteBuffer)keyMetadata);
        }

        public TestManifestFile(String path, long length, int specId, ManifestContent content, Long snapshotId, Integer addedFiles, Long addedRows, Integer existingFiles, Long existingRows, Integer deletedFiles, Long deletedRows, List<ManifestFile.PartitionFieldSummary> partitions, ByteBuffer keyMetadata) {
            this.path = path;
            this.length = length;
            this.specId = specId;
            this.content = content;
            this.snapshotId = snapshotId;
            this.addedFiles = addedFiles;
            this.addedRows = addedRows;
            this.existingFiles = existingFiles;
            this.existingRows = existingRows;
            this.deletedFiles = deletedFiles;
            this.deletedRows = deletedRows;
            this.partitions = partitions;
            this.keyMetadata = ByteBuffers.toByteArray((ByteBuffer)keyMetadata);
        }

        public String path() {
            return this.path;
        }

        public long length() {
            return this.length;
        }

        public int partitionSpecId() {
            return this.specId;
        }

        public ManifestContent content() {
            return this.content;
        }

        public long sequenceNumber() {
            return 0L;
        }

        public long minSequenceNumber() {
            return 0L;
        }

        public Long snapshotId() {
            return this.snapshotId;
        }

        public Integer addedFilesCount() {
            return this.addedFiles;
        }

        public Long addedRowsCount() {
            return this.addedRows;
        }

        public Integer existingFilesCount() {
            return this.existingFiles;
        }

        public Long existingRowsCount() {
            return this.existingRows;
        }

        public Integer deletedFilesCount() {
            return this.deletedFiles;
        }

        public Long deletedRowsCount() {
            return this.deletedRows;
        }

        public List<ManifestFile.PartitionFieldSummary> partitions() {
            return this.partitions;
        }

        public ByteBuffer keyMetadata() {
            return this.keyMetadata == null ? null : ByteBuffer.wrap(this.keyMetadata);
        }

        public ManifestFile copy() {
            return this;
        }
    }

    public static class TestFieldSummary
    implements ManifestFile.PartitionFieldSummary {
        private final boolean containsNull;
        private final Boolean containsNaN;
        private final ByteBuffer lowerBound;
        private final ByteBuffer upperBound;

        public TestFieldSummary(boolean containsNull, ByteBuffer lowerBound, ByteBuffer upperBound) {
            this(containsNull, null, lowerBound, upperBound);
        }

        public TestFieldSummary(boolean containsNull, Boolean containsNaN, ByteBuffer lowerBound, ByteBuffer upperBound) {
            this.containsNull = containsNull;
            this.containsNaN = containsNaN;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public boolean containsNull() {
            return this.containsNull;
        }

        public Boolean containsNaN() {
            return this.containsNaN;
        }

        public ByteBuffer lowerBound() {
            return this.lowerBound;
        }

        public ByteBuffer upperBound() {
            return this.upperBound;
        }

        public ManifestFile.PartitionFieldSummary copy() {
            return this;
        }
    }

    public static class CustomRow
    implements StructLike {
        private final Object[] values;

        public static CustomRow of(Object ... values) {
            return new CustomRow(values);
        }

        private CustomRow(Object ... values) {
            this.values = values;
        }

        public int size() {
            return this.values.length;
        }

        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.values[pos]);
        }

        public <T> void set(int pos, T value) {
            this.values[pos] = value;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CustomRow that = (CustomRow)other;
            return Arrays.equals(this.values, that.values);
        }

        public int hashCode() {
            return 17 * Arrays.hashCode(this.values);
        }
    }

    public static class Row
    implements StructLike {
        private final Object[] values;

        public static Row of(Object ... values) {
            return new Row(values);
        }

        private Row(Object ... values) {
            this.values = values;
        }

        public int size() {
            return this.values.length;
        }

        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.values[pos]);
        }

        public <T> void set(int pos, T value) {
            this.values[pos] = value;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Row that = (Row)other;
            return Arrays.equals(this.values, that.values);
        }

        public int hashCode() {
            return Arrays.hashCode(this.values);
        }
    }

    private static class CheckReferencesBound
    extends ExpressionVisitors.ExpressionVisitor<Void> {
        private final String message;

        CheckReferencesBound(String message) {
            this.message = message;
        }

        public <T> Void predicate(UnboundPredicate<T> pred) {
            Assertions.fail((String)(this.message + ": Found unbound predicate: " + pred));
            return null;
        }
    }

    public static class KryoHelpers {
        private KryoHelpers() {
        }

        public static <T> T roundTripSerialize(T obj) throws IOException {
            Kryo kryo = new Kryo();
            kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
            kryo.register(SerializedLambda.class);
            kryo.register(ClosureSerializer.Closure.class, (Serializer)new ClosureSerializer());
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try (Output out = new Output((OutputStream)new ObjectOutputStream(bytes));){
                kryo.writeClassAndObject(out, obj);
            }
            try (Input in = new Input((InputStream)new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray())));){
                Object object = kryo.readClassAndObject(in);
                return (T)object;
            }
        }
    }
}

