/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPartitionSpecValidation {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)3, (String)"another_ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)4, (String)"d", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)5, (String)"another_d", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)6, (String)"s", (Type)Types.StringType.get()), Types.NestedField.required((int)7, (String)"v", (Type)Types.VariantType.get()), Types.NestedField.required((int)8, (String)"u", (Type)Types.UnknownType.get())});

    @Test
    public void testMultipleTimestampPartitions() {
        Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).year("ts").year("ts").build()).hasMessageContaining("Cannot use partition name more than once").isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).year("ts").month("ts").build()).hasMessageContaining("Cannot add redundant partition").isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).year("ts").day("ts").build()).hasMessageContaining("Cannot add redundant partition").isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).year("ts").hour("ts").build()).hasMessageContaining("Cannot add redundant partition").isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).month("ts").month("ts").build()).hasMessageContaining("Cannot use partition name more than once").isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).month("ts").day("ts").build()).hasMessageContaining("Cannot add redundant partition").isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).month("ts").hour("ts").build()).hasMessageContaining("Cannot add redundant partition").isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).day("ts").day("ts").build()).hasMessageContaining("Cannot use partition name more than once").isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).day("ts").hour("ts").build()).hasMessageContaining("Cannot add redundant partition").isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).hour("ts").hour("ts").build()).hasMessageContaining("Cannot use partition name more than once").isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testMultipleDatePartitions() {
        Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).year("d").year("d").build()).hasMessageContaining("Cannot use partition name more than once").isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).year("d").month("d").build()).hasMessageContaining("Cannot add redundant partition").isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).year("d").day("d").build()).hasMessageContaining("Cannot add redundant partition").isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).month("d").month("d").build()).hasMessageContaining("Cannot use partition name more than once").isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).month("d").day("d").build()).hasMessageContaining("Cannot add redundant partition").isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).day("d").day("d").build()).hasMessageContaining("Cannot use partition name more than once").isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testMultipleTimestampPartitionsWithDifferentSourceColumns() {
        PartitionSpec.builderFor((Schema)SCHEMA).year("ts").year("another_ts").build();
        PartitionSpec.builderFor((Schema)SCHEMA).year("ts").month("another_ts").build();
        PartitionSpec.builderFor((Schema)SCHEMA).year("ts").day("another_ts").build();
        PartitionSpec.builderFor((Schema)SCHEMA).year("ts").hour("another_ts").build();
        PartitionSpec.builderFor((Schema)SCHEMA).month("ts").month("another_ts").build();
        PartitionSpec.builderFor((Schema)SCHEMA).month("ts").day("another_ts").build();
        PartitionSpec.builderFor((Schema)SCHEMA).month("ts").hour("another_ts").build();
        PartitionSpec.builderFor((Schema)SCHEMA).day("ts").day("another_ts").build();
        PartitionSpec.builderFor((Schema)SCHEMA).day("ts").hour("another_ts").build();
        PartitionSpec.builderFor((Schema)SCHEMA).hour("ts").hour("another_ts").build();
    }

    @Test
    public void testMultipleDatePartitionsWithDifferentSourceColumns() {
        PartitionSpec.builderFor((Schema)SCHEMA).year("d").year("another_d").build();
        PartitionSpec.builderFor((Schema)SCHEMA).year("d").month("another_d").build();
        PartitionSpec.builderFor((Schema)SCHEMA).year("d").day("another_d").build();
        PartitionSpec.builderFor((Schema)SCHEMA).year("d").hour("another_d").build();
        PartitionSpec.builderFor((Schema)SCHEMA).month("d").month("another_d").build();
        PartitionSpec.builderFor((Schema)SCHEMA).month("d").day("another_d").build();
        PartitionSpec.builderFor((Schema)SCHEMA).month("d").hour("another_d").build();
        PartitionSpec.builderFor((Schema)SCHEMA).day("d").day("another_d").build();
        PartitionSpec.builderFor((Schema)SCHEMA).day("d").hour("another_d").build();
        PartitionSpec.builderFor((Schema)SCHEMA).hour("d").hour("another_d").build();
    }

    @Test
    public void testMultipleIdentityPartitions() {
        PartitionSpec.builderFor((Schema)SCHEMA).year("d").identity("id").identity("d").identity("s").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).identity("id").identity("id").build()).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot use partition name more than once");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).identity("id").identity("id", "test-id").build()).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot add redundant partition");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).identity("id", "test-id").identity("d", "test-id").build()).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot use partition name more than once");
    }

    @Test
    public void testSettingPartitionTransformsWithCustomTargetNames() {
        Assertions.assertThat((String)((PartitionField)PartitionSpec.builderFor((Schema)SCHEMA).year("ts", "custom_year").build().fields().get(0)).name()).isEqualTo("custom_year");
        Assertions.assertThat((String)((PartitionField)PartitionSpec.builderFor((Schema)SCHEMA).month("ts", "custom_month").build().fields().get(0)).name()).isEqualTo("custom_month");
        Assertions.assertThat((String)((PartitionField)PartitionSpec.builderFor((Schema)SCHEMA).day("ts", "custom_day").build().fields().get(0)).name()).isEqualTo("custom_day");
        Assertions.assertThat((String)((PartitionField)PartitionSpec.builderFor((Schema)SCHEMA).hour("ts", "custom_hour").build().fields().get(0)).name()).isEqualTo("custom_hour");
        Assertions.assertThat((String)((PartitionField)PartitionSpec.builderFor((Schema)SCHEMA).bucket("ts", 4, "custom_bucket").build().fields().get(0)).name()).isEqualTo("custom_bucket");
        Assertions.assertThat((String)((PartitionField)PartitionSpec.builderFor((Schema)SCHEMA).truncate("s", 1, "custom_truncate").build().fields().get(0)).name()).isEqualTo("custom_truncate");
    }

    @Test
    public void testSettingPartitionTransformsWithCustomTargetNamesThatAlreadyExist() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).year("ts", "another_ts")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create partition from name that exists in schema: another_ts");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).month("ts", "another_ts")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create partition from name that exists in schema: another_ts");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).day("ts", "another_ts")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create partition from name that exists in schema: another_ts");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).hour("ts", "another_ts")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create partition from name that exists in schema: another_ts");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).truncate("ts", 2, "another_ts")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create partition from name that exists in schema: another_ts");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).bucket("ts", 4, "another_ts")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create partition from name that exists in schema: another_ts");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).identity("ts", "another_ts")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create identity partition sourced from different field in schema: another_ts");
    }

    @Test
    public void testMissingSourceColumn() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).year("missing").build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot find source column: missing");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).month("missing").build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot find source column: missing");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).day("missing").build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot find source column: missing");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).hour("missing").build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot find source column: missing");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).bucket("missing", 4).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot find source column: missing");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).truncate("missing", 5).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot find source column: missing");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).identity("missing").build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot find source column: missing");
    }

    @Test
    public void testAutoSettingPartitionFieldIds() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).year("ts", "custom_year").bucket("ts", 4, "custom_bucket").add(1, "id_partition2", Transforms.bucket((int)4)).truncate("s", 1, "custom_truncate").build();
        Assertions.assertThat((int)((PartitionField)spec.fields().get(0)).fieldId()).isEqualTo(1000);
        Assertions.assertThat((int)((PartitionField)spec.fields().get(1)).fieldId()).isEqualTo(1001);
        Assertions.assertThat((int)((PartitionField)spec.fields().get(2)).fieldId()).isEqualTo(1002);
        Assertions.assertThat((int)((PartitionField)spec.fields().get(3)).fieldId()).isEqualTo(1003);
        Assertions.assertThat((int)spec.lastAssignedFieldId()).isEqualTo(1003);
    }

    @Test
    public void testAddPartitionFieldsWithFieldIds() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).add(1, 1005, "id_partition1", Transforms.bucket((int)4)).add(1, 1006, "id_partition2", Transforms.bucket((int)5)).add(1, 1002, "id_partition3", Transforms.bucket((int)6)).build();
        Assertions.assertThat((int)((PartitionField)spec.fields().get(0)).fieldId()).isEqualTo(1005);
        Assertions.assertThat((int)((PartitionField)spec.fields().get(1)).fieldId()).isEqualTo(1006);
        Assertions.assertThat((int)((PartitionField)spec.fields().get(2)).fieldId()).isEqualTo(1002);
        Assertions.assertThat((int)spec.lastAssignedFieldId()).isEqualTo(1006);
    }

    @Test
    public void testAddPartitionFieldsWithAndWithoutFieldIds() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).add(1, "id_partition2", Transforms.bucket((int)5)).add(1, 1005, "id_partition1", Transforms.bucket((int)4)).truncate("s", 1, "custom_truncate").build();
        Assertions.assertThat((int)((PartitionField)spec.fields().get(0)).fieldId()).isEqualTo(1000);
        Assertions.assertThat((int)((PartitionField)spec.fields().get(1)).fieldId()).isEqualTo(1005);
        Assertions.assertThat((int)((PartitionField)spec.fields().get(2)).fieldId()).isEqualTo(1006);
        Assertions.assertThat((int)spec.lastAssignedFieldId()).isEqualTo(1006);
    }

    @Test
    public void testVariantUnsupported() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).add(7, 1005, "variant_partition1", Transforms.bucket((int)5)).build()).isInstanceOf(ValidationException.class)).hasMessage("Cannot partition by non-primitive source field: variant");
    }

    @Test
    public void testUnknownUnsupported() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PartitionSpec.builderFor((Schema)SCHEMA).add(8, 1005, "unknown_partition1", Transforms.bucket((int)5)).build()).isInstanceOf(ValidationException.class)).hasMessage("Invalid source type unknown for transform: bucket[5]");
    }
}

