/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEvaluator {
    private static final Types.StructType STRUCT = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.required((int)14, (String)"y", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)15, (String)"z", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)16, (String)"s1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)"s2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)18, (String)"s3", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)19, (String)"s4", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"i", (Type)Types.IntegerType.get())}))}))}))})), Types.NestedField.optional((int)21, (String)"s5", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)22, (String)"s6", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)23, (String)"f", (Type)Types.FloatType.get())}))}))});

    @Test
    public void testLessThan() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.lessThan((String)"x", (Object)7));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, null))).as("7 < 7 => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null, null))).as("6 < 7 => true", new Object[0])).isTrue();
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.lessThan((String)"s1.s2.s3.s4.i", (Object)7));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7))))))).as("7 < 7 => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(6))))))).as("6 < 7 => true", new Object[0])).isTrue();
    }

    @Test
    public void testLessThanOrEqual() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.lessThanOrEqual((String)"x", (Object)7));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null))).as("7 <= 7 => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null))).as("6 <= 7 => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8, 8, null))).as("8 <= 7 => false", new Object[0])).isFalse();
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.lessThanOrEqual((String)"s1.s2.s3.s4.i", (Object)7));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7))))))).as("7 <= 7 => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(6))))))).as("6 <= 7 => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(8))))))).as("8 <= 7 => false", new Object[0])).isFalse();
    }

    @Test
    public void testGreaterThan() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.greaterThan((String)"x", (Object)7));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null))).as("7 > 7 => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null))).as("6 > 7 => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8, 8, null))).as("8 > 7 => true", new Object[0])).isTrue();
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.greaterThan((String)"s1.s2.s3.s4.i", (Object)7));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7))))))).as("7 > 7 => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(6))))))).as("6 > 7 => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(8))))))).as("8 > 7 => true", new Object[0])).isTrue();
    }

    @Test
    public void testGreaterThanOrEqual() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.greaterThanOrEqual((String)"x", (Object)7));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null))).as("7 >= 7 => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null))).as("6 >= 7 => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8, 8, null))).as("8 >= 7 => true", new Object[0])).isTrue();
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.greaterThanOrEqual((String)"s1.s2.s3.s4.i", (Object)7));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7))))))).as("7 >= 7 => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(6))))))).as("6 >= 7 => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(8))))))).as("8 >= 7 => true", new Object[0])).isTrue();
    }

    @Test
    public void testEqual() {
        Assertions.assertThat((int)Expressions.equal((String)"x", (Object)5).literals().size()).isEqualTo(1);
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.equal((String)"x", (Object)7));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null))).as("7 == 7 => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null))).as("6 == 7 => false", new Object[0])).isFalse();
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.equal((String)"s1.s2.s3.s4.i", (Object)7));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7))))))).as("7 == 7 => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(6))))))).as("6 == 7 => false", new Object[0])).isFalse();
    }

    @Test
    public void testNotEqual() {
        Assertions.assertThat((int)Expressions.notEqual((String)"x", (Object)5).literals().size()).isEqualTo(1);
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.notEqual((String)"x", (Object)7));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null))).as("7 != 7 => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null))).as("6 != 7 => true", new Object[0])).isTrue();
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.notEqual((String)"s1.s2.s3.s4.i", (Object)7));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7))))))).as("7 != 7 => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(6))))))).as("6 != 7 => true", new Object[0])).isTrue();
    }

    @Test
    public void testStartsWith() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)24, (String)"s", (Type)Types.StringType.get())});
        Evaluator evaluator = new Evaluator(struct, (Expression)Expressions.startsWith((String)"s", (String)"abc"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("abc"))).as("abc startsWith abc should be true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("xabc"))).as("xabc startsWith abc should be false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("Abc"))).as("Abc startsWith abc should be false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("a"))).as("a startsWith abc should be false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("abcd"))).as("abcd startsWith abc should be true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(new Object[]{null}))).as("null startsWith abc should be false", new Object[0])).isFalse();
    }

    @Test
    public void testNotStartsWith() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)24, (String)"s", (Type)Types.StringType.get())});
        Evaluator evaluator = new Evaluator(struct, (Expression)Expressions.notStartsWith((String)"s", (String)"abc"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("abc"))).as("abc notStartsWith abc should be false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("xabc"))).as("xabc notStartsWith abc should be true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("Abc"))).as("Abc notStartsWith abc should be true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("a"))).as("a notStartsWith abc should be true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("abcde"))).as("abcde notStartsWith abc should be false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of("Abcde"))).as("Abcde notStartsWith abc should be true", new Object[0])).isTrue();
    }

    @Test
    public void testAlwaysTrue() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.alwaysTrue());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(new Object[0]))).as("always true", new Object[0])).isTrue();
    }

    @Test
    public void testAlwaysFalse() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.alwaysFalse());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(new Object[0]))).as("always false", new Object[0])).isFalse();
    }

    @Test
    public void testIsNull() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.isNull((String)"z"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(1, 2, null))).as("null is null", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(1, 2, 3))).as("3 is not null", new Object[0])).isFalse();
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.isNull((String)"s1.s2.s3.s4.i"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(1, 2, 3, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(3))))))).as("3 is not null", new Object[0])).isFalse();
    }

    @Test
    public void testNotNull() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.notNull((String)"z"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(1, 2, null))).as("null is null", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(1, 2, 3))).as("3 is not null", new Object[0])).isTrue();
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.notNull((String)"s1.s2.s3.s4.i"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(1, 2, 3, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(3))))))).as("3 is not null", new Object[0])).isTrue();
    }

    @Test
    public void testIsNan() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.isNaN((String)"y"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(1, Double.NaN, 3))).as("NaN is NaN", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(1, 2.0, 3))).as("2 is not NaN", new Object[0])).isFalse();
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.isNaN((String)"s5.s6.f"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(1, 2, 3, null, TestHelpers.Row.of(TestHelpers.Row.of(Float.valueOf(Float.NaN)))))).as("NaN is NaN", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(1, 2, 3, null, TestHelpers.Row.of(TestHelpers.Row.of(Float.valueOf(4.0f)))))).as("4F is not NaN", new Object[0])).isFalse();
    }

    @Test
    public void testNotNaN() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.notNaN((String)"y"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(1, Double.NaN, 3))).as("NaN is NaN", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(1, 2.0, 3))).as("2 is not NaN", new Object[0])).isTrue();
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.notNaN((String)"s5.s6.f"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(1, 2, 3, null, TestHelpers.Row.of(TestHelpers.Row.of(Float.valueOf(Float.NaN)))))).as("NaN is NaN", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(1, 2, 3, null, TestHelpers.Row.of(TestHelpers.Row.of(Float.valueOf(4.0f)))))).as("4F is not NaN", new Object[0])).isTrue();
    }

    @Test
    public void testAnd() {
        Evaluator evaluator = new Evaluator(STRUCT, Expressions.and((Expression)Expressions.equal((String)"x", (Object)7), (Expression)Expressions.notNull((String)"z")));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 0, 3))).as("7, 3 => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8, 0, 3))).as("8, 3 => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 0, null))).as("7, null => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8, 0, null))).as("8, null => false", new Object[0])).isFalse();
        Evaluator structEvaluator = new Evaluator(STRUCT, Expressions.and((Expression)Expressions.equal((String)"s1.s2.s3.s4.i", (Object)7), (Expression)Expressions.notNull((String)"s1.s2.s3.s4.i")));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 0, 3, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7))))))).as("7, 7 => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(8, 0, 3, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(8))))))).as("8, 8 => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 0, null, null))).as("7, null => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(8, 0, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(8))))))).as("8, notnull => false", new Object[0])).isFalse();
    }

    @Test
    public void testOr() {
        Evaluator evaluator = new Evaluator(STRUCT, Expressions.or((Expression)Expressions.equal((String)"x", (Object)7), (Expression)Expressions.notNull((String)"z")));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 0, 3))).as("7, 3 => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8, 0, 3))).as("8, 3 => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 0, null))).as("7, null => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8, 0, null))).as("8, null => false", new Object[0])).isFalse();
        Evaluator structEvaluator = new Evaluator(STRUCT, Expressions.or((Expression)Expressions.equal((String)"s1.s2.s3.s4.i", (Object)7), (Expression)Expressions.notNull((String)"s1.s2.s3.s4.i")));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 0, 3, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7))))))).as("7, 7 => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(8, 0, 3, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(8))))))).as("8, 8 => false", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 0, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7))))))).as("7, notnull => false", new Object[0])).isTrue();
    }

    @Test
    public void testNot() {
        Evaluator evaluator = new Evaluator(STRUCT, Expressions.not((Expression)Expressions.equal((String)"x", (Object)7)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7))).as("not(7 == 7) => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8))).as("not(8 == 7) => false", new Object[0])).isTrue();
        Evaluator structEvaluator = new Evaluator(STRUCT, Expressions.not((Expression)Expressions.equal((String)"s1.s2.s3.s4.i", (Object)7)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, null, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7))))))).as("not(7 == 7) => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(8, null, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(8))))))).as("not(8 == 7) => false", new Object[0])).isTrue();
    }

    @Test
    public void testCaseInsensitiveNot() {
        Evaluator evaluator = new Evaluator(STRUCT, Expressions.not((Expression)Expressions.equal((String)"X", (Object)7)), false);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7))).as("not(7 == 7) => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8))).as("not(8 == 7) => false", new Object[0])).isTrue();
        Evaluator structEvaluator = new Evaluator(STRUCT, Expressions.not((Expression)Expressions.equal((String)"s1.s2.s3.s4.i", (Object)7)), false);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, null, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7))))))).as("not(7 == 7) => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(8, null, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(8))))))).as("not(8 == 7) => false", new Object[0])).isTrue();
    }

    @Test
    public void testCaseSensitiveNot() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Evaluator(STRUCT, Expressions.not((Expression)Expressions.equal((String)"X", (Object)7)), true)).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'X' in struct");
    }

    @Test
    public void testCharSeqValue() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)34, (String)"s", (Type)Types.StringType.get())});
        Evaluator evaluator = new Evaluator(struct, (Expression)Expressions.equal((String)"s", (Object)"abc"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(new Utf8("abc")))).as("string(abc) == utf8(abc) => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(new Utf8("abcd")))).as("string(abc) == utf8(abcd) => false", new Object[0])).isFalse();
    }

    @Test
    public void testIn() {
        Assertions.assertThat((List)Expressions.in((String)"s", (Object[])new Integer[]{7, 8, 9}).literals()).hasSize(3);
        Assertions.assertThat((List)Expressions.in((String)"s", (Object[])new Number[]{7, 8.1, Long.MAX_VALUE}).literals()).hasSize(3);
        Assertions.assertThat((List)Expressions.in((String)"s", (Object[])new String[]{"abc", "abd", "abc"}).literals()).hasSize(3);
        Assertions.assertThat((List)Expressions.in((String)"s", (Object[])new Object[0]).literals()).isEmpty();
        Assertions.assertThat((List)Expressions.in((String)"s", (Object[])new Integer[]{5}).literals()).hasSize(1);
        Assertions.assertThat((List)Expressions.in((String)"s", (Object[])new Integer[]{5, 5}).literals()).hasSize(2);
        Assertions.assertThat((List)Expressions.in((String)"s", Arrays.asList(5, 5)).literals()).hasSize(2);
        Assertions.assertThat((List)Expressions.in((String)"s", Collections.emptyList()).literals()).isEmpty();
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.in((String)"x", (Object[])new Number[]{7, 8, Long.MAX_VALUE}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null))).as("7 in [7, 8] => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(9, 8, null))).as("9 in [7, 8]  => false", new Object[0])).isFalse();
        Evaluator intSetEvaluator = new Evaluator(STRUCT, (Expression)Expressions.in((String)"x", (Object[])new Number[]{Long.MAX_VALUE, Integer.MAX_VALUE, Long.MIN_VALUE}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)intSetEvaluator.eval((StructLike)TestHelpers.Row.of(Integer.MAX_VALUE, 7.0, null))).as("Integer.MAX_VALUE in [Integer.MAX_VALUE] => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)intSetEvaluator.eval((StructLike)TestHelpers.Row.of(6, 6.8, null))).as("6 in [Integer.MAX_VALUE]  => false", new Object[0])).isFalse();
        Evaluator integerEvaluator = new Evaluator(STRUCT, (Expression)Expressions.in((String)"y", (Object[])new Number[]{7, 8, 9.1}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)integerEvaluator.eval((StructLike)TestHelpers.Row.of(0, 7.0, null))).as("7.0 in [7, 8, 9.1] => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)integerEvaluator.eval((StructLike)TestHelpers.Row.of(7, 9.1, null))).as("9.1 in [7, 8, 9.1] => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)integerEvaluator.eval((StructLike)TestHelpers.Row.of(6, 6.8, null))).as("6.8 in [7, 8, 9.1]  => false", new Object[0])).isFalse();
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.in((String)"s1.s2.s3.s4.i", (Object[])new Integer[]{7, 8, 9}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7))))))).as("7 in [7, 8, 9] => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(6))))))).as("6 in [7, 8, 9]  => false", new Object[0])).isFalse();
        Types.StructType charSeqStruct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)34, (String)"s", (Type)Types.StringType.get())});
        Evaluator charSeqEvaluator = new Evaluator(charSeqStruct, (Expression)Expressions.in((String)"s", (Object[])new String[]{"abc", "abd", "abc"}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)charSeqEvaluator.eval((StructLike)TestHelpers.Row.of(new Utf8("abc")))).as("utf8(abc) in [string(abc), string(abd)] => true", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)charSeqEvaluator.eval((StructLike)TestHelpers.Row.of(new Utf8("abcd")))).as("utf8(abcd) in [string(abc), string(abd)] => false", new Object[0])).isFalse();
    }

    @Test
    public void testInExceptions() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.in((String)"x", (Object[])new Literal[]{null})).isInstanceOf(NullPointerException.class)).hasMessage("Cannot create expression literal from null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.in((String)"x", (Iterable)null)).isInstanceOf(NullPointerException.class)).hasMessage("Values cannot be null for IN predicate.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.in((String)"x", (Object[])new Integer[]{5, 6}).literal()).isInstanceOf(IllegalArgumentException.class)).hasMessage("IN predicate cannot return a literal");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.in((String)"x", (Object[])new Integer[]{1, 2, null})).isInstanceOf(NullPointerException.class)).hasMessage("Cannot create expression literal from null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Evaluator(STRUCT, (Expression)Expressions.in((String)"x", (Object[])new Number[]{7, 8, 9.1}))).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid value for conversion to type int");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.predicate((Expression.Operation)Expression.Operation.IN, (String)"x")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create IN predicate without a value");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Evaluator(STRUCT, (Expression)Expressions.predicate((Expression.Operation)Expression.Operation.IN, (String)"x", (Object)5.1))).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid value for conversion to type int");
    }

    @Test
    public void testNotIn() {
        Assertions.assertThat((List)Expressions.notIn((String)"s", (Object[])new Integer[]{7, 8, 9}).literals()).hasSize(3);
        Assertions.assertThat((List)Expressions.notIn((String)"s", (Object[])new Number[]{7, 8.1, Long.MAX_VALUE}).literals()).hasSize(3);
        Assertions.assertThat((List)Expressions.notIn((String)"s", (Object[])new String[]{"abc", "abd", "abc"}).literals()).hasSize(3);
        Assertions.assertThat((List)Expressions.notIn((String)"s", (Object[])new Object[0]).literals()).isEmpty();
        Assertions.assertThat((List)Expressions.notIn((String)"s", (Object[])new Integer[]{5}).literals()).hasSize(1);
        Assertions.assertThat((List)Expressions.notIn((String)"s", (Object[])new Integer[]{5, 5}).literals()).hasSize(2);
        Assertions.assertThat((List)Expressions.notIn((String)"s", Arrays.asList(5, 5)).literals()).hasSize(2);
        Assertions.assertThat((List)Expressions.notIn((String)"s", Collections.emptyList()).literals()).isEmpty();
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.notIn((String)"x", (Object[])new Number[]{7, 8, Long.MAX_VALUE}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null))).as("7 not in [7, 8] => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluator.eval((StructLike)TestHelpers.Row.of(9, 8, null))).as("6 not in [7, 8]  => true", new Object[0])).isTrue();
        Evaluator intSetEvaluator = new Evaluator(STRUCT, (Expression)Expressions.notIn((String)"x", (Object[])new Number[]{Long.MAX_VALUE, Integer.MAX_VALUE, Long.MIN_VALUE}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)intSetEvaluator.eval((StructLike)TestHelpers.Row.of(Integer.MAX_VALUE, 7.0, null))).as("Integer.MAX_VALUE not_in [Integer.MAX_VALUE] => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)intSetEvaluator.eval((StructLike)TestHelpers.Row.of(6, 6.8, null))).as("6 not_in [Integer.MAX_VALUE]  => true", new Object[0])).isTrue();
        Evaluator integerEvaluator = new Evaluator(STRUCT, (Expression)Expressions.notIn((String)"y", (Object[])new Number[]{7, 8, 9.1}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)integerEvaluator.eval((StructLike)TestHelpers.Row.of(0, 7.0, null))).as("7.0 not in [7, 8, 9] => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)integerEvaluator.eval((StructLike)TestHelpers.Row.of(7, 9.1, null))).as("9.1 not in [7, 8, 9.1] => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)integerEvaluator.eval((StructLike)TestHelpers.Row.of(6, 6.8, null))).as("6.8 not in [7, 8, 9.1]  => true", new Object[0])).isTrue();
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.notIn((String)"s1.s2.s3.s4.i", (Object[])new Integer[]{7, 8, 9}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7))))))).as("7 not in [7, 8, 9] => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(6))))))).as("6 not in [7, 8, 9]  => true", new Object[0])).isTrue();
        Types.StructType charSeqStruct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)34, (String)"s", (Type)Types.StringType.get())});
        Evaluator charSeqEvaluator = new Evaluator(charSeqStruct, (Expression)Expressions.notIn((String)"s", (Object[])new String[]{"abc", "abd", "abc"}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)charSeqEvaluator.eval((StructLike)TestHelpers.Row.of(new Utf8("abc")))).as("utf8(abc) not in [string(abc), string(abd)] => false", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)charSeqEvaluator.eval((StructLike)TestHelpers.Row.of(new Utf8("abcd")))).as("utf8(abcd) not in [string(abc), string(abd)] => true", new Object[0])).isTrue();
    }

    @Test
    public void testNotInExceptions() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.notIn((String)"x", (Object[])new Literal[]{null})).isInstanceOf(NullPointerException.class)).hasMessage("Cannot create expression literal from null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.notIn((String)"x", (Iterable)null)).isInstanceOf(NullPointerException.class)).hasMessage("Values cannot be null for NOT_IN predicate.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.notIn((String)"x", (Object[])new Integer[]{5, 6}).literal()).isInstanceOf(IllegalArgumentException.class)).hasMessage("NOT_IN predicate cannot return a literal");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.notIn((String)"x", (Object[])new Integer[]{1, 2, null})).isInstanceOf(NullPointerException.class)).hasMessage("Cannot create expression literal from null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Evaluator(STRUCT, (Expression)Expressions.notIn((String)"x", (Object[])new Number[]{7, 8, 9.1}))).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid value for conversion to type int");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.predicate((Expression.Operation)Expression.Operation.NOT_IN, (String)"x")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create NOT_IN predicate without a value");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Evaluator(STRUCT, (Expression)Expressions.predicate((Expression.Operation)Expression.Operation.NOT_IN, (String)"x", (Object)5.1))).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid value for conversion to type int");
    }
}

